/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator;

import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentBuilderApplicable;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

@LimitedVersionSupport(value=">= 1.21.4")
public interface ShadowColor
extends Wrapper,
ComponentBuilderApplicable,
RawValueHolder {
    public int red();

    public int green();

    public int blue();

    public int alpha();

    default public int compoundArgb() {
        return this.alpha() << 24 | this.red() << 16 | this.green() << 8 | this.blue();
    }

    @NotNull
    public String toString();

    @NotNull
    default public ShadowColor alpha(int alpha) {
        return ShadowColor.rgba(this.red(), this.green(), this.blue(), alpha);
    }

    @NotNull
    public static ShadowColor rgb(int red, int green, int blue) {
        return Spectator.getBackend().shadowArgb(1, red, green, blue);
    }

    @NotNull
    public static ShadowColor rgba(int red, int green, int blue, int alpha) {
        return Spectator.getBackend().shadowArgb(alpha, red, green, blue);
    }

    @NotNull
    public static ShadowColor argb(int compound) {
        return Spectator.getBackend().shadowArgb(compound >> 24 & 0xFF, compound >> 16 & 0xFF, compound >> 8 & 0xFF, compound & 0xFF);
    }

    @NotNull
    public static ShadowColor hexOrName(@NotNull String hex) {
        if ("grey".equalsIgnoreCase(hex)) {
            hex = "gray";
        } else if ("dark_grey".equalsIgnoreCase(hex)) {
            hex = "dark_gray";
        }
        Color value = Color.EXTENDED_NAMED_VALUES.get(hex.toLowerCase(Locale.ROOT));
        if (value != null) {
            return value.asShadow();
        }
        return Spectator.getBackend().shadowHex(hex);
    }

    @NotNull
    public static ShadowColor interpolate(float t, @NotNull ShadowColor a, @NotNull ShadowColor b) {
        float clampedT = Math.min(1.0f, Math.max(0.0f, t));
        int ar = a.red();
        int br = b.red();
        int ag = a.green();
        int bg = b.green();
        int ab = a.blue();
        int bb = b.blue();
        int aa = a.alpha();
        int ba = b.alpha();
        return ShadowColor.rgba(Math.round((float)ar + clampedT * (float)(br - ar)), Math.round((float)ag + clampedT * (float)(bg - ag)), Math.round((float)ab + clampedT * (float)(bb - ab)), Math.round((float)aa + clampedT * (float)(ba - aa)));
    }

    @Override
    default public <C extends Component, B extends Component.Builder<B, C>> void apply(@NotNull B builder) {
        builder.shadowColor(this);
    }

    @Override
    @NotNull
    default public Component applyTo(@NotNull Component component) {
        return component.withShadowColor(this);
    }
}

