/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.ide.LimitedVersionSupport;

public interface TranslatableComponent
extends Component {
    @Contract(value="-> new", pure=true)
    public static @NotNull Builder builder() {
        return Spectator.getBackend().translatable();
    }

    @NotNull
    public String translate();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent withTranslate(@NotNull String var1);

    @NotNull
    public List<Component> args();

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent withArgs(Component ... var1);

    @Contract(pure=true)
    @NotNull
    public TranslatableComponent withArgs(@NotNull Collection<Component> var1);

    @LimitedVersionSupport(value=">= 1.19.4")
    @Nullable
    public String fallback();

    @LimitedVersionSupport(value=">= 1.19.4")
    @Contract(pure=true)
    @NotNull
    public TranslatableComponent withFallback(@Nullable String var1);

    @Contract(value="-> new", pure=true)
    public @NotNull Builder toBuilder();

    public static interface Builder
    extends Component.Builder<Builder, TranslatableComponent> {
        @Contract(value="_ -> this")
        @NotNull
        public Builder translate(@NotNull String var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(Component ... var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder args(@NotNull Collection<Component> var1);

        @LimitedVersionSupport(value=">= 1.19.4")
        @Contract(value="_ -> this")
        @NotNull
        public Builder fallback(@Nullable String var1);
    }
}

