/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.audience;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.audience.adapter.Adapter;

public interface Audience {
    public void sendMessage(@NotNull ComponentLike var1);

    default public void sendRichMessage(@NotNull String message) {
        this.sendMessage(Component.fromMiniMessage(message));
    }

    default public void sendPlainMessage(@NotNull String message) {
        this.sendMessage(Component.text(message));
    }

    default public void sendPlainMessage(@NotNull String message, @NotNull Color color) {
        this.sendMessage(Component.text(message, color));
    }

    @FunctionalInterface
    @ApiStatus.NonExtendable
    public static interface ForwardingToAdapter
    extends Audience {
        @ApiStatus.OverrideOnly
        @NotNull
        public Adapter adapter();

        @Override
        default public void sendMessage(@NotNull ComponentLike message) {
            this.adapter().sendMessage(message);
        }
    }

    @FunctionalInterface
    public static interface ForwardingToSingle
    extends Audience {
        @ApiStatus.OverrideOnly
        @NotNull
        public Audience audience();

        @Override
        default public void sendMessage(@NotNull ComponentLike message) {
            this.audience().sendMessage(message);
        }
    }

    @FunctionalInterface
    public static interface ForwardingToMulti
    extends Audience {
        @ApiStatus.OverrideOnly
        @NotNull
        public @NotNull Iterable<? extends @NotNull Audience> audiences();

        @Override
        default public void sendMessage(@NotNull ComponentLike message) {
            this.audiences().forEach(audience -> audience.sendMessage(message));
        }
    }
}

