/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.MiniTagParser;
import sba.sl.minitag.nodes.Node;
import sba.sl.minitag.nodes.RootNode;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.minitag.nodes.TextNode;
import sba.sl.minitag.tags.RegisteredTag;
import sba.sl.minitag.tags.TagType;
import sba.sl.minitag.tags.TransformedTag;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.TextComponent;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.placeholders.StringLikePlaceholder;
import sba.sl.spectator.mini.resolvers.BoldResolver;
import sba.sl.spectator.mini.resolvers.ClickResolver;
import sba.sl.spectator.mini.resolvers.ColorResolver;
import sba.sl.spectator.mini.resolvers.DoubleTagResolver;
import sba.sl.spectator.mini.resolvers.FontResolver;
import sba.sl.spectator.mini.resolvers.GradientResolver;
import sba.sl.spectator.mini.resolvers.HoverResolver;
import sba.sl.spectator.mini.resolvers.InsertionResolver;
import sba.sl.spectator.mini.resolvers.ItalicResolver;
import sba.sl.spectator.mini.resolvers.KeybindResolver;
import sba.sl.spectator.mini.resolvers.NbtResolver;
import sba.sl.spectator.mini.resolvers.ObfuscatedResolver;
import sba.sl.spectator.mini.resolvers.PrideResolver;
import sba.sl.spectator.mini.resolvers.RainbowResolver;
import sba.sl.spectator.mini.resolvers.ScoreResolver;
import sba.sl.spectator.mini.resolvers.SelectorResolver;
import sba.sl.spectator.mini.resolvers.ShadowColorResolver;
import sba.sl.spectator.mini.resolvers.SingleTagResolver;
import sba.sl.spectator.mini.resolvers.StrikethroughResolver;
import sba.sl.spectator.mini.resolvers.TransitionResolver;
import sba.sl.spectator.mini.resolvers.TranslatableFallbackResolver;
import sba.sl.spectator.mini.resolvers.TranslatableResolver;
import sba.sl.spectator.mini.resolvers.UnderlinedResolver;
import sba.sl.spectator.mini.transformers.NegatedDecorationTransformer;
import sba.sl.spectator.mini.transformers.NegatedShadowColorTransformer;
import sba.sl.spectator.mini.transformers.TagToAttributeTransformer;

public final class MiniMessageParser {
    @NotNull
    public static final MiniMessageParser INSTANCE = MiniMessageParser.builder().defaultStylingTags().defaultComponentTags().resetTag(true).strictClosing(false).build();
    @NotNull
    private final MiniTagParser parser;
    @NotNull
    private final MiniTagParser placeholderOnlyParser;
    @NotNull
    private final @NotNull Map<@NotNull String, SingleTagResolver> singleTagResolvers;
    @NotNull
    private final @NotNull Map<@NotNull String, DoubleTagResolver> doubleTagResolvers;

    @NotNull
    public Component parse(@NotNull String str, Placeholder ... placeholders) {
        if (str.isEmpty()) {
            return Component.empty();
        }
        RootNode resolved = this.parser.parse(str);
        if (!resolved.hasChildren()) {
            return Component.empty();
        }
        if (resolved.children().size() == 1) {
            return this.resolveChildren(resolved.children().get(0), placeholders).build();
        }
        return ((TextComponent.Builder)Component.text().append(resolved.children().stream().map(node -> this.resolveChildren((Node)node, placeholders).build()).collect(Collectors.toList()))).build();
    }

    @ApiStatus.Internal
    @NotNull
    public <B extends Component.Builder<B, C>, C extends Component> B parseIntoBuilder(@NotNull String str, Placeholder ... placeholders) {
        if (str.isEmpty()) {
            return (B)Component.text();
        }
        RootNode resolved = this.parser.parse(str);
        if (!resolved.hasChildren()) {
            return (B)Component.text();
        }
        if (resolved.children().size() == 1) {
            return this.resolveChildren(resolved.children().get(0), placeholders);
        }
        return Component.text().append(resolved.children().stream().map(node -> this.resolveChildren((Node)node, placeholders).build()).collect(Collectors.toList()));
    }

    @ApiStatus.Internal
    @NotNull
    public String resolvePlaceholdersInString(@NotNull String str, Placeholder ... placeholders) {
        StringLikePlaceholder[] stringlikePlaceholders = (StringLikePlaceholder[])Arrays.stream(placeholders).filter(placeholder -> placeholder instanceof StringLikePlaceholder).toArray(StringLikePlaceholder[]::new);
        return this.resolvePlaceholdersInString(str, stringlikePlaceholders);
    }

    @ApiStatus.Internal
    @NotNull
    public String resolvePlaceholdersInString(@NotNull String str, StringLikePlaceholder ... placeholders) {
        RootNode resolved = this.placeholderOnlyParser.parse(str);
        if (!resolved.hasChildren()) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        for (Node child : resolved.children()) {
            this.resolveStringChildren(child, builder, placeholders);
        }
        return builder.toString();
    }

    private void resolveStringChildren(@NotNull Node node, @NotNull StringBuilder builder, StringLikePlaceholder ... placeholders) {
        if (node instanceof TextNode) {
            builder.append(((TextNode)node).getText());
        } else if (node instanceof TagNode) {
            if (node.hasChildren()) {
                List<Node> resolved = node.children();
                for (Node child : resolved) {
                    this.resolveStringChildren(child, builder, placeholders);
                }
            } else {
                for (StringLikePlaceholder p : placeholders) {
                    if (!p.getName().equals(((TagNode)node).getTag())) continue;
                    builder.append(p.getStringResult(this, ((TagNode)node).getArgs(), placeholders));
                    return;
                }
                builder.append(this.parser.tagOpeningSymbol()).append(((TagNode)node).getTag()).append(!((TagNode)node).getArgs().isEmpty() ? ":" : "").append(String.join((CharSequence)":", ((TagNode)node).getArgs())).append(this.parser.tagClosingSymbol());
            }
        } else {
            throw new IllegalArgumentException("Unknown node type!");
        }
    }

    private <B extends Component.Builder<B, C>, C extends Component> B resolveChildren(Node node, Placeholder ... placeholders) {
        if (node instanceof TextNode) {
            return (B)Component.text().content(((TextNode)node).getText());
        }
        if (node instanceof TagNode) {
            if (this.singleTagResolvers.containsKey(((TagNode)node).getTag().toLowerCase(Locale.ROOT))) {
                if (node.hasChildren()) {
                    throw new IllegalArgumentException("Tags defining non-text components can't be pair tags!");
                }
                Object comp = this.singleTagResolvers.get(((TagNode)node).getTag().toLowerCase(Locale.ROOT)).resolve(this, (TagNode)node, placeholders);
                if (comp != null) {
                    return comp;
                }
            } else if (this.doubleTagResolvers.containsKey(((TagNode)node).getTag().toLowerCase(Locale.ROOT))) {
                DoubleTagResolver res = this.doubleTagResolvers.get(((TagNode)node).getTag().toLowerCase(Locale.ROOT));
                if (node.hasChildren()) {
                    List<Node> resolved = node.children();
                    if (resolved.size() == 1) {
                        B child = this.resolveChildren(resolved.get(0), placeholders);
                        if (child.hasStyling()) {
                            Object component = Component.text().append((ComponentLike)child);
                            return (B)((Component.Builder)Objects.requireNonNullElse(res.resolve(this, component, (TagNode)node, placeholders), component));
                        }
                        return (B)((Component.Builder)Objects.requireNonNullElse(res.resolve(this, child, (TagNode)node, placeholders), child));
                    }
                    TextComponent.Builder component = Component.text();
                    return ((Component.Builder)Objects.requireNonNullElse(res.resolve(this, component, (TagNode)node, placeholders), component)).append(resolved.stream().map(n -> this.resolveChildren((Node)n, placeholders).build()).collect(Collectors.toList()));
                }
                TextComponent.Builder component = Component.text();
                return (B)Objects.requireNonNullElse(res.resolve(this, component, (TagNode)node, placeholders), component);
            }
            if (node.hasChildren()) {
                List<Node> resolved = node.children();
                if (resolved.size() == 1) {
                    return this.resolveChildren(resolved.get(0), placeholders);
                }
                return Component.text().append(resolved.stream().map(n -> this.resolveChildren((Node)n, placeholders).build()).collect(Collectors.toList()));
            }
            for (Placeholder p : placeholders) {
                if (!p.getName().equals(((TagNode)node).getTag())) continue;
                return p.getResult(this, ((TagNode)node).getArgs(), placeholders);
            }
            return (B)Component.text().content(this.parser.tagOpeningSymbol() + ((TagNode)node).getTag() + (!((TagNode)node).getArgs().isEmpty() ? ":" : "") + String.join((CharSequence)":", ((TagNode)node).getArgs()) + this.parser.tagClosingSymbol());
        }
        throw new IllegalArgumentException("Unknown node type!");
    }

    @NotNull
    public String serialize(@NotNull Component component) {
        RootNode root = new RootNode();
        this.visitComponent(root, component);
        return this.parser.serialize(root);
    }

    private void visitComponent(@NotNull Node parent, @NotNull Component component) {
        String content;
        TagNode tag = null;
        for (Map.Entry<String, DoubleTagResolver> resolver : this.doubleTagResolvers.entrySet()) {
            TagNode tagNode = resolver.getValue().serialize(this, (String)resolver.getKey(), component);
            if (tagNode == null) continue;
            Objects.requireNonNullElse(tag, parent).putChildren(tagNode);
            tag = tagNode;
        }
        boolean serialized = false;
        for (Map.Entry entry : this.singleTagResolvers.entrySet()) {
            TagNode t = ((SingleTagResolver)entry.getValue()).serialize(this, (String)entry.getKey(), component);
            if (t == null) continue;
            Objects.requireNonNullElse(tag, parent).putChildren(t);
            serialized = true;
            break;
        }
        if (!serialized && component instanceof TextComponent && !(content = ((TextComponent)component).content()).isEmpty()) {
            TextNode textNode = new TextNode(content);
            Objects.requireNonNullElse(tag, parent).putChildren(textNode);
        }
        for (Component component2 : component.children()) {
            this.visitComponent(Objects.requireNonNullElse(tag, parent), component2);
        }
    }

    @NotNull
    public static Builder builder() {
        return new Builder();
    }

    @NotNull
    @Generated
    public MiniTagParser getParser() {
        return this.parser;
    }

    @NotNull
    @Generated
    public MiniTagParser getPlaceholderOnlyParser() {
        return this.placeholderOnlyParser;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull String, SingleTagResolver> getSingleTagResolvers() {
        return this.singleTagResolvers;
    }

    @NotNull
    @Generated
    public @NotNull Map<@NotNull String, DoubleTagResolver> getDoubleTagResolvers() {
        return this.doubleTagResolvers;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MiniMessageParser)) {
            return false;
        }
        MiniMessageParser other = (MiniMessageParser)o;
        MiniTagParser this$parser = this.getParser();
        MiniTagParser other$parser = other.getParser();
        if (this$parser == null ? other$parser != null : !((Object)this$parser).equals(other$parser)) {
            return false;
        }
        MiniTagParser this$placeholderOnlyParser = this.getPlaceholderOnlyParser();
        MiniTagParser other$placeholderOnlyParser = other.getPlaceholderOnlyParser();
        if (this$placeholderOnlyParser == null ? other$placeholderOnlyParser != null : !((Object)this$placeholderOnlyParser).equals(other$placeholderOnlyParser)) {
            return false;
        }
        Map<String, SingleTagResolver> this$singleTagResolvers = this.getSingleTagResolvers();
        Map<String, SingleTagResolver> other$singleTagResolvers = other.getSingleTagResolvers();
        if (this$singleTagResolvers == null ? other$singleTagResolvers != null : !((Object)this$singleTagResolvers).equals(other$singleTagResolvers)) {
            return false;
        }
        Map<String, DoubleTagResolver> this$doubleTagResolvers = this.getDoubleTagResolvers();
        Map<String, DoubleTagResolver> other$doubleTagResolvers = other.getDoubleTagResolvers();
        return !(this$doubleTagResolvers == null ? other$doubleTagResolvers != null : !((Object)this$doubleTagResolvers).equals(other$doubleTagResolvers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MiniTagParser $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : ((Object)$parser).hashCode());
        MiniTagParser $placeholderOnlyParser = this.getPlaceholderOnlyParser();
        result = result * 59 + ($placeholderOnlyParser == null ? 43 : ((Object)$placeholderOnlyParser).hashCode());
        Map<String, SingleTagResolver> $singleTagResolvers = this.getSingleTagResolvers();
        result = result * 59 + ($singleTagResolvers == null ? 43 : ((Object)$singleTagResolvers).hashCode());
        Map<String, DoubleTagResolver> $doubleTagResolvers = this.getDoubleTagResolvers();
        result = result * 59 + ($doubleTagResolvers == null ? 43 : ((Object)$doubleTagResolvers).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MiniMessageParser(parser=" + String.valueOf(this.getParser()) + ", placeholderOnlyParser=" + String.valueOf(this.getPlaceholderOnlyParser()) + ", singleTagResolvers=" + String.valueOf(this.getSingleTagResolvers()) + ", doubleTagResolvers=" + String.valueOf(this.getDoubleTagResolvers()) + ")";
    }

    @Generated
    private MiniMessageParser(@NotNull MiniTagParser parser, @NotNull MiniTagParser placeholderOnlyParser, @NotNull @NotNull Map<@NotNull String, SingleTagResolver> singleTagResolvers, @NotNull @NotNull Map<@NotNull String, DoubleTagResolver> doubleTagResolvers) {
        if (parser == null) {
            throw new NullPointerException("parser is marked non-null but is null");
        }
        if (placeholderOnlyParser == null) {
            throw new NullPointerException("placeholderOnlyParser is marked non-null but is null");
        }
        if (singleTagResolvers == null) {
            throw new NullPointerException("singleTagResolvers is marked non-null but is null");
        }
        if (doubleTagResolvers == null) {
            throw new NullPointerException("doubleTagResolvers is marked non-null but is null");
        }
        this.parser = parser;
        this.placeholderOnlyParser = placeholderOnlyParser;
        this.singleTagResolvers = singleTagResolvers;
        this.doubleTagResolvers = doubleTagResolvers;
    }

    public static class Builder {
        private final @NotNull MiniTagParser.Builder miniTagParserBuilder = MiniTagParser.builder();
        private final @NotNull MiniTagParser.Builder placeholderOnlyParserBuilder = MiniTagParser.builder().resetTag(false).strictClosing(false).escapeInvalidEndings(true).preTag(false).unknownTagType(TagType.SINGLE);
        @NotNull
        private final @NotNull Map<@NotNull String, SingleTagResolver> singleTagResolvers = new HashMap<String, SingleTagResolver>();
        @NotNull
        private final @NotNull Map<@NotNull String, DoubleTagResolver> doubleTagResolvers = new HashMap<String, DoubleTagResolver>();

        @Contract(value="_ -> this")
        @NotNull
        public Builder strictClosing(boolean strictClosing) {
            this.miniTagParserBuilder.strictClosing(strictClosing);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder escapeInvalidEndings(boolean escapeInvalidEndings) {
            this.miniTagParserBuilder.escapeInvalidEndings(escapeInvalidEndings);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder preTag(@Nullable String preTag) {
            this.miniTagParserBuilder.preTag(preTag);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder preTag(boolean enablePreTag) {
            this.miniTagParserBuilder.preTag(enablePreTag);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder resetTag(@Nullable String resetTag) {
            this.miniTagParserBuilder.resetTag(resetTag);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder resetTag(boolean enableResetTag) {
            this.miniTagParserBuilder.resetTag(enableResetTag);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder escapeSymbol(char escapeSymbol) {
            this.miniTagParserBuilder.escapeSymbol(escapeSymbol);
            this.placeholderOnlyParserBuilder.escapeSymbol(escapeSymbol);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder tagOpeningSymbol(char tagOpeningSymbol) {
            this.miniTagParserBuilder.tagOpeningSymbol(tagOpeningSymbol);
            this.placeholderOnlyParserBuilder.tagOpeningSymbol(tagOpeningSymbol);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder tagClosingSymbol(char tagClosingSymbol) {
            this.miniTagParserBuilder.tagClosingSymbol(tagClosingSymbol);
            this.placeholderOnlyParserBuilder.tagClosingSymbol(tagClosingSymbol);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder endingTagSymbol(char endingTagSymbol) {
            this.miniTagParserBuilder.endingTagSymbol(endingTagSymbol);
            this.placeholderOnlyParserBuilder.endingTagSymbol(endingTagSymbol);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder argumentSeparator(char argumentSeparator) {
            this.miniTagParserBuilder.argumentSeparator(argumentSeparator);
            this.placeholderOnlyParserBuilder.argumentSeparator(argumentSeparator);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder quotes(List<Character> quotes) {
            this.miniTagParserBuilder.quotes(quotes);
            this.placeholderOnlyParserBuilder.quotes(quotes);
            return this;
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder quotes(Character ... quotes) {
            this.miniTagParserBuilder.quotes(quotes);
            this.placeholderOnlyParserBuilder.quotes(quotes);
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        public Builder registerStylingTag(String name, DoubleTagResolver resolver, String ... aliases) {
            this.miniTagParserBuilder.registerTag(name, TagType.PAIR, aliases);
            this.doubleTagResolvers.put(name, resolver);
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        public Builder registerComponentTag(String name, SingleTagResolver resolver, String ... aliases) {
            this.miniTagParserBuilder.registerTag(name, TagType.SINGLE, aliases);
            this.singleTagResolvers.put(name, resolver);
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder registerPlaceholder(Placeholder placeholder, String ... aliases) {
            this.registerComponentTag(placeholder.getName(), placeholder, aliases);
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        public Builder putStylingAlias(String name, TransformedTag.Transformer transformer, String ... aliases) {
            this.miniTagParserBuilder.registerTag(name, new TransformedTag(TagType.PAIR, transformer), aliases);
            return this;
        }

        @Contract(value="-_, _ > this")
        @NotNull
        public Builder putStylingAlias(Pattern pattern, TransformedTag.Transformer transformer) {
            this.miniTagParserBuilder.registerTag(pattern, (RegisteredTag)new TransformedTag(TagType.PAIR, transformer));
            return this;
        }

        @Contract(value="_, _, _ -> this")
        @NotNull
        public Builder putComponentAlias(String name, TransformedTag.Transformer transformer, String ... aliases) {
            this.miniTagParserBuilder.registerTag(name, new TransformedTag(TagType.SINGLE, transformer), aliases);
            return this;
        }

        @Contract(value="_, _ -> this")
        @NotNull
        public Builder putComponentAlias(Pattern pattern, TransformedTag.Transformer transformer) {
            this.miniTagParserBuilder.registerTag(pattern, (RegisteredTag)new TransformedTag(TagType.SINGLE, transformer));
            return this;
        }

        @Contract(value="-> this")
        @NotNull
        public Builder defaultStylingTags() {
            return this.defaultStylingTags(true);
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder defaultStylingTags(boolean bedrockColorNames) {
            this.registerStylingTag("color", new ColorResolver(), "colour", "c");
            TagToAttributeTransformer colorTransformer = new TagToAttributeTransformer("color");
            this.putStylingAlias("black", colorTransformer, new String[0]);
            this.putStylingAlias("dark_blue", colorTransformer, new String[0]);
            this.putStylingAlias("dark_green", colorTransformer, new String[0]);
            this.putStylingAlias("dark_aqua", colorTransformer, new String[0]);
            this.putStylingAlias("dark_red", colorTransformer, new String[0]);
            this.putStylingAlias("dark_purple", colorTransformer, new String[0]);
            this.putStylingAlias("gold", colorTransformer, new String[0]);
            this.putStylingAlias("gray", colorTransformer, "grey");
            this.putStylingAlias("dark_gray", colorTransformer, "dark_grey");
            this.putStylingAlias("blue", colorTransformer, new String[0]);
            this.putStylingAlias("green", colorTransformer, new String[0]);
            this.putStylingAlias("aqua", colorTransformer, new String[0]);
            this.putStylingAlias("red", colorTransformer, new String[0]);
            this.putStylingAlias("light_purple", colorTransformer, new String[0]);
            this.putStylingAlias("yellow", colorTransformer, new String[0]);
            this.putStylingAlias("white", colorTransformer, new String[0]);
            if (bedrockColorNames) {
                this.putStylingAlias("minecoin_gold", colorTransformer, new String[0]);
                this.putStylingAlias("material_quartz", colorTransformer, new String[0]);
                this.putStylingAlias("material_iron", colorTransformer, new String[0]);
                this.putStylingAlias("material_netherite", colorTransformer, new String[0]);
                this.putStylingAlias("material_redstone", colorTransformer, new String[0]);
                this.putStylingAlias("material_copper", colorTransformer, new String[0]);
                this.putStylingAlias("material_gold", colorTransformer, new String[0]);
                this.putStylingAlias("material_emerald", colorTransformer, new String[0]);
                this.putStylingAlias("material_diamond", colorTransformer, new String[0]);
                this.putStylingAlias("material_lapis", colorTransformer, new String[0]);
                this.putStylingAlias("material_amethyst", colorTransformer, new String[0]);
            }
            this.putStylingAlias(Pattern.compile("#([\\dA-Fa-f]{6}|[\\dA-Fa-f]{3})"), colorTransformer);
            this.registerStylingTag("bold", new BoldResolver(), "b");
            this.registerStylingTag("italic", new ItalicResolver(), "i", "em");
            this.registerStylingTag("underlined", new UnderlinedResolver(), "u");
            this.registerStylingTag("strikethrough", new StrikethroughResolver(), "st");
            this.registerStylingTag("obfuscated", new ObfuscatedResolver(), "obf");
            NegatedDecorationTransformer negatedDecorationTransformer = new NegatedDecorationTransformer();
            this.putStylingAlias("!bold", negatedDecorationTransformer, "!b");
            this.putStylingAlias("!italic", negatedDecorationTransformer, "!i", "!em");
            this.putStylingAlias("!underlined", negatedDecorationTransformer, "!u");
            this.putStylingAlias("!strikethrough", negatedDecorationTransformer, "!st");
            this.putStylingAlias("!obfuscated", negatedDecorationTransformer, "!obf");
            this.registerStylingTag("shadow", new ShadowColorResolver(), new String[0]);
            this.putStylingAlias("!shadow", new NegatedShadowColorTransformer(), new String[0]);
            this.registerStylingTag("click", new ClickResolver(), new String[0]);
            this.registerStylingTag("hover", new HoverResolver(), new String[0]);
            this.registerStylingTag("insertion", new InsertionResolver(), "insert");
            this.registerStylingTag("rainbow", new RainbowResolver(), new String[0]);
            this.registerStylingTag("gradient", new GradientResolver(), new String[0]);
            this.registerStylingTag("transition", new TransitionResolver(), new String[0]);
            this.registerStylingTag("font", new FontResolver(), new String[0]);
            this.registerStylingTag("pride", new PrideResolver(), new String[0]);
            return this;
        }

        @Contract(value="-> this")
        @NotNull
        public Builder defaultComponentTags() {
            this.registerComponentTag("selector", new SelectorResolver(), "sel");
            this.registerComponentTag("lang", new TranslatableResolver(), "tr", "translate");
            this.registerComponentTag("lang_or", new TranslatableFallbackResolver(), "tr_or", "translate_or");
            this.registerComponentTag("nbt", new NbtResolver(), "data");
            this.registerComponentTag("key", new KeybindResolver(), new String[0]);
            this.registerComponentTag("score", new ScoreResolver(), new String[0]);
            this.registerPlaceholder(Placeholder.component("newline", Component.newLine()), "br");
            return this;
        }

        @Contract(value="-> new", pure=true)
        @NotNull
        public MiniMessageParser build() {
            return new MiniMessageParser(this.miniTagParserBuilder.build(), this.placeholderOnlyParserBuilder.build(), Map.copyOf(this.singleTagResolvers), Map.copyOf(this.doubleTagResolvers));
        }
    }
}

