/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.Color;
import sba.sl.spectator.mini.resolvers.ColorChangingResolver;

public class GradientResolver
extends ColorChangingResolver {
    @Override
    @Nullable
    protected ColorChangingResolver.TagInstance obtainNewTagInstance(@NotNull TagNode tag) {
        boolean negativePhase;
        List<Object> colors;
        float phase = 0.0f;
        Iterator<String> args = tag.getArgs().iterator();
        if (args.hasNext()) {
            colors = new ArrayList();
            while (args.hasNext()) {
                String value = args.next();
                if (!args.hasNext()) {
                    try {
                        phase = (float)Double.parseDouble(value);
                        if (phase < -1.0f || phase > 1.0f) {
                            return null;
                        }
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                colors.add(Color.hexOrName(value));
            }
            if (colors.size() < 2) {
                return null;
            }
        } else {
            colors = List.of(Color.WHITE, Color.BLACK);
        }
        boolean bl = negativePhase = phase < 0.0f;
        if (negativePhase) {
            phase += 1.0f;
            Collections.reverse(colors);
        }
        final float finalPhase = phase;
        return new ColorChangingResolver.TagInstance(){
            private int index;
            private int colorIndex;
            private float factorStep;
            private float phase;

            @Override
            public void init(int size) {
                int sectorLength = size / (colors.size() - 1);
                if (sectorLength < 1) {
                    sectorLength = 1;
                }
                this.factorStep = 1.0f / (float)(sectorLength + this.index);
                this.phase = finalPhase * (float)sectorLength;
            }

            @Override
            public void advanceColor() {
                ++this.index;
                if (this.factorStep * (float)this.index > 1.0f) {
                    ++this.colorIndex;
                    this.index = 0;
                }
            }

            @Override
            @NotNull
            public Color color() {
                float factor = this.factorStep * ((float)this.index + this.phase);
                if (factor > 1.0f) {
                    factor = 1.0f - (factor - 1.0f);
                }
                if (negativePhase && colors.size() % 2 != 0) {
                    return Color.interpolate(factor, (Color)colors.get(this.colorIndex + 1), (Color)colors.get(this.colorIndex));
                }
                return Color.interpolate(factor, (Color)colors.get(this.colorIndex), (Color)colors.get(this.colorIndex + 1));
            }
        };
    }
}

