/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.Color;
import sba.sl.spectator.mini.resolvers.ColorChangingResolver;

public class PrideResolver
extends ColorChangingResolver {
    private static final Map<String, List<Color>> FLAGS = new HashMap<String, List<Color>>();

    @Override
    @Nullable
    protected ColorChangingResolver.TagInstance obtainNewTagInstance(@NotNull TagNode tag) {
        Iterator<String> args = tag.getArgs().iterator();
        @NotNull String flagName = args.hasNext() ? args.next().toLowerCase(Locale.ROOT) : "pride";
        final List<Color> colors = FLAGS.get(flagName);
        return new ColorChangingResolver.TagInstance(){
            private int index;
            private int colorIndex;
            private float factorStep;
            private float phase;

            @Override
            public void init(int size) {
                int sectorLength = size / (colors.size() - 1);
                if (sectorLength < 1) {
                    sectorLength = 1;
                }
                this.factorStep = 1.0f / (float)(sectorLength + this.index);
                this.phase = 0.0f;
            }

            @Override
            public void advanceColor() {
                ++this.index;
                if (this.factorStep * (float)this.index > 1.0f) {
                    ++this.colorIndex;
                    this.index = 0;
                }
            }

            @Override
            @NotNull
            public Color color() {
                float factor = this.factorStep * ((float)this.index + this.phase);
                if (factor > 1.0f) {
                    factor = 1.0f - (factor - 1.0f);
                }
                return Color.interpolate(factor, (Color)colors.get(this.colorIndex), (Color)colors.get(this.colorIndex + 1));
            }
        };
    }

    @NotNull
    private static List<Color> colors(int ... colors) {
        return Arrays.stream(colors).mapToObj(Color::rgb).collect(Collectors.toList());
    }

    static {
        FLAGS.put("pride", PrideResolver.colors(0xE50000, 16747776, 0xFFEE00, 164129, 19711, 0x770088));
        FLAGS.put("progress", PrideResolver.colors(0xFFFFFF, 16756679, 7591918, 6371605, 0, 0xE50000, 16747776, 0xFFEE00, 164129, 19711, 0x770088));
        FLAGS.put("trans", PrideResolver.colors(6017019, 16100281, 0xFFFFFF, 16100281, 6017019));
        FLAGS.put("bi", PrideResolver.colors(14025328, 10178454, 14504));
        FLAGS.put("pan", PrideResolver.colors(16718989, 16766720, 1750015));
        FLAGS.put("nb", PrideResolver.colors(16577585, 0xFCFCFC, 10312146, 0x282828));
        FLAGS.put("lesbian", PrideResolver.colors(14034944, 16751446, 0xFFFFFF, 13918886, 10748002));
        FLAGS.put("ace", PrideResolver.colors(0, 0xA4A4A4, 0xFFFFFF, 0x810081));
        FLAGS.put("agender", PrideResolver.colors(0, 0xBABABA, 0xFFFFFF, 12252292, 0xFFFFFF, 0xBABABA, 0));
        FLAGS.put("demisexual", PrideResolver.colors(0, 0xFFFFFF, 7209073, 0xD3D3D3));
        FLAGS.put("genderqueer", PrideResolver.colors(11894749, 0xFFFFFF, 4817438));
        FLAGS.put("genderfluid", PrideResolver.colors(16676514, 0xFFFFFF, 12522199, 0, 3161278));
        FLAGS.put("intersex", PrideResolver.colors(16766976, 7930538, 16766976));
        FLAGS.put("aro", PrideResolver.colors(3909440, 11064442, 0xFFFFFF, 0xABABAB, 0));
        FLAGS.put("baker", PrideResolver.colors(13461247, 16737689, 0xFE0000, 16685312, 0xFFFF01, 39168, 39371, 3473561, 0x990099));
        FLAGS.put("philly", PrideResolver.colors(0, 7884567, 0xFE0000, 16616448, 16770304, 1154827, 410803, 12725980));
        FLAGS.put("queer", PrideResolver.colors(0, 10148330, 41960, 11920669, 0xFFFFFF, 16763149, 16541287, 16690889, 0));
        FLAGS.put("gay", PrideResolver.colors(495216, 2543274, 10021057, 0xFFFFFF, 8105442, 5261771, 4004472));
        FLAGS.put("bigender", PrideResolver.colors(12876192, 15509195, 14010344, 0xFFFFFF, 14010344, 10143720, 7111631));
        FLAGS.put("demigender", PrideResolver.colors(0x7F7F7F, 0xC3C3C3, 16514932, 0xFFFFFF, 16514932, 0xC3C3C3, 0x7F7F7F));
    }
}

