/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.Color;
import sba.sl.spectator.mini.resolvers.ColorChangingResolver;

public class RainbowResolver
extends ColorChangingResolver {
    @Override
    @Nullable
    protected ColorChangingResolver.TagInstance obtainNewTagInstance(@NotNull TagNode tag) {
        boolean reversed = false;
        int phase = 1;
        if (tag.getArgs().size() >= 1) {
            String value = tag.getArgs().get(0);
            if (value.startsWith("!")) {
                reversed = true;
                value = value.substring(1);
            }
            if (!value.isEmpty()) {
                try {
                    phase = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        final boolean finalReversed = reversed;
        final int finalPhase = phase;
        return new ColorChangingResolver.TagInstance(){
            private int size;
            private double frequency = 1.0;
            private int colorIndex;

            @Override
            public void init(int size) {
                this.size = size;
                this.frequency = Math.PI * 2 / (double)size;
                if (finalReversed) {
                    this.colorIndex = size - 1;
                }
            }

            @Override
            public void advanceColor() {
                this.colorIndex = finalReversed ? (this.colorIndex == 0 ? this.size - 1 : --this.colorIndex) : ++this.colorIndex;
            }

            @Override
            @NotNull
            public Color color() {
                int index = this.colorIndex;
                int red = (int)(Math.sin(this.frequency * (double)index + 2.0 + (double)finalPhase) * 127.0 + 128.0);
                int green = (int)(Math.sin(this.frequency * (double)index + 0.0 + (double)finalPhase) * 127.0 + 128.0);
                int blue = (int)(Math.sin(this.frequency * (double)index + 4.0 + (double)finalPhase) * 127.0 + 128.0);
                return Color.rgb(red, green, blue);
            }
        };
    }
}

