/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.mini.resolvers;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.minitag.nodes.TagNode;
import sba.sl.spectator.Component;
import sba.sl.spectator.ShadowColor;
import sba.sl.spectator.mini.MiniMessageParser;
import sba.sl.spectator.mini.placeholders.Placeholder;
import sba.sl.spectator.mini.resolvers.StylingResolver;

public class ShadowColorResolver
implements StylingResolver {
    @Override
    public <B extends Component.Builder<B, C>, C extends Component> void applyStyle(@NotNull MiniMessageParser parser, @NotNull B builder, @NotNull TagNode tag, Placeholder ... placeholders) {
        if (tag.getArgs().isEmpty()) {
            return;
        }
        ShadowColor shadowColor = ShadowColor.hexOrName(tag.getArgs().get(0));
        if (tag.getArgs().size() > 1) {
            try {
                float alpha = Float.parseFloat(tag.getArgs().get(1));
                shadowColor = shadowColor.alpha((int)(alpha * 255.0f));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        builder.shadowColor(shadowColor);
    }

    @Override
    @Nullable
    public TagNode serialize(@NotNull MiniMessageParser parser, @NotNull String tagName, @NotNull Component component) {
        if (component.shadowColor() != null) {
            return new TagNode(tagName, List.of(component.shadowColor().toString()));
        }
        return null;
    }
}

