/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.sound;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;
import sba.sl.impl.spectator.Spectator;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.u.RawValueHolder;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.ide.LimitedVersionSupport;
import sba.sl.u.annotations.ide.MinecraftType;

public interface SoundStart
extends Wrapper,
RawValueHolder {
    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static SoundStart sound(@MinecraftType(value=MinecraftType.Type.SOUND) @NotNull ResourceLocation soundKey, @NotNull SoundSource soundSource, float volume, float pitch) {
        return SoundStart.builder().soundKey(soundKey).source(soundSource).volume(volume).pitch(pitch).build();
    }

    @Contract(value="_, _, _, _ -> new", pure=true)
    @NotNull
    public static SoundStart sound(@MinecraftType(value=MinecraftType.Type.SOUND) @NotNull String soundKey, @NotNull SoundSource soundSource, float volume, float pitch) {
        return SoundStart.builder().soundKey(soundKey).source(soundSource).volume(volume).pitch(pitch).build();
    }

    @Contract(value="-> new", pure=true)
    public static @NotNull Builder builder() {
        return Spectator.getBackend().soundStart();
    }

    @NotNull
    public ResourceLocation soundKey();

    @Contract(pure=true)
    @NotNull
    public SoundStart withSoundKey(@NotNull ResourceLocation var1);

    @NotNull
    public SoundSource source();

    @Contract(pure=true)
    @NotNull
    public SoundStart withSource(@NotNull SoundSource var1);

    public float volume();

    @Contract(pure=true)
    @NotNull
    public SoundStart withVolume(float var1);

    public float pitch();

    @Contract(pure=true)
    @NotNull
    public SoundStart withPitch(float var1);

    @LimitedVersionSupport(value=">= 1.19")
    @Nullable
    public Long seed();

    @Contract(pure=true)
    @LimitedVersionSupport(value=">= 1.19")
    @NotNull
    public SoundStart withSeed(@Nullable Long var1);

    @Contract(value="-> new", pure=true)
    public @NotNull Builder toBuilder();

    public static interface Builder {
        @Contract(value="_ -> this")
        @NotNull
        public Builder soundKey(@NotNull ResourceLocation var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder soundKey(@MinecraftType(value=MinecraftType.Type.SOUND) @NotNull String key) {
            return this.soundKey(ResourceLocation.of(key));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder source(@NotNull SoundSource var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder volume(float var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder pitch(float var1);

        @Contract(value="_ -> this")
        @LimitedVersionSupport(value=">= 1.19")
        @NotNull
        public Builder seed(@Nullable Long var1);

        @Contract(value="-> new", pure=true)
        @NotNull
        public SoundStart build();
    }
}

