/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.spectator.utils;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentBuilderApplicable;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.TextComponent;

public final class ComponentUtils {
    @NotNull
    public static Component linear(ComponentBuilderApplicable ... applicables) {
        int length = applicables.length;
        if (length == 0) {
            return Component.empty();
        }
        if (length == 1) {
            if (applicables[0] instanceof ComponentLike) {
                return ((ComponentLike)applicables[0]).asComponent();
            }
            throw new IllegalArgumentException("Not a component: " + String.valueOf(applicables[0]));
        }
        TextComponent.Builder builder = Component.text();
        Color color = null;
        for (ComponentBuilderApplicable applicable : applicables) {
            if (applicable instanceof Color) {
                color = (Color)applicable;
                continue;
            }
            if (color != null && applicable instanceof ComponentLike) {
                ((ComponentLike)applicable).asComponent().withColor(color).apply(builder);
                continue;
            }
            applicable.apply(builder);
        }
        return builder.build();
    }

    @NotNull
    public static Component repeat(@NotNull Component component, int repetitions, @Nullable Component separator) {
        if (repetitions == 0) {
            return Component.empty();
        }
        if (repetitions == 1) {
            return component;
        }
        TextComponent.Builder builder = Component.text();
        for (int i = 0; i < repetitions; ++i) {
            builder.append(component);
            if (separator == null) continue;
            builder.append(separator);
        }
        return builder.build();
    }

    @Generated
    private ComponentUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

