/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.Wrapper;

public final class BidirectionalConverter<SpecificWrapper extends Wrapper> {
    @NotNull
    private final @NotNull Map<@NotNull Class<?>, Function<@NotNull Object, @Nullable SpecificWrapper>> p2wConverters = new HashMap();
    @NotNull
    private final @NotNull Map<@NotNull Class<?>, Function<@NotNull SpecificWrapper, @Nullable Object>> w2pConverters = new HashMap();

    @NotNull
    public <P> BidirectionalConverter<SpecificWrapper> registerW2P(@NotNull Class<P> type, @NotNull @NotNull Function<@NotNull SpecificWrapper, @Nullable P> convertor) {
        this.w2pConverters.put(type, convertor);
        return this;
    }

    @NotNull
    public <P> BidirectionalConverter<SpecificWrapper> registerP2W(@NotNull Class<P> type, @NotNull @NotNull Function<@NotNull P, @Nullable SpecificWrapper> convertor) {
        this.p2wConverters.put(type, convertor);
        return this;
    }

    @NotNull
    public <P> SpecificWrapper convert(@NotNull P object) {
        return (SpecificWrapper)((Wrapper)this.convertOptional(object).orElseThrow(() -> new UnsupportedOperationException("Can't convert " + object.getClass().getName() + " to the wrapper")));
    }

    @NotNull
    public <P> Optional<SpecificWrapper> convertOptional(@Nullable P object) {
        if (object == null) {
            return Optional.empty();
        }
        return this.p2wConverters.entrySet().stream().filter(c -> ((Class)c.getKey()).isInstance(object)).map(entry -> (Wrapper)((Function)entry.getValue()).apply(object)).filter(Objects::nonNull).findFirst();
    }

    @Nullable
    public <P> SpecificWrapper convertNullable(@Nullable P object) {
        return (SpecificWrapper)((Wrapper)this.convertOptional(object).orElse(null));
    }

    @NotNull
    public <P> P convert(@NotNull SpecificWrapper object, @NotNull Class<P> newType) {
        return this.convertOptional(object, newType).orElseThrow(() -> new UnsupportedOperationException("Can't convert wrapper " + object.getClass().getName() + " to " + newType.getName()));
    }

    @NotNull
    public <P> Optional<P> convertOptional(@Nullable SpecificWrapper object, @NotNull Class<P> newType) {
        if (object == null) {
            return Optional.empty();
        }
        if (newType.isInstance(object)) {
            return Optional.of(object);
        }
        return this.w2pConverters.entrySet().stream().filter(c -> newType.isAssignableFrom((Class)c.getKey())).map(entry -> ((Function)entry.getValue()).apply(object)).filter(Objects::nonNull).findFirst();
    }

    @Generated
    private BidirectionalConverter() {
    }

    @Generated
    public static <SpecificWrapper extends Wrapper> BidirectionalConverter<SpecificWrapper> build() {
        return new BidirectionalConverter<SpecificWrapper>();
    }
}

