/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u.config;

import org.jetbrains.annotations.NotNull;
import sba.sl.impl.utils.config.GsonSupplier;
import sba.sl.impl.utils.config.JacksonSupplier;
import sba.sl.impl.utils.config.YamlSupplier;
import sba.sl.u.config.ConfigurationLoaderBuilderSupplier;
import sba.sl.u.reflect.Reflect;

public class JsonConfigurationLoaderBuilderSupplier
implements ConfigurationLoaderBuilderSupplier {
    @NotNull
    public static final JsonConfigurationLoaderBuilderSupplier INSTANCE = new JsonConfigurationLoaderBuilderSupplier();

    @Override
    public  @NotNull AbstractConfigurationLoader.Builder<?, ?> get() throws UnsupportedOperationException {
        return this.get(true);
    }

    @Override
    public  @NotNull AbstractConfigurationLoader.Builder<?, ?> getForLoadingOnly() throws UnsupportedOperationException {
        return this.get(false);
    }

    public  @NotNull AbstractConfigurationLoader.Builder<?, ?> get(boolean supportsSaving) throws UnsupportedOperationException {
        if (Reflect.has("sba.c.jackson.JacksonConfigurationLoader")) {
            return JacksonSupplier.obtainBuilder();
        }
        if (Reflect.has("sba.c.gson.GsonConfigurationLoader")) {
            return GsonSupplier.obtainBuilder();
        }
        if (!supportsSaving && Reflect.has("sba.c.yaml.YamlConfigurationLoader")) {
            return YamlSupplier.obtainBuilder();
        }
        throw new UnsupportedOperationException("There is no Configurate Loader capable of loading json files!");
    }
}

