/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.u.visual;

import org.jetbrains.annotations.NotNull;
import sba.sl.impl.utils.visual.SimpleCLTextEntry;
import sba.sl.impl.utils.visual.SimpleTextEntry;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;

public interface TextEntry {
    @NotNull
    public static TextEntry of(@NotNull String identifier, @NotNull Component text) {
        return SimpleTextEntry.of(identifier, text);
    }

    @NotNull
    public static TextEntry of(@NotNull Component text) {
        return SimpleTextEntry.of(text);
    }

    @NotNull
    public static TextEntry of(@NotNull String identifier, @NotNull ComponentLike text) {
        return SimpleCLTextEntry.of(identifier, text);
    }

    @NotNull
    public static TextEntry of(@NotNull ComponentLike text) {
        return SimpleCLTextEntry.of(text);
    }

    @NotNull
    public static TextEntry of(@NotNull String identifier, @NotNull String text) {
        return SimpleTextEntry.of(identifier, Component.fromLegacy(text));
    }

    @NotNull
    public static TextEntry of(@NotNull String text) {
        return SimpleTextEntry.of(Component.fromLegacy(text));
    }

    @NotNull
    public String getIdentifier();

    @NotNull
    public Component getText();

    default public boolean isSame(@NotNull TextEntry another) {
        return this.getIdentifier().equalsIgnoreCase(another.getIdentifier());
    }
}

