/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.vi.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentSkipListMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.u.visual.TextEntry;
import sba.sl.vi.LinedVisual;
import sba.sl.vi.Visual;
import sba.sl.vi.impl.AbstractVisual;
import sba.sl.vi.utils.VisualUtils;

public abstract class AbstractLinedVisual<T extends Visual<T>>
extends AbstractVisual<T>
implements LinedVisual<T> {
    @NotNull
    protected @NotNull ConcurrentSkipListMap<@NotNull Integer, TextEntry> lines = new ConcurrentSkipListMap();
    @NotNull
    protected Integer originalLinesSize = 0;

    public AbstractLinedVisual(@NotNull UUID uuid) {
        super(uuid);
    }

    @Override
    @NotNull
    public @NotNull Map<@NotNull Integer, TextEntry> lines() {
        return Map.copyOf(this.lines);
    }

    @Override
    public @Nullable Map.Entry<Integer, @NotNull TextEntry> lineByIdentifier(@NotNull String identifier) {
        return this.lines.entrySet().stream().filter(next -> ((TextEntry)next.getValue()).getIdentifier().equals(identifier)).map(next -> Map.entry((Integer)next.getKey(), (TextEntry)next.getValue())).findFirst().orElse(null);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T title(@NotNull Component title) {
        return (T)this.firstLine(title);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T title(@NotNull ComponentLike title) {
        return (T)this.firstLine(title);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T firstLine(@NotNull Component text) {
        return (T)this.newLine((Integer)0, text);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T firstLine(@NotNull ComponentLike text) {
        return (T)this.newLine((Integer)0, text);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T firstLine(@NotNull TextEntry text) {
        return (T)this.newLine((Integer)0, text);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T bottomLine(@NotNull Component text) {
        return (T)this.bottomLine(TextEntry.of(text));
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T bottomLine(@NotNull ComponentLike text) {
        return (T)this.bottomLine(TextEntry.of(text));
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T bottomLine(@NotNull TextEntry text) {
        if (this.lines.isEmpty()) {
            return (T)this.firstLine(text);
        }
        this.originalLinesSize = this.lines.size();
        this.lines.put(this.lines.lastKey() + 1, text);
        this.update();
        return (T)this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T replaceLine(@NotNull TextEntry text) {
        String identifier = text.getIdentifier();
        if (identifier.isEmpty()) {
            return (T)this.bottomLine(text);
        }
        Map.Entry<Integer, TextEntry> line = this.lineByIdentifier(text.getIdentifier());
        if (line == null) {
            return (T)this.bottomLine(text);
        }
        return (T)this.replaceLine(line.getKey(), text);
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public T replaceLine(@NotNull Integer where, @NotNull Component text) {
        return (T)this.replaceLine(where, TextEntry.of(text));
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public T replaceLine(@NotNull Integer where, @NotNull ComponentLike text) {
        return (T)this.replaceLine(where, TextEntry.of(text));
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public T replaceLine(@NotNull Integer where, @NotNull TextEntry text) {
        if (!this.lines.containsKey(where)) {
            return (T)this.newLine(where, text);
        }
        this.originalLinesSize = this.lines.size();
        this.lines.put(where, text);
        this.update();
        return (T)this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T setLines(@NotNull @NotNull Map<@NotNull Integer, TextEntry> lines) {
        this.originalLinesSize = this.lines.size();
        this.lines = new ConcurrentSkipListMap<Integer, TextEntry>(lines);
        this.update();
        return (T)this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T setLines(@NotNull @NotNull List<@NotNull Component> lines) {
        HashMap<Integer, TextEntry> toSet = new HashMap<Integer, TextEntry>();
        for (int i = 0; i < lines.size(); ++i) {
            toSet.put(i, TextEntry.of(lines.get(i)));
        }
        return (T)this.setLines(toSet);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T setLines(@NotNull @NotNull Set<@NotNull TextEntry> lines) {
        List<TextEntry> ls = List.copyOf(lines);
        HashMap<Integer, TextEntry> toSet = new HashMap<Integer, TextEntry>();
        for (int i = 0; i < ls.size(); ++i) {
            toSet.put(i, ls.get(i));
        }
        return (T)this.setLines(toSet);
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public T newLine(@NotNull Integer where, @NotNull Component text) {
        return (T)this.newLine(where, TextEntry.of(text));
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public T newLine(@NotNull Integer where, @NotNull ComponentLike text) {
        return (T)this.newLine(where, TextEntry.of(text));
    }

    @Override
    @Contract(value="_, _ -> this")
    @NotNull
    public T newLine(@NotNull Integer where, @NotNull TextEntry text) {
        this.originalLinesSize = this.lines.size();
        this.lines = VisualUtils.addEntryAndMoveRest(this.lines, where, text);
        this.update();
        return (T)this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T removeLine(@NotNull Integer where) {
        this.originalLinesSize = this.lines.size();
        this.lines = VisualUtils.removeEntryAndMoveRest(this.lines, where);
        this.update();
        return (T)this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T removeLine(@NotNull String identifier) {
        Map.Entry<Integer, TextEntry> next = this.lineByIdentifier(identifier);
        if (next != null) {
            this.originalLinesSize = this.lines.size();
            this.lines = VisualUtils.removeEntryAndMoveRest(this.lines, next.getKey());
            this.update();
        }
        return (T)this;
    }
}

