/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.vi.impl;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import sba.sl.pa.Player;
import sba.sl.vi.Visual;

public abstract class AbstractVisual<T extends Visual<T>>
implements Visual<T> {
    @NotNull
    protected final @NotNull List<@NotNull Player> viewers;
    @NotNull
    protected final UUID uuid;
    protected volatile boolean visible;
    protected volatile boolean destroyed;

    public AbstractVisual(@NotNull UUID uuid) {
        this.uuid = uuid;
        this.viewers = new CopyOnWriteArrayList<Player>();
    }

    @Override
    @NotNull
    public UUID uuid() {
        return this.uuid;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull Player> viewers() {
        return List.copyOf(this.viewers);
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T addViewer(@NotNull Player viewer) {
        if (viewer.isOnline() && !this.viewers.contains(viewer)) {
            this.viewers.add(viewer);
            this.onViewerAdded(viewer, true);
        }
        return (T)this;
    }

    @Override
    @Contract(value="_ -> this")
    @NotNull
    public T removeViewer(@NotNull Player viewer) {
        if (this.viewers.contains(viewer)) {
            this.viewers.remove(viewer);
            if (viewer.isOnline()) {
                this.onViewerRemoved(viewer, false);
            }
        }
        return (T)this;
    }

    @Override
    @Contract(value="-> this")
    @NotNull
    public T clearViewers() {
        this.hide();
        this.viewers.clear();
        return (T)this;
    }

    @Override
    public boolean hasViewers() {
        return !this.viewers.isEmpty();
    }

    @Override
    public boolean shown() {
        return this.visible;
    }

    @Override
    public boolean visibleTo(@NotNull Player player) {
        return this.viewers.contains(player);
    }

    @Override
    @Generated
    public boolean destroyed() {
        return this.destroyed;
    }
}

