/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.w;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.WorldHolder;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.w.World;

@ProvidedService
public abstract class Worlds {
    @Nullable
    private static Worlds worlds;

    @ApiStatus.Internal
    public Worlds() {
        if (worlds != null) {
            throw new UnsupportedOperationException("Worlds is already initialized.");
        }
        worlds = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static World getWorld(@Nullable UUID uuid) {
        if (worlds == null) {
            throw new UnsupportedOperationException("Worlds is not initialized yet.");
        }
        if (uuid == null) {
            return null;
        }
        return worlds.getWorld0(uuid);
    }

    @Contract(value="null -> null")
    @Nullable
    public static World getWorld(@Nullable String name) {
        if (worlds == null) {
            throw new UnsupportedOperationException("Worlds is not initialized yet.");
        }
        if (name == null) {
            return null;
        }
        return worlds.getWorld0(name);
    }

    @NotNull
    public static @NotNull List<@NotNull World> getWorlds() {
        if (worlds == null) {
            throw new UnsupportedOperationException("Worlds is not initialized yet.");
        }
        return worlds.getWorlds0();
    }

    @Nullable
    protected abstract World getWorld0(@NotNull UUID var1);

    @Nullable
    protected abstract World getWorld0(@NotNull String var1);

    @NotNull
    protected abstract @NotNull List<@NotNull World> getWorlds0();

    @Nullable
    protected abstract World fromPlatform(@NotNull Object var1);

    static {
        WorldHolder.Provider.registerProvider(o -> Objects.requireNonNull(Objects.requireNonNull(worlds, "Worlds is not initialized yet.").fromPlatform(o), "Cannot convert " + String.valueOf(o) + " to World"));
    }
}

