/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.implementations.drivers.v1;

import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.board.implementations.IBoard;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.plugin.Session;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.plugin.utility.LineLimits;
import io.github.pronze.lib.pronzelib.scoreboards.scoreboardr.plugin.utility.ScoreboardStrings;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class ScoreboardDriverV1
implements IBoard {
    private Player player;
    private Scoreboard board;
    private Objective objective;
    private int lines;
    private HashMap<Integer, String> cache = new HashMap();
    private String objectiveName = "sbascoreboard";

    @Override
    public void setPlayer(Player player) {
        this.player = player;
        this.board = Objects.requireNonNull(Session.getSession().plugin.getServer().getScoreboardManager()).getNewScoreboard();
        this.objective = this.board.registerNewObjective(this.objectiveName, "dummy");
        this.objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        this.objective.setDisplayName("");
        this.createTeams();
        this.setBoard();
        LineLimits.getLineLimit();
    }

    @Override
    public void setTitle(String title) {
        if (title == null) {
            title = "";
        }
        if (title.length() > LineLimits.getLineLimit() * 2) {
            title = title.substring(0, LineLimits.getLineLimit() * 2);
        }
        this.objective.setDisplayName(title);
    }

    @Override
    public void setLine(int line, String content) {
        if (content == null) {
            content = "";
        }
        if (!this.shouldUpdate(line, content)) {
            return;
        }
        Team team = this.board.getTeam("" + line);
        String[] split = this.split(content);
        assert (team != null);
        team.setPrefix(split[0]);
        team.setSuffix(split[1]);
    }

    private String[] split(String line) {
        int cutPoint = LineLimits.getLineLimit();
        if (line.length() <= 32) {
            cutPoint = line.length() / 2;
        }
        if (line.length() <= cutPoint || line.length() == 0) {
            return new String[]{line, ""};
        }
        String prefix = line.substring(0, cutPoint);
        Object suffix = line.substring(cutPoint);
        if (prefix.endsWith("\u00a7")) {
            prefix = ScoreboardStrings.removeLastCharacter(prefix);
            suffix = "\u00a7" + (String)suffix;
        } else {
            suffix = prefix.contains("\u00a7") ? ChatColor.getLastColors((String)prefix) + (String)suffix : "\u00a7f" + (String)suffix;
        }
        if (((String)suffix).length() > LineLimits.getLineLimit()) {
            suffix = ((String)suffix).substring(0, LineLimits.getLineLimit());
        }
        return new String[]{prefix, suffix};
    }

    private boolean shouldUpdate(int line, String content) {
        if (!this.cache.containsKey(line)) {
            this.cache.put(line, content);
            return true;
        }
        if (this.cache.get(line).equals(content)) {
            return false;
        }
        this.cache.put(line, content);
        return true;
    }

    @Override
    public void setLineCount(int lines) {
        this.lines = lines;
        this.createTeams();
    }

    @Override
    public Player getPlayer() {
        return this.getPlayer();
    }

    private void createTeams() {
        if (this.board != null) {
            Team team;
            int i;
            int score = this.lines;
            for (i = 0; i < this.lines; ++i) {
                team = this.board.getTeam("" + i);
                if (team == null) {
                    try {
                        Team t = this.board.registerNewTeam("" + i);
                        t.addEntry(String.valueOf(ChatColor.values()[i]));
                        this.objective.getScore(String.valueOf(ChatColor.values()[i])).setScore(score);
                    }
                    catch (Throwable throwable) {}
                } else {
                    try {
                        this.objective.getScore(String.valueOf(ChatColor.values()[i])).setScore(score);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                --score;
            }
            for (i = this.board.getTeams().size() - 1; i >= this.lines; --i) {
                team = this.board.getTeam("" + i);
                if (team == null) continue;
                team.unregister();
            }
        }
    }

    private void setBoard() {
        this.player.setScoreboard(this.board);
    }

    @Override
    public void setObjective(String objectiveName) {
        if (objectiveName == null) {
            objectiveName = "sbascoreboard";
        }
    }

    @Override
    public boolean hasTeamEntry(String invisTeamName) {
        return this.board.getTeam(invisTeamName) != null;
    }

    @Override
    public Team addTeam(String invisTeamName, ChatColor chatColor) {
        Team t = this.board.registerNewTeam(invisTeamName);
        return t;
    }

    @Override
    public Optional<Team> getTeamEntry(String invisTeamName) {
        return Optional.ofNullable(this.board.getTeam(invisTeamName));
    }

    @Override
    public Team getTeamOrRegister(String invisTeamName) {
        Team t = this.board.getTeam(invisTeamName);
        if (t == null) {
            try {
                t = this.addTeam(invisTeamName, ChatColor.GRAY);
            }
            catch (Throwable t_) {
                t_.printStackTrace();
                return null;
            }
        }
        return t;
    }
}

