/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.AIService;
import io.github.pronze.sba.utils.citizens.Strategy;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import sba.cl.annotations.CommandDescription;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class AICommand
implements Listener {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().ai().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
            SBA.getInstance().registerListener(this);
        }
        init = true;
    }

    @CommandMethod(value="sba ai leave")
    @CommandPermission(value="sba.ai")
    @CommandDescription(value="sba ai leave")
    private void commandAILeave(@NotNull Player player) {
        SBAPlayerWrapper wrapper = SBA.getInstance().getPlayerWrapper(player);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(wrapper);
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        Optional<Player> aiPlayer = game.getConnectedPlayers().stream().filter(pl -> AIService.getInstance().isNPC((Player)pl)).findFirst();
        aiPlayer.ifPresent(pl -> game.leaveFromGame(pl));
    }

    @CommandMethod(value="sba ai join")
    @CommandPermission(value="sba.ai")
    @CommandDescription(value="sba ai join")
    private void commandAIJoin(@NotNull Player player) {
        SBAPlayerWrapper wrapper = SBA.getInstance().getPlayerWrapper(player);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(wrapper);
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game.getStatus() == GameStatus.WAITING) {
            int maxPlayer = game.getMaxPlayers();
            int current = game.countConnectedPlayers();
            if (current < maxPlayer) {
                AIService.getInstance().spawnAI(player.getLocation()).thenAccept(ai -> {
                    int current_ = game.countConnectedPlayers();
                    if (current_ < maxPlayer) {
                        game.joinToGame(ai);
                    } else {
                        AIService.getInstance().getNPC((Entity)ai).destroy();
                    }
                });
            }
        }
    }

    @CommandMethod(value="sba ai join agressive")
    @CommandPermission(value="sba.ai")
    @CommandDescription(value="sba ai join agressive")
    private void commandAIJoinAgr(@NotNull Player player) {
        SBAPlayerWrapper wrapper = SBA.getInstance().getPlayerWrapper(player);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(wrapper);
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game.getStatus() == GameStatus.WAITING) {
            int maxPlayer = game.getMaxPlayers();
            int current = game.countConnectedPlayers();
            if (current < maxPlayer) {
                AIService.getInstance().spawnAI(player.getLocation(), Strategy.AGRESSIVE).thenAccept(ai -> {
                    int current_ = game.countConnectedPlayers();
                    if (current_ < maxPlayer) {
                        game.joinToGame(ai);
                    } else {
                        AIService.getInstance().getNPC((Entity)ai).destroy();
                    }
                });
            }
        }
    }

    @CommandMethod(value="sba ai join defensive")
    @CommandPermission(value="sba.ai")
    @CommandDescription(value="sba ai join defensive")
    private void commandAIJoinDef(@NotNull Player player) {
        SBAPlayerWrapper wrapper = SBA.getInstance().getPlayerWrapper(player);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(wrapper);
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game.getStatus() == GameStatus.WAITING) {
            int maxPlayer = game.getMaxPlayers();
            int current = game.countConnectedPlayers();
            if (current < maxPlayer) {
                AIService.getInstance().spawnAI(player.getLocation(), Strategy.DEFENSIVE).thenAccept(ai -> {
                    int current_ = game.countConnectedPlayers();
                    if (current_ < maxPlayer) {
                        game.joinToGame(ai);
                    } else {
                        AIService.getInstance().getNPC((Entity)ai).destroy();
                    }
                });
            }
        }
    }

    @CommandMethod(value="sba ai join noai")
    @CommandPermission(value="sba.ai")
    @CommandDescription(value="sba ai join noai")
    private void commandAIJoinNoAI(@NotNull Player player) {
        SBAPlayerWrapper wrapper = SBA.getInstance().getPlayerWrapper(player);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(wrapper);
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game.getStatus() == GameStatus.WAITING) {
            int maxPlayer = game.getMaxPlayers();
            int current = game.countConnectedPlayers();
            if (current < maxPlayer) {
                AIService.getInstance().spawnAI(player.getLocation(), Strategy.NONE).thenAccept(ai -> {
                    int current_ = game.countConnectedPlayers();
                    if (current_ < maxPlayer) {
                        game.joinToGame(ai);
                    } else {
                        AIService.getInstance().getNPC((Entity)ai).destroy();
                    }
                });
            }
        }
    }

    @CommandMethod(value="sba ai join balanced")
    @CommandPermission(value="sba.ai")
    @CommandDescription(value="sba ai join balanced")
    private void commandAIJoinBal(@NotNull Player player) {
        SBAPlayerWrapper wrapper = SBA.getInstance().getPlayerWrapper(player);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(wrapper);
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game.getStatus() == GameStatus.WAITING) {
            int maxPlayer = game.getMaxPlayers();
            int current = game.countConnectedPlayers();
            if (current < maxPlayer) {
                AIService.getInstance().spawnAI(player.getLocation(), Strategy.BALANCED).thenAccept(ai -> {
                    int current_ = game.countConnectedPlayers();
                    if (current_ < maxPlayer) {
                        game.joinToGame(ai);
                    } else {
                        AIService.getInstance().getNPC((Entity)ai).destroy();
                    }
                });
            }
        }
    }
}

