/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.GamesInventoryService;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.Argument;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.pa.Players;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class GamesInvNPCCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="sba gamesinv spawnnpc <mode>")
    @CommandPermission(value="sba.spawnnpc")
    private void commandSpawn(@NotNull Player player, @Argument(value="mode", suggestions="gameMode") @NotNull String mode) {
        GamesInventoryService.getInstance().addNPC(mode, player.getLocation());
        GamesInventoryService.getInstance().addViewer(player);
        LanguageService.getInstance().get(MessageKeys.ADDED_NPC).send(Players.wrapPlayer(player));
    }

    @CommandMethod(value="sba gamesinv removenpc")
    @CommandPermission(value="sba.removenpc")
    private void commandRemove(@NotNull Player player) {
        LanguageService.getInstance().get(MessageKeys.REMOVABLE_NPC_TOGGLE).send(Players.wrapPlayer(player));
        GamesInventoryService.getInstance().addEditable(Players.wrapPlayer(player), GamesInventoryService.Action.Remove, null);
    }

    @CommandMethod(value="sba gamesinv editnpc <skin>")
    @CommandPermission(value="sba.editnpc")
    private void commandEdit(@NotNull Player player, @Argument(value="skin") @NotNull String skin) {
        LanguageService.getInstance().get(MessageKeys.SKIN_NPC_TOGGLE).send(Players.wrapPlayer(player));
        GamesInventoryService.getInstance().addEditable(Players.wrapPlayer(player), GamesInventoryService.Action.Skin, skin);
    }
}

