/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.Permissions;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.TeamColor;
import sba.cl.annotations.Argument;
import sba.cl.annotations.CommandDescription;
import sba.cl.annotations.CommandMethod;
import sba.sl.spectator.Component;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class ShoutCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        CommandManager.getInstance().getAnnotationParser().parse(this);
        init = true;
    }

    @CommandMethod(value="shout <args>")
    @CommandDescription(value="shout command")
    private void commandShout(@NotNull Player player, @Argument(value="args") @NotNull String[] argsParam) {
        SBAPlayerWrapper sbaPlayerWrapper;
        boolean cancelShout;
        List<String> args = List.of(argsParam);
        SBAPlayerWrapper wrapper = SBA.getInstance().getPlayerWrapper(player);
        if (!Main.getInstance().isPlayerPlayingAnyGame(player)) {
            LanguageService.getInstance().get(MessageKeys.MESSAGE_NOT_IN_GAME).send(wrapper);
            return;
        }
        GamePlayer bPlayer = Main.getPlayerGameProfile((Player)player);
        if (bPlayer.isSpectator) {
            LanguageService.getInstance().get(MessageKeys.COMMAND_DISABLED_FOR_SPECTATORS).send(wrapper);
            return;
        }
        boolean bl = cancelShout = SBAConfig.getInstance().node("shout", "time-out").getInt(60) == 0;
        if (!(cancelShout || player.hasPermission(Permissions.SHOUT_BYPASS.getKey()) || (sbaPlayerWrapper = wrapper.as(SBAPlayerWrapper.class)).canShout())) {
            String shout = String.valueOf(sbaPlayerWrapper.getShoutCooldown());
            LanguageService.getInstance().get(MessageKeys.MESSAGE_SHOUT_WAIT).replace("%seconds%", shout).send(sbaPlayerWrapper);
            return;
        }
        Game game = Main.getInstance().getGameOfPlayer(player);
        RunningTeam team = game.getTeamOfPlayer(player);
        String color = ChatColor.GRAY.toString();
        if (team != null) {
            color = TeamColor.valueOf((String)team.getColor().name()).chatColor.toString();
        }
        StringBuilder strBuilder = new StringBuilder();
        if (args.isEmpty()) {
            LanguageService.getInstance().get(MessageKeys.COMMAND_SHOUT_INVALID_USAGE).send(wrapper);
            return;
        }
        args.forEach(st -> strBuilder.append((String)st).append(" "));
        Component shoutMessage = LanguageService.getInstance().get(MessageKeys.SHOUT_FORMAT).replace("%color%", color).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).replace("%message%", strBuilder.toString()).replace("%team%", team == null ? "" : team.getName()).placeholderFor(player).toComponent();
        wrapper.as(SBAPlayerWrapper.class).shout(shoutMessage);
    }
}

