/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.commands.party;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.commands.CommandManager;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.events.SBAPlayerPartyInviteAcceptEvent;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.party.IParty;
import io.github.pronze.sba.party.PartyManager;
import io.github.pronze.sba.party.PartySetting;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import sba.cl.annotations.Argument;
import sba.cl.annotations.CommandMethod;
import sba.cl.annotations.CommandPermission;
import sba.sl.s.CommandSender;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class PartyJoinCommand {
    static boolean init = false;

    @OnPostEnable
    public void onPostEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        if (init) {
            return;
        }
        if (SBAConfig.getInstance().party().enabled()) {
            CommandManager.getInstance().getAnnotationParser().parse(this);
        }
        init = true;
    }

    @CommandMethod(value="party|p join <user>")
    @CommandPermission(value="sba.party")
    private void commandAccept(@NotNull Player playerArg, @Argument(value="user") @NotNull Player userArg) {
        SBAPlayerWrapper player = SBA.getInstance().getPlayerWrapper(playerArg);
        SBAPlayerWrapper user = SBA.getInstance().getPlayerWrapper(userArg);
        if (player.getSettings().isToggled(PlayerSetting.IN_PARTY)) {
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_SELF_ALREADY_IN_PARTY).send(player);
            return;
        }
        Optional<IParty> optionalParty = PartyManager.getInstance().getPartyOf(user);
        if (optionalParty.isEmpty() || optionalParty.get().getSettings().getInvite() == PartySetting.Invite.ALL) {
            optionalParty = PartyManager.getInstance().getInvitedPartyOf(player);
        }
        optionalParty.ifPresentOrElse(party -> {
            SBAPlayerPartyInviteAcceptEvent acceptEvent = new SBAPlayerPartyInviteAcceptEvent(player, (IParty)party);
            SBA.getPluginInstance().getServer().getPluginManager().callEvent((Event)acceptEvent);
            if (acceptEvent.isCancelled()) {
                return;
            }
            player.getSettings().disable(PlayerSetting.INVITED_TO_PARTY).enable(PlayerSetting.IN_PARTY);
            party.addPlayer(player);
            LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_ACCEPTED).replace("%player%", player.as(Player.class).getDisplayName() + String.valueOf(ChatColor.RESET)).send((CommandSender[])party.getMembers().toArray(SBAPlayerWrapper[]::new));
        }, () -> LanguageService.getInstance().get(MessageKeys.PARTY_MESSAGE_NOT_INVITED).send(player));
    }
}

