/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.listener;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.wrapper.PlayerSetting;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.GameStatus;
import org.screamingsandals.bedwars.game.GamePlayer;
import org.screamingsandals.bedwars.game.TeamColor;
import sba.sl.pa.Players;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.methods.OnPostEnable;

@Service
public class GameChatListener
implements Listener {
    @OnPostEnable
    public void registerListener() {
        if (SBA.isBroken()) {
            return;
        }
        SBA.getInstance().registerListener(this);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        SBAPlayerWrapper playerWrapper = Players.wrapPlayer(player).as(SBAPlayerWrapper.class);
        if (playerWrapper.getSettings().isToggled(PlayerSetting.IN_PARTY) && playerWrapper.getSettings().isToggled(PlayerSetting.PARTY_CHAT_ENABLED)) {
            return;
        }
        if (Main.getInstance().isPlayerPlayingAnyGame(player)) {
            Game game = Main.getInstance().getGameOfPlayer(player);
            if (game.getStatus() == GameStatus.RUNNING) {
                if (SBAConfig.getInstance().node("chat-format", "game-chat", "enabled").getBoolean(true)) {
                    String format;
                    event.setCancelled(true);
                    GamePlayer bedwarsPlayer = Main.getPlayerGameProfile((Player)player);
                    String allChatPrefix = SBAConfig.getInstance().node("chat-format", "game-chat", "all-chat-prefix").getString();
                    boolean all = false;
                    boolean spectator = false;
                    if (bedwarsPlayer.isSpectator) {
                        format = SBAConfig.getInstance().node("chat-format", "game-chat", "format-spectator").getString();
                        spectator = true;
                    } else {
                        if (event.getMessage().startsWith(allChatPrefix)) {
                            format = SBAConfig.getInstance().node("chat-format", "game-chat", "all-chat-format").getString();
                            all = true;
                        } else {
                            format = SBAConfig.getInstance().node("chat-format", "game-chat", "format").getString();
                        }
                        String colorName = game.getTeamOfPlayer(player).getColor().name().toUpperCase();
                        String teamName = game.getTeamOfPlayer(player).getName();
                        String color = TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)game.getTeamOfPlayer((Player)player).getColor()).chatColor.toString();
                        format = format.replace("%color%", color).replace("%color_name%", colorName).replace("%team%", teamName);
                    }
                    String message = event.getMessage().replace(allChatPrefix, "");
                    if (message.startsWith(" ")) {
                        message = message.substring(1);
                    }
                    format = format.replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET)).replace("%message%", message);
                    if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                        format = PlaceholderAPI.setPlaceholders((Player)player, (String)format);
                    }
                    String finalFormat = format;
                    if (all) {
                        game.getConnectedPlayers().forEach(gamePlayer -> gamePlayer.sendMessage(finalFormat));
                    } else if (spectator) {
                        game.getConnectedPlayers().forEach(gamePlayer -> {
                            if (Main.getPlayerGameProfile((Player)gamePlayer).isSpectator) {
                                gamePlayer.sendMessage(finalFormat);
                            }
                        });
                    } else {
                        String teamName = game.getTeamOfPlayer(player).getName();
                        game.getConnectedPlayers().forEach(gamePlayer -> {
                            if (Main.getPlayerGameProfile((Player)gamePlayer).isSpectator || teamName.equals(game.getTeamOfPlayer(gamePlayer).getName())) {
                                gamePlayer.sendMessage(finalFormat);
                            }
                        });
                    }
                }
            } else if (game.getStatus() == GameStatus.WAITING && SBAConfig.getInstance().node("chat-format", "lobby-chat", "enabled").getBoolean()) {
                event.setCancelled(true);
                String lobbyChatFormat = SBAConfig.getInstance().node("chat-format", "lobby-chat", "format").getString();
                RunningTeam team = game.getTeamOfPlayer(player);
                String teamColor = team != null ? TeamColor.fromApiColor((org.screamingsandals.bedwars.api.TeamColor)team.getColor()).chatColor.toString() : null;
                lobbyChatFormat = lobbyChatFormat.replace("%color%", teamColor == null ? "" : teamColor).replace("%message%", event.getMessage()).replace("%player%", player.getDisplayName() + String.valueOf(ChatColor.RESET));
                if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
                    lobbyChatFormat = PlaceholderAPI.setPlaceholders((Player)player, (String)lobbyChatFormat);
                }
                String finalLobbyChatFormat = lobbyChatFormat;
                game.getConnectedPlayers().forEach(gamePlayer -> gamePlayer.sendMessage(finalLobbyChatFormat));
            }
        }
    }
}

