/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.service;

import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import java.util.HashMap;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.screamingsandals.bedwars.api.events.BedwarsGameEndingEvent;
import org.screamingsandals.bedwars.api.events.BedwarsGameStartedEvent;
import org.screamingsandals.bedwars.api.events.BedwarsPlayerLeaveEvent;
import org.screamingsandals.bedwars.api.game.Game;
import sba.sl.hi.HealthIndicator2;
import sba.sl.hi.HealthIndicatorImpl2;
import sba.sl.hi.HealthIndicatorManager2;
import sba.sl.pa.Players;
import sba.sl.spectator.Color;
import sba.sl.spectator.Component;
import sba.sl.t.TaskerTime;
import sba.sl.u.annotations.Service;
import sba.sl.u.annotations.ServiceDependencies;
import sba.sl.u.annotations.methods.OnPostEnable;
import sba.sl.u.annotations.methods.OnPreDisable;
import sba.sl.vi.Visual;

@Service
@ServiceDependencies(dependsOn={HealthIndicatorManager2.class})
public class HealthIndicatorService
implements Listener {
    private final Map<IArena, HealthIndicator2> healthIndicatorMap = new HashMap<IArena, HealthIndicator2>();
    private boolean tabEnabled;
    private String placeholderProvider = "%player%";
    final String defaultPlaceholderProvider = "%player%";

    @OnPostEnable
    public void postEnabled() {
        if (SBA.isBroken()) {
            return;
        }
        this.tabEnabled = SBAConfig.getInstance().node("show-health-in-tablist").getBoolean();
        boolean tagEnabled = SBAConfig.getInstance().node("show-health-under-player-name").getBoolean();
        this.placeholderProvider = SBAConfig.getInstance().node("game", "name-provider").getString();
        if (!tagEnabled) {
            return;
        }
        HealthIndicatorImpl2.setNameProvider(this::placeholderProvider);
        SBA.getInstance().registerListener(this);
    }

    private String placeholderProvider(sba.sl.pa.Player p) {
        if ("%player%".equals(this.placeholderProvider)) {
            return p.getName();
        }
        String str = this.placeholderProvider;
        if (Bukkit.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            str = PlaceholderAPI.setPlaceholders((Player)p.as(Player.class), (String)str);
            if (this.placeholderProvider.equals(str)) {
                return p.getName();
            }
            return str;
        }
        return p.getName();
    }

    @OnPreDisable
    public void onDestroy() {
        this.healthIndicatorMap.values().forEach(Visual::destroy);
        this.healthIndicatorMap.clear();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onGameStart(BedwarsGameStartedEvent event) {
        Game game = event.getGame();
        HealthIndicator2 healthIndicator = ((HealthIndicator2)HealthIndicator2.of().symbol(Component.text("\u2665", Color.RED)).showHealthInTabList(this.tabEnabled).show()).startUpdateTask(2L, TaskerTime.TICKS);
        game.getConnectedPlayers().stream().map(Players::wrapPlayer).forEach(healthIndicator::addViewer);
        game.getConnectedPlayers().stream().map(Players::wrapPlayer).forEach(healthIndicator::addTrackedPlayer);
        this.healthIndicatorMap.put(ArenaManager.getInstance().get(game.getName()).orElseThrow(), healthIndicator);
    }

    @EventHandler
    public void onPlayerLeave(BedwarsPlayerLeaveEvent event) {
        sba.sl.pa.Player playerWrapper = Players.wrapPlayer(event.getPlayer());
        HealthIndicator2 healthIndicator = this.healthIndicatorMap.get(ArenaManager.getInstance().get(event.getGame().getName()).orElse(null));
        if (healthIndicator != null) {
            healthIndicator.removeViewer(playerWrapper);
            healthIndicator.removeTrackedPlayer(playerWrapper);
        }
    }

    @EventHandler
    public void onBedwarsGameEndingEvent(BedwarsGameEndingEvent event) {
        IArena arena = ArenaManager.getInstance().get(event.getGame().getName()).orElseThrow();
        HealthIndicator2 healthIndicator = this.healthIndicatorMap.get(arena);
        if (healthIndicator != null) {
            healthIndicator.destroy();
            this.healthIndicatorMap.remove(arena);
        }
    }
}

