/*
 * Decompiled with CFR 0.152.
 */
package io.github.pronze.sba.utils;

import io.github.pronze.sba.MessageKeys;
import io.github.pronze.sba.SBA;
import io.github.pronze.sba.config.SBAConfig;
import io.github.pronze.sba.data.DegradableItem;
import io.github.pronze.sba.game.ArenaManager;
import io.github.pronze.sba.game.IArena;
import io.github.pronze.sba.game.IGameStorage;
import io.github.pronze.sba.game.StoreType;
import io.github.pronze.sba.inventories.SBAStoreInventoryV2;
import io.github.pronze.sba.lang.Message;
import io.github.pronze.sba.lib.lang.LanguageService;
import io.github.pronze.sba.service.PlayerWrapperService;
import io.github.pronze.sba.utils.Logger;
import io.github.pronze.sba.wrapper.SBAPlayerWrapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;
import org.screamingsandals.bedwars.Main;
import org.screamingsandals.bedwars.api.BedwarsAPI;
import org.screamingsandals.bedwars.api.RunningTeam;
import org.screamingsandals.bedwars.api.TeamColor;
import org.screamingsandals.bedwars.api.game.Game;
import org.screamingsandals.bedwars.api.game.ItemSpawnerType;
import org.screamingsandals.bedwars.api.utils.ColorChanger;
import sba.c.ConfigurationNode;
import sba.si.builder.LocalOptionsBuilder;
import sba.si.events.ItemRenderEvent;
import sba.si.inventory.PlayerItemInfo;
import sba.si.inventory.Price;
import sba.si.inventory.Property;
import sba.sl.i.meta.Enchantment;
import sba.sl.i.meta.EnchantmentType;
import sba.sl.pa.Players;
import sba.sl.spectator.Component;

public class ShopUtil {
    public static final List<String> romanNumerals = List.of("NONE", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X");
    public static final List<String> orderOfArmor = List.of("GOLDEN,GOLD", "CHAINMAIL", "IRON", "DIAMOND", "NETHERITE");
    public static final List<String> orderOfTools = List.of("WOODEN,WOOD", "STONE", "GOLDEN,GOLD", "IRON", "DIAMOND");

    @NotNull
    public static Integer getLevelFromMaterialName(@NotNull String name, List<String> list) {
        @NotNull String finalName = name = name.substring(0, name.contains("_") ? name.lastIndexOf("_") : name.length());
        return list.stream().filter(value -> Arrays.stream(value.split(",")).anyMatch(names -> names.equalsIgnoreCase(finalName))).map(list::indexOf).findAny().orElse(0);
    }

    @NotNull
    public static String getMaterialFromLevel(int level, DegradableItem itemType) {
        String[] toParse;
        List<String> list = itemType == DegradableItem.ARMOR ? orderOfArmor : orderOfTools;
        String obj = list.get(level);
        if (obj == null) {
            obj = list.get(0);
        }
        String toTest = itemType == DegradableItem.ARMOR ? "_BOOTS" : "_AXE";
        for (String matName : toParse = obj.split(",")) {
            try {
                Material.valueOf((String)(matName + toTest));
                return matName;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
        }
        return list.get(0);
    }

    @NotNull
    public static String getMaterialFromArmorOrTools(@NotNull String material) {
        return material.substring(0, material.indexOf("_")).toUpperCase();
    }

    @NotNull
    public static String getMaterialFromArmorOrTools(@NotNull Material material) {
        return ShopUtil.getMaterialFromArmorOrTools(material.name());
    }

    public static boolean buyArmor(Player player, Material mat_boots, IGameStorage gameStorage, Game game) {
        PlayerInventory playerInventory = player.getInventory();
        ItemStack playerBoots = playerInventory.getBoots();
        String matName = ShopUtil.getMaterialFromArmorOrTools(mat_boots);
        if (playerBoots != null) {
            Material currentMat = playerBoots.getType();
            String currentMatName = ShopUtil.getMaterialFromArmorOrTools(currentMat);
            int currentLevel = ShopUtil.getLevelFromMaterialName(currentMatName, orderOfArmor);
            int newLevel = ShopUtil.getLevelFromMaterialName(matName, orderOfArmor);
            if (!SBAConfig.getInstance().node("can-downgrade-item").getBoolean(false) && currentLevel > newLevel) {
                LanguageService.getInstance().get(MessageKeys.CANNOT_DOWNGRADE_ITEM).replace("%item%", "armor").send(Players.wrapPlayer(player));
                return false;
            }
            if (currentLevel == newLevel) {
                LanguageService.getInstance().get(MessageKeys.ALREADY_PURCHASED).replace("%thing%", "armor").send(Players.wrapPlayer(player));
                return false;
            }
        }
        ItemStack boots = new ItemStack(mat_boots);
        ItemStack leggings = new ItemStack(Material.valueOf((String)(matName + "_LEGGINGS")));
        ItemStack chestplate = new ItemStack(Material.valueOf((String)(matName + "_CHESTPLATE")));
        ItemStack helmet = new ItemStack(Material.valueOf((String)(matName + "_HELMET")));
        ShopUtil.applyTeamEnchants(player, boots);
        ShopUtil.applyTeamEnchants(player, leggings);
        ShopUtil.applyTeamEnchants(player, chestplate);
        ShopUtil.applyTeamEnchants(player, helmet);
        playerInventory.setLeggings(null);
        playerInventory.setBoots(null);
        if (SBAConfig.getInstance().upgrades().boots()) {
            playerInventory.setBoots(boots);
        }
        if (SBAConfig.getInstance().upgrades().leggings()) {
            playerInventory.setLeggings(leggings);
        }
        if (SBAConfig.getInstance().upgrades().chestplate()) {
            playerInventory.setChestplate(chestplate);
        }
        if (SBAConfig.getInstance().upgrades().helmet()) {
            playerInventory.setHelmet(helmet);
        }
        return true;
    }

    public static void increaseTeamEnchant(Player teamPlayer, @Nullable ItemStack item, org.bukkit.enchantments.Enchantment damageAll, int levelToAdd) {
        if (!ShopUtil.canApply(damageAll, item)) {
            return;
        }
        int level = item.getEnchantmentLevel(damageAll);
        item.addUnsafeEnchantment(damageAll, level + levelToAdd);
    }

    public static ItemStack applyTeamEnchants(Player player, ItemStack newItem) {
        int protectionLevel;
        int efficiencyLevel;
        int knockbackLebel;
        Game game = Main.getInstance().getGameOfPlayer(player);
        IGameStorage gameStorage = SBA.getInstance().getGameStorage(game).orElseThrow();
        String typeName = newItem.getType().name();
        RunningTeam team = game.getTeamOfPlayer(player);
        int sharpnessLevel = gameStorage.getSharpnessLevel(team).orElse(0);
        if (sharpnessLevel > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.DAMAGE_ALL, newItem)) {
            newItem.addUnsafeEnchantment(org.bukkit.enchantments.Enchantment.DAMAGE_ALL, sharpnessLevel);
        }
        if ((knockbackLebel = gameStorage.getKnockbackLevel(team).orElse(0).intValue()) > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.KNOCKBACK, newItem)) {
            newItem.addUnsafeEnchantment(org.bukkit.enchantments.Enchantment.KNOCKBACK, knockbackLebel);
        }
        if ((efficiencyLevel = gameStorage.getEfficiencyLevel(team).orElse(0).intValue()) > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.DIG_SPEED, newItem)) {
            newItem.addUnsafeEnchantment(org.bukkit.enchantments.Enchantment.DIG_SPEED, efficiencyLevel);
        }
        if ((protectionLevel = gameStorage.getProtectionLevel(team).orElse(0).intValue()) > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.PROTECTION_ENVIRONMENTAL, newItem)) {
            newItem.addUnsafeEnchantment(org.bukkit.enchantments.Enchantment.PROTECTION_ENVIRONMENTAL, protectionLevel);
        }
        List<String> ignoredKeys = List.of("sharpness", "knockback", "protection", "efficiency");
        SBAConfig.getInstance().upgrades().enchants().keys().forEach(ench -> {
            Optional<org.bukkit.enchantments.Enchantment> ec = Arrays.stream(org.bukkit.enchantments.Enchantment.values()).filter(x -> x.getName().equalsIgnoreCase((String)ench) || EnchantmentType.of(x).location().path().equalsIgnoreCase((String)ench)).findFirst();
            if (ignoredKeys.contains(ench)) {
                return;
            }
            if (!ShopUtil.canApply(ench, newItem)) {
                return;
            }
            if (!ec.isPresent()) {
                Logger.error("SBA doesn't know how to apply enchant {}, it is not a valid enchant, check https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/enchantments/Enchantment.html for a list of enchant on your version of minecraft", ench);
                return;
            }
            org.bukkit.enchantments.Enchantment ech = ec.get();
            int level = gameStorage.getEnchantLevel(team, (String)ench).orElse(0);
            if (level > 0) {
                newItem.addUnsafeEnchantment(ech, level);
            }
        });
        return newItem;
    }

    public static sba.sl.i.ItemStack applyTeamEnchants(Player player, sba.sl.i.ItemStack newItem, StoreType type, List<Property> list) {
        Game game = Main.getInstance().getGameOfPlayer(player);
        IGameStorage gameStorage = SBA.getInstance().getGameStorage(game).orElseThrow();
        RunningTeam team = game.getTeamOfPlayer(player);
        int sharpnessLevel = gameStorage.getSharpnessLevel(team).orElse(0);
        if (list.stream().anyMatch(prop -> prop.hasName() && prop.getPropertyName().equalsIgnoreCase("sharpness")) && sharpnessLevel > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.DAMAGE_ALL, newItem)) {
            newItem = ShopUtil.clampOrApplyEnchants(newItem, sharpnessLevel, org.bukkit.enchantments.Enchantment.DAMAGE_ALL, type, SBAConfig.getInstance().node("upgrades", "limit", "Sharpness").getInt(1));
        }
        int knockbackLebel = gameStorage.getKnockbackLevel(team).orElse(0);
        if (list.stream().anyMatch(prop -> prop.hasName() && prop.getPropertyName().equalsIgnoreCase("knockback")) && knockbackLebel > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.KNOCKBACK, newItem)) {
            newItem = ShopUtil.clampOrApplyEnchants(newItem, knockbackLebel, org.bukkit.enchantments.Enchantment.KNOCKBACK, type, SBAConfig.getInstance().node("upgrades", "limit", "Knockback").getInt(1));
        }
        int efficiencyLevel = gameStorage.getEfficiencyLevel(team).orElse(0);
        if (list.stream().anyMatch(prop -> prop.hasName() && prop.getPropertyName().equalsIgnoreCase("Efficiency")) && efficiencyLevel > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.DIG_SPEED, newItem)) {
            newItem = ShopUtil.clampOrApplyEnchants(newItem, efficiencyLevel, org.bukkit.enchantments.Enchantment.DIG_SPEED, type, SBAConfig.getInstance().node("upgrades", "limit", "Efficiency").getInt(1));
        }
        int protectionLevel = gameStorage.getProtectionLevel(team).orElse(0);
        if (list.stream().anyMatch(prop -> prop.hasName() && prop.getPropertyName().equalsIgnoreCase("Protection")) && protectionLevel > 0 && ShopUtil.canApply(org.bukkit.enchantments.Enchantment.PROTECTION_ENVIRONMENTAL, newItem)) {
            newItem = ShopUtil.clampOrApplyEnchants(newItem, protectionLevel, org.bukkit.enchantments.Enchantment.PROTECTION_ENVIRONMENTAL, StoreType.UPGRADES, SBAConfig.getInstance().node("upgrades", "limit", "Protection").getInt(1));
        }
        List<String> ignoredKeys = List.of("sharpness", "knockback", "protection", "efficiency");
        for (String ench : SBAConfig.getInstance().upgrades().enchants().keys()) {
            Optional<org.bukkit.enchantments.Enchantment> ec = Arrays.stream(org.bukkit.enchantments.Enchantment.values()).filter(x -> x.getName().equalsIgnoreCase(ench) || EnchantmentType.of(x).location().path().equalsIgnoreCase(ench)).findFirst();
            if (ignoredKeys.contains(ench) || !ShopUtil.canApply(ench, newItem) || !list.stream().anyMatch(prop -> prop.hasName() && prop.getPropertyName().equalsIgnoreCase(ench))) continue;
            if (!ec.isPresent()) {
                Logger.error("SBA doesn't know how to apply enchant {}, it is not a valid enchant, check https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/enchantments/Enchantment.html for a list of enchant on your version of minecraft", ench);
                continue;
            }
            org.bukkit.enchantments.Enchantment ech = ec.get();
            int level = gameStorage.getEnchantLevel(team, ench).orElse(0);
            if (level <= 0) continue;
            newItem = ShopUtil.clampOrApplyEnchants(newItem, sharpnessLevel, ech, type, SBAConfig.getInstance().node("upgrades", "limit", ench).getInt(1));
        }
        return newItem;
    }

    private static boolean canApply(String string, ItemStack newItem) {
        if (SBAConfig.getInstance().upgrades().enchants().of(string) == null) {
            Logger.error("SBA doesn't know how to apply enchant {}, add it in the upgrade-item.enchants.ENCHANT_HERE", string);
            return false;
        }
        return SBAConfig.getInstance().upgrades().enchants().of(string).stream().anyMatch(x -> newItem.getType().toString().contains(x.toUpperCase()));
    }

    private static boolean canApply(String string, sba.sl.i.ItemStack newItem) {
        if (SBAConfig.getInstance().upgrades().enchants().of(string) == null) {
            Logger.error("SBA doesn't know how to apply enchant {}, add it in the upgrade-item.enchants.ENCHANT_HERE", string);
            return false;
        }
        return SBAConfig.getInstance().upgrades().enchants().of(string).stream().anyMatch(x -> newItem.getMaterial().platformName().contains(x.toUpperCase()));
    }

    private static boolean canApply(org.bukkit.enchantments.Enchantment string, ItemStack newItem) {
        return ShopUtil.canApply(ShopUtil.getName(string), newItem);
    }

    private static boolean canApply(org.bukkit.enchantments.Enchantment string, sba.sl.i.ItemStack newItem) {
        return ShopUtil.canApply(ShopUtil.getName(string), newItem);
    }

    private static String getName(org.bukkit.enchantments.Enchantment ech) {
        if (ech == org.bukkit.enchantments.Enchantment.DAMAGE_ALL) {
            return "sharpness";
        }
        if (ech == org.bukkit.enchantments.Enchantment.KNOCKBACK) {
            return "sharpness";
        }
        if (ech == org.bukkit.enchantments.Enchantment.DIG_SPEED) {
            return "efficiency";
        }
        if (ech == org.bukkit.enchantments.Enchantment.PROTECTION_ENVIRONMENTAL) {
            return "protection";
        }
        AtomicReference str = new AtomicReference();
        SBAConfig.getInstance().upgrades().enchants().keys().forEach(ench -> {
            Optional<org.bukkit.enchantments.Enchantment> ec = Arrays.stream(org.bukkit.enchantments.Enchantment.values()).filter(x -> x.getName().equalsIgnoreCase((String)ench) || EnchantmentType.of(x).location().path().equalsIgnoreCase((String)ench)).findFirst();
            if (ec.isPresent() && ec.get().equals((Object)ech)) {
                str.set(ench);
            }
        });
        return (String)str.get();
    }

    static <K, V> List<K> getAllKeysForValue(Map<K, V> mapOfWords, V value) {
        return mapOfWords.entrySet().stream().filter(entry -> entry.getValue().equals(value)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static <K, V> K getKey(Map<K, V> map, V value) {
        return map.keySet().stream().filter(key -> value.equals(map.get(key))).findAny().orElse(null);
    }

    public static void giveItemToPlayer(@NotNull List<ItemStack> itemStackList, Player player, TeamColor teamColor) {
        itemStackList.forEach(itemStack -> {
            if (itemStack == null) {
                return;
            }
            ColorChanger colorChanger = BedwarsAPI.getInstance().getColorChanger();
            String materialName = itemStack.getType().toString();
            PlayerInventory playerInventory = player.getInventory();
            if (materialName.contains("HELMET")) {
                playerInventory.setHelmet(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("CHESTPLATE")) {
                playerInventory.setChestplate(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("LEGGINGS")) {
                playerInventory.setLeggings(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("BOOTS")) {
                playerInventory.setBoots(colorChanger.applyColor(teamColor, itemStack));
            } else if (materialName.contains("PICKAXE")) {
                playerInventory.setItem(7, itemStack);
            } else if (materialName.contains("AXE")) {
                playerInventory.setItem(8, itemStack);
            } else if (materialName.contains("SWORD")) {
                playerInventory.setItem(0, itemStack);
            } else {
                playerInventory.addItem(new ItemStack[]{colorChanger.applyColor(teamColor, itemStack)});
            }
        });
    }

    public static ItemStack downgradeItem(ItemStack currentItem, DegradableItem itemType) {
        String currentItemName = ShopUtil.getMaterialFromArmorOrTools(currentItem.getType());
        int currentItemLevel = ShopUtil.getLevelFromMaterialName(currentItemName, orderOfTools);
        if (currentItemLevel == 0) {
            return currentItem;
        }
        int newItemLevel = currentItemLevel - 1;
        String newMaterialName = ShopUtil.getMaterialFromLevel(newItemLevel, itemType);
        Material newMaterial = Material.valueOf((String)(newMaterialName + currentItem.getType().name().substring(currentItem.getType().name().lastIndexOf("_")).toUpperCase()));
        ItemStack newStack = new ItemStack(newMaterial);
        newStack.addEnchantments(currentItem.getEnchantments());
        return newStack;
    }

    public static int getIntFromMode(String mode) {
        return mode.equalsIgnoreCase("Solo") ? 1 : (mode.equalsIgnoreCase("Double") ? 2 : (mode.equalsIgnoreCase("Triples") ? 3 : (mode.equalsIgnoreCase("Squads") ? 4 : 0)));
    }

    public static String translateColors(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static void sendMessage(Player player, List<String> message) {
        message.forEach(st -> player.sendMessage(ShopUtil.translateColors(st)));
    }

    public static File normalizeShopFile(String name) {
        File dataFolder = SBA.getBedwarsPlugin().getDataFolder();
        if (name.split("\\.").length > 1) {
            return dataFolder.toPath().resolve(name).toFile();
        }
        File fileg = dataFolder.toPath().resolve(name + ".groovy").toFile();
        if (fileg.exists()) {
            return fileg;
        }
        return dataFolder.toPath().resolve(name + ".yml").toFile();
    }

    public static Map<?, ?> nullValuesAllowingMap(Object ... objects) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Object key = null;
        for (Object object : objects) {
            if (key == null) {
                key = Objects.requireNonNull(object);
                continue;
            }
            map.put(key, object);
            key = null;
        }
        return map;
    }

    public static sba.sl.i.ItemStack setLore(sba.sl.i.ItemStack item, PlayerItemInfo itemInfo, String price, ItemSpawnerType type, Player player) {
        Boolean enabled = itemInfo.getFirstPropertyByName("generateLore").map(property -> property.getPropertyData().getBoolean()).orElseGet(() -> Main.getConfigurator().config.getBoolean("lore.generate-automatically", true));
        if (enabled.booleanValue()) {
            int limit;
            int currentLevel;
            List<Component> originalList = item.getLore();
            boolean isSharp = itemInfo.getFirstPropertyByName("sharpness").isPresent();
            boolean isProt = itemInfo.getFirstPropertyByName("protection").isPresent();
            boolean isEfficiency = itemInfo.getFirstPropertyByName("efficiency").isPresent();
            boolean isKnockback = itemInfo.getFirstPropertyByName("knockback").isPresent();
            Game game = Main.getInstance().getGameOfPlayer(player);
            IArena arena = ArenaManager.getInstance().get(game.getName()).orElseThrow();
            if (isSharp) {
                currentLevel = arena.getStorage().getSharpnessLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1;
                limit = SBAConfig.getInstance().node("upgrades", "limit", "Sharpness").getInt(2);
                if (currentLevel <= (limit = Math.min(limit, SBAStoreInventoryV2.sharpnessPrices.size()))) {
                    price = String.valueOf(SBAStoreInventoryV2.sharpnessPrices.get(arena.getStorage().getSharpnessLevel(game.getTeamOfPlayer(player)).orElseThrow()));
                }
            }
            if (isProt) {
                currentLevel = arena.getStorage().getProtectionLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1;
                limit = SBAConfig.getInstance().node("upgrades", "limit", "Protection").getInt(4);
                if (currentLevel <= (limit = Math.min(limit, SBAStoreInventoryV2.protectionPrices.size()))) {
                    price = String.valueOf(SBAStoreInventoryV2.protectionPrices.get(arena.getStorage().getProtectionLevel(game.getTeamOfPlayer(player)).orElseThrow()));
                }
            }
            if (isEfficiency) {
                currentLevel = arena.getStorage().getEfficiencyLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1;
                limit = SBAConfig.getInstance().node("upgrades", "limit", "Efficiency").getInt(4);
                if (currentLevel <= (limit = Math.min(limit, SBAStoreInventoryV2.efficiencyPrices.size()))) {
                    price = String.valueOf(SBAStoreInventoryV2.efficiencyPrices.get(arena.getStorage().getEfficiencyLevel(game.getTeamOfPlayer(player)).orElseThrow()));
                }
            }
            if (isKnockback) {
                currentLevel = arena.getStorage().getKnockbackLevel(game.getTeamOfPlayer(player)).orElseThrow() + 1;
                limit = SBAConfig.getInstance().node("upgrades", "limit", "Knockback").getInt(4);
                if (currentLevel <= (limit = Math.min(limit, SBAStoreInventoryV2.knockbackPrices.size()))) {
                    price = String.valueOf(SBAStoreInventoryV2.knockbackPrices.get(arena.getStorage().getKnockbackLevel(game.getTeamOfPlayer(player)).orElseThrow()));
                }
            }
            String finalPrice = price;
            ArrayList newList = itemInfo.getFirstPropertyByName("generatedLoreText").map(property -> property.getPropertyData().childrenList().stream().map(ConfigurationNode::getString)).orElseGet(() -> Main.getConfigurator().config.getStringList("lore.text").stream()).map(s -> s.replaceAll("%price%", finalPrice).replaceAll("%resource%", type.getItemName()).replaceAll("%amount%", Integer.toString(itemInfo.getStack().getAmount()))).map(s -> ChatColor.translateAlternateColorCodes((char)'&', (String)s)).map(Component::fromLegacy).collect(Collectors.toCollection(ArrayList::new));
            newList.addAll(originalList);
            return item.withItemLore(newList);
        }
        return item;
    }

    public static Component getNameOrCustomNameOfItem(sba.sl.i.ItemStack item) {
        try {
            if (item.getDisplayName() != null) {
                return item.getDisplayName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String normalItemName = item.getMaterial().platformName().replace("_", " ").toLowerCase();
        String[] sArray = normalItemName.split(" ");
        StringBuilder stringBuilder = new StringBuilder();
        for (String s : sArray) {
            stringBuilder.append(Character.toUpperCase(s.charAt(0))).append(s.substring(1)).append(" ");
        }
        return Message.of(List.of(stringBuilder.toString().trim())).toComponent();
    }

    public static void addEnchantsToPlayerArmor(Player player, int newLevel) {
        for (ItemStack item : player.getInventory().getArmorContents()) {
            if (item == null) continue;
            ShopUtil.applyTeamEnchants(player, item);
        }
    }

    public static sba.sl.i.ItemStack clampOrApplyEnchants(sba.sl.i.ItemStack item, int level, org.bukkit.enchantments.Enchantment enchantment, StoreType type, int maxLevel) {
        Logger.trace("--- {} ENCHANT IS lvl {}/{}", enchantment, level, maxLevel);
        if (type == StoreType.UPGRADES) {
            ++level;
        }
        if (level > maxLevel) {
            if ((item = item.withItemLore(LanguageService.getInstance().get(MessageKeys.SHOP_MAX_ENCHANT).toComponentList())).getEnchantments() != null) {
                item.getEnchantments().clear();
            }
        } else if (level > 0) {
            item = item.withEnchantment(Enchantment.of(enchantment).withLevel(level));
        }
        return item;
    }

    public static sba.sl.i.ItemStack applyTeamUpgradeEnchantsToItem(sba.sl.i.ItemStack item, ItemRenderEvent event, StoreType type) {
        Optional<IGameStorage> maybeStorage;
        Player player = event.getPlayer().as(Player.class);
        Game game = Main.getInstance().getGameOfPlayer(player);
        if (game == null) {
            return item;
        }
        String typeName = item.getMaterial().platformName();
        RunningTeam runningTeam = game.getTeamOfPlayer(player);
        if (runningTeam == null) {
            return item;
        }
        List<Price> prices = event.getInfo().getOriginal().getPrices();
        if (!prices.isEmpty()) {
            ArrayList<Component> lore = new ArrayList<Component>(item.getLore());
            lore.add(LanguageService.getInstance().get(MessageKeys.CLICK_TO_PURCHASE).toComponent());
            item = item.withItemLore(lore);
        }
        if ((maybeStorage = SBA.getInstance().getGameStorage(game)).isPresent()) {
            IGameStorage gameStorage = maybeStorage.get();
            String afterUnderscore = typeName;
            item = ShopUtil.applyTeamEnchants(player, item, type, event.getOriginalInfo().getProperties());
        }
        return item;
    }

    public static void generateOptions(LocalOptionsBuilder localOptionsBuilder) {
        ItemStack backItem = Main.getConfigurator().readDefinedItem("shopback", "BARRIER");
        ItemMeta backItemMeta = backItem.getItemMeta();
        localOptionsBuilder.renderHeaderStart(600).renderFooterStart(600).renderOffset(9).rows(4).renderActualRows(4).showPageNumber(false);
    }

    public static String ChatColorChanger(Player player) {
        SBAPlayerWrapper db = PlayerWrapperService.getInstance().get(player).orElseThrow();
        if (db.getLevel() > 100 || player.isOp()) {
            return "\u00a7f";
        }
        return "\u00a77";
    }

    public static void applyTeamUpgrades(@NotNull Player player, Game game) {
        if (game == null) {
            return;
        }
        RunningTeam team = game.getTeamOfPlayer(player);
        if (team == null) {
            return;
        }
        Optional<IArena> maybeGameStorage = ArenaManager.getInstance().get(game.getName());
        if (!maybeGameStorage.isPresent()) {
            return;
        }
        IGameStorage gameStorage = maybeGameStorage.get().getStorage();
        Integer teamProtectionLevel = gameStorage.getProtectionLevel(team).orElse(0);
        if (teamProtectionLevel > 0) {
            ShopUtil.addEnchantsToPlayerArmor(player, teamProtectionLevel);
        }
        Integer finalTeamSharpnessLevel = gameStorage.getSharpnessLevel(team).orElse(0);
        Integer finalTeamEfficiencyLevel = gameStorage.getEfficiencyLevel(team).orElse(0);
        Logger.trace("Player teamProtectionLevel {}", teamProtectionLevel);
        Logger.trace("Player finalTeamSharpnessLevel {}", finalTeamSharpnessLevel);
        Logger.trace("Player finalTeamEfficiencyLevel {}", finalTeamEfficiencyLevel);
        Arrays.stream(player.getInventory().getContents()).filter(Objects::nonNull).forEach(item -> ShopUtil.applyTeamEnchants(player, item));
    }
}

