/*
 * Decompiled with CFR 0.152.
 */
package sba.c.reactive;

import java.util.Iterator;
import java.util.concurrent.Executor;
import sba.c.reactive.AbstractProcessor;
import sba.c.reactive.Processor;
import sba.c.reactive.Subscriber;
import sba.c.reactive.TransactionFailedException;
import sba.c.reactive.TransactionalRegistration;
import sba.c.reactive.TransactionalSubscriber;

class TransactionalProcessorImpl<V>
extends AbstractProcessor<V, TransactionalRegistration<V>>
implements Processor.TransactionalIso<V> {
    protected TransactionalProcessorImpl(Executor executor) {
        super(executor);
    }

    @Override
    public void submit(V item) {
        this.executor.execute(() -> Processor.TransactionalIso.super.submit(item));
    }

    @Override
    public void beginTransaction(V newValue) throws TransactionFailedException {
        if (this.subscriberCount.get() >= 0) {
            Subscriber fallback;
            boolean handled = false;
            Iterator it = this.registrations.iterator();
            while (it.hasNext()) {
                TransactionalRegistration reg = (TransactionalRegistration)it.next();
                try {
                    handled = true;
                    reg.beginTransaction(newValue);
                }
                catch (TransactionFailedException ex) {
                    throw ex;
                }
                catch (Exception t) {
                    it.remove();
                    this.subscriberCount.getAndDecrement();
                    reg.onError(t);
                }
            }
            if (!handled && (fallback = this.fallbackHandler) != null) {
                fallback.submit(newValue);
            }
        }
    }

    @Override
    public void commit() {
        this.forEachOrRemove(TransactionalRegistration::commit);
    }

    @Override
    public void rollback() {
        this.forEachOrRemove(TransactionalRegistration::rollback);
    }

    @Override
    protected TransactionalRegistration<V> createRegistration(Subscriber<? super V> sub) {
        if (sub instanceof TransactionalSubscriber) {
            return new TransactionalRegistration.Fully(this, (TransactionalSubscriber)sub);
        }
        return new TransactionalRegistration.Wrapped<V>(this, sub);
    }
}

