/*
 * Decompiled with CFR 0.152.
 */
package sba.c.serialize;

import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import sba.c.serialize.ScalarSerializer;
import sba.c.serialize.SerializationException;
import sba.c.util.CheckedFunction;

final class FunctionScalarSerializer<T>
extends ScalarSerializer<T> {
    private final CheckedFunction<Object, T, SerializationException> deserializer;
    private final BiFunction<T, Predicate<Class<?>>, Object> serializer;

    FunctionScalarSerializer(Type type, CheckedFunction<Object, T, SerializationException> deserializer, BiFunction<T, Predicate<Class<?>>, Object> serializer) {
        super(type);
        this.deserializer = deserializer;
        this.serializer = serializer;
    }

    @Override
    public T deserialize(Type type, Object obj) throws SerializationException {
        try {
            return this.deserializer.apply(obj);
        }
        catch (SerializationException ex) {
            ex.initType(type);
            throw ex;
        }
    }

    @Override
    public Object serialize(T item, Predicate<Class<?>> typeSupported) {
        return this.serializer.apply(item, typeSupported);
    }
}

