/*
 * Decompiled with CFR 0.152.
 */
package sba.cl.arguments;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import sba.cl.CommandManager;
import sba.cl.CommandTree;
import sba.cl.arguments.CommandSuggestionEngine;
import sba.cl.context.CommandContext;
import sba.cl.execution.preprocessor.CommandPreprocessingContext;
import sba.cl.internal.CommandInputTokenizer;
import sba.cl.services.State;

public final class DelegatingCommandSuggestionEngine<C>
implements CommandSuggestionEngine<C> {
    private static final List<String> SINGLE_EMPTY_SUGGESTION = Collections.unmodifiableList(Collections.singletonList(""));
    private final CommandManager<C> commandManager;
    private final CommandTree<C> commandTree;

    DelegatingCommandSuggestionEngine(@NonNull CommandManager<C> commandManager, @NonNull CommandTree<C> commandTree) {
        this.commandManager = commandManager;
        this.commandTree = commandTree;
    }

    @Override
    public @NonNull List<@NonNull String> getSuggestions(@NonNull CommandContext<C> context, @NonNull String input) {
        @NonNull LinkedList<@NonNull String> inputQueue = new CommandInputTokenizer(input).tokenize();
        context.store("__raw_input__", new LinkedList<String>(inputQueue));
        List suggestions = this.commandManager.preprocessContext(context, inputQueue) == State.ACCEPTED ? (List)this.commandManager.getCommandSuggestionProcessor().apply(new CommandPreprocessingContext<C>(context, inputQueue), this.commandTree.getSuggestions(context, inputQueue)) : Collections.emptyList();
        if (this.commandManager.getSetting(CommandManager.ManagerSettings.FORCE_SUGGESTION) && suggestions.isEmpty()) {
            return SINGLE_EMPTY_SUGGESTION;
        }
        return suggestions;
    }
}

