/*
 * Decompiled with CFR 0.152.
 */
package sba.si.inventory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sba.si.events.ItemRenderEvent;
import sba.si.inventory.GenericItemInfo;
import sba.si.inventory.InventorySet;
import sba.si.inventory.Property;
import sba.si.inventory.SubInventory;
import sba.sl.i.ItemStack;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.pa.Player;
import sba.sl.spectator.Component;

public class PlayerItemInfo {
    private GenericItemInfo original;
    private ItemStack stack;
    private boolean visible;
    private boolean disabled;
    private final List<ItemStack> animation = new ArrayList<ItemStack>();
    private Player player;

    public PlayerItemInfo(Player player, GenericItemInfo original) {
        this.player = player;
        this.original = original;
        this.stack = original.getItem() != null ? original.getItem().clone() : ItemStackFactory.getAir();
        this.visible = original.isVisible();
        this.disabled = original.isDisabled();
        original.getAnimation().stream().map(ItemStack::clone).forEach(this.animation::add);
        if (this.stack.getDisplayName() != null) {
            this.stack = this.stack.withDisplayName(original.getFormat().processPlaceholders(player, this.stack.getDisplayName(), this));
        }
        if (!this.stack.getLore().isEmpty()) {
            this.stack = this.stack.withItemLore(this.stack.getLore().stream().map(e -> original.getFormat().processPlaceholders(player, (Component)e, this)).collect(Collectors.toList()));
        }
        original.getEventManager().fireEvent(new ItemRenderEvent(this));
    }

    public String getId() {
        return this.original.getId();
    }

    public int getPosition() {
        return this.original.getPosition();
    }

    public List<Property> getProperties() {
        return this.original.getProperties();
    }

    public boolean hasId() {
        return this.original.hasId();
    }

    public boolean hasProperties() {
        return this.original.hasProperties();
    }

    public boolean hasAnimation() {
        return !this.animation.isEmpty();
    }

    public boolean hasChildInventory() {
        return this.original.hasChildInventory();
    }

    public SubInventory getChildInventory() {
        return this.original.getChildInventory();
    }

    public InventorySet getFormat() {
        return this.original.getFormat();
    }

    public SubInventory getParent() {
        return this.original.getParent();
    }

    public Stream<Property> getPropertiesByName(String name) {
        return this.original.getPropertiesByName(name);
    }

    public Optional<Property> getFirstPropertyByName(String name) {
        return this.original.getFirstPropertyByName(name);
    }

    public GenericItemInfo getOriginal() {
        return this.original;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public List<ItemStack> getAnimation() {
        return this.animation;
    }

    public void setOriginal(GenericItemInfo original) {
        this.original = original;
    }

    public void setStack(ItemStack stack) {
        this.stack = stack;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerItemInfo)) {
            return false;
        }
        PlayerItemInfo other = (PlayerItemInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isVisible() != other.isVisible()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        GenericItemInfo this$original = this.getOriginal();
        GenericItemInfo other$original = other.getOriginal();
        if (this$original == null ? other$original != null : !((Object)this$original).equals(other$original)) {
            return false;
        }
        ItemStack this$stack = this.getStack();
        ItemStack other$stack = other.getStack();
        if (this$stack == null ? other$stack != null : !this$stack.equals(other$stack)) {
            return false;
        }
        List<ItemStack> this$animation = this.getAnimation();
        List<ItemStack> other$animation = other.getAnimation();
        if (this$animation == null ? other$animation != null : !((Object)this$animation).equals(other$animation)) {
            return false;
        }
        Player this$player = this.getPlayer();
        Player other$player = other.getPlayer();
        return !(this$player == null ? other$player != null : !this$player.equals(other$player));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerItemInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isVisible() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        GenericItemInfo $original = this.getOriginal();
        result = result * 59 + ($original == null ? 43 : ((Object)$original).hashCode());
        ItemStack $stack = this.getStack();
        result = result * 59 + ($stack == null ? 43 : $stack.hashCode());
        List<ItemStack> $animation = this.getAnimation();
        result = result * 59 + ($animation == null ? 43 : ((Object)$animation).hashCode());
        Player $player = this.getPlayer();
        result = result * 59 + ($player == null ? 43 : $player.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerItemInfo(original=" + this.getOriginal() + ", stack=" + this.getStack() + ", visible=" + this.isVisible() + ", disabled=" + this.isDisabled() + ", animation=" + this.getAnimation() + ", player=" + this.getPlayer() + ")";
    }

    public Player getPlayer() {
        return this.player;
    }
}

