/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.e.damage;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.TaggableHolder;
import sba.sl.impl.entity.damage.DamageTypeRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface DamageType
extends RegistryItem,
RawValueHolder,
TaggableHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.DAMAGE_TYPE) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static DamageType of(@MinecraftType(value=MinecraftType.Type.DAMAGE_TYPE) @NotNull Object damageType) {
        DamageType result = DamageType.ofNullable(damageType);
        Preconditions.checkNotNullIllegal(result, "Could not find damage type: " + String.valueOf(damageType));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static DamageType ofNullable(@MinecraftType(value=MinecraftType.Type.DAMAGE_TYPE) @Nullable Object damageType) {
        if (damageType instanceof DamageType) {
            return (DamageType)damageType;
        }
        return (DamageType)DamageTypeRegistry.getInstance().resolveMapping(damageType);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull DamageType> all() {
        return DamageTypeRegistry.getInstance().getRegistryItemStream();
    }
}

