/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.e.villager;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.entity.villager.ProfessionRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.RawValueHolder;
import sba.sl.u.annotations.ide.MinecraftType;
import sba.sl.u.registry.RegistryItem;
import sba.sl.u.registry.RegistryItemStream;

public interface Profession
extends RegistryItem,
RawValueHolder {
    @ApiStatus.Experimental
    @NotNull
    public String platformName();

    @Override
    public boolean is(@MinecraftType(value=MinecraftType.Type.PROFESSION) @Nullable Object var1);

    @Override
    public boolean is(Object ... var1);

    @NotNull
    public static Profession of(@MinecraftType(value=MinecraftType.Type.PROFESSION) @NotNull Object profession) {
        Profession result = Profession.ofNullable(profession);
        Preconditions.checkNotNullIllegal(result, "Could not find profession: " + String.valueOf(profession));
        return result;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Profession ofNullable(@MinecraftType(value=MinecraftType.Type.PROFESSION) @Nullable Object profession) {
        if (profession instanceof Profession) {
            return (Profession)profession;
        }
        return (Profession)ProfessionRegistry.getInstance().resolveMapping(profession);
    }

    @NotNull
    public static @NotNull RegistryItemStream<@NotNull Profession> all() {
        return ProfessionRegistry.getInstance().getRegistryItemStream();
    }
}

