/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import sba.sl.b.Block;
import sba.sl.i.ItemType;
import sba.sl.impl.block.BlockRegistry;
import sba.sl.impl.item.ItemTypeRegistry;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.u.annotations.methods.OnPostConstruct;

@ProvidedService
@ApiStatus.Internal
public abstract class ItemBlockIdsRemapper {
    @NotNull
    protected final ItemTypeRegistry itemTypeMapper;
    @NotNull
    protected final BlockRegistry blockTypeMapper;
    @NotNull
    protected final @NotNull List<@NotNull MappingFlags> mappingFlags = new ArrayList<MappingFlags>();
    @NotNull
    public static final @NotNull List<@NotNull String> COLORS = List.of("WHITE", "ORANGE", "MAGENTA", "LIGHT_BLUE", "YELLOW", "LIME", "PINK", "GRAY", "LIGHT_GRAY", "CYAN", "PURPLE", "BLUE", "BROWN", "GREEN", "RED", "BLACK");
    @NotNull
    public static final @NotNull Map<@NotNull Predicate<Block>, Function<String, Optional<Block>>> colorableBlocks = new HashMap<Predicate<Block>, Function<String, Optional<Block>>>();
    @NotNull
    public static final @NotNull Map<@NotNull Predicate<ItemType>, Function<String, Optional<ItemType>>> colorableItems = new HashMap<Predicate<ItemType>, Function<String, Optional<ItemType>>>();

    @OnPostConstruct
    public void doMapping() {
        this.flatteningMapping();
        this.javaAutoColorable();
    }

    private void javaAutoColorable() {
        this.makeColorable("WOOL");
        this.makeColorable("CARPET");
        this.makeColorable("CONCRETE");
        this.makeColorable("CONCRETE_POWDER");
        this.makeColorable("TERRACOTTA");
        this.makeColorable("STAINED_GLASS", "GLASS");
        this.makeColorable("STAINED_GLASS_PANE", "GLASS_PANE");
        this.makeColorable("SHULKER_BOX");
        this.makeColorable("BANNER");
        this.makeColorable("GLAZED_TERRACOTTA");
        if (!this.mappingFlags.contains((Object)MappingFlags.NO_COLORED_BEDS)) {
            this.makeColorable("BED");
        }
    }

    private void makeColorable(@NotNull String baseName) {
        this.makeColorableItem(baseName, baseName);
        this.makeColorableBlock(baseName, baseName);
    }

    private void makeColorableBlock(@NotNull String baseName) {
        this.makeColorableBlock(baseName, baseName);
    }

    private void makeColorableItem(@NotNull String baseName) {
        this.makeColorableItem(baseName, baseName);
    }

    private void makeColorable(@NotNull String baseName, @NotNull String notColoredName) {
        this.makeColorableBlock(baseName, notColoredName);
        this.makeColorableItem(baseName, notColoredName);
    }

    private void makeColorableBlock(@NotNull String baseName, @NotNull String notColoredName) {
        ArrayList<Block> list = new ArrayList<Block>();
        COLORS.forEach(s -> {
            Block block = Block.ofNullable(s + "_" + baseName);
            if (block != null && !list.contains(block)) {
                list.add(block);
            }
        });
        Block block = Block.ofNullable(notColoredName);
        if (block != null && !list.contains(block)) {
            list.add(block);
        }
        if (!list.isEmpty()) {
            colorableBlocks.put(list::contains, s -> {
                if (COLORS.contains(s.toUpperCase(Locale.ROOT))) {
                    return Optional.ofNullable(Block.ofNullable(s.toUpperCase(Locale.ROOT) + "_" + baseName));
                }
                return Optional.empty();
            });
        }
    }

    private void makeColorableItem(@NotNull String baseName, @NotNull String notColoredName) {
        ArrayList<ItemType> list = new ArrayList<ItemType>();
        COLORS.forEach(s -> {
            ItemType item = ItemType.ofNullable(s + "_" + baseName);
            if (item != null && !list.contains(item)) {
                list.add(item);
            }
        });
        ItemType item = ItemType.ofNullable(notColoredName);
        if (item != null && !list.contains(item)) {
            list.add(item);
        }
        if (!list.isEmpty()) {
            colorableItems.put(list::contains, s -> {
                if (COLORS.contains(s.toUpperCase(Locale.ROOT))) {
                    return Optional.ofNullable(ItemType.ofNullable(s.toUpperCase(Locale.ROOT) + "_" + baseName));
                }
                return Optional.empty();
            });
        }
    }

    private void flatteningMapping() {
        this.mapAliasItem("zombified_piglin_spawn_egg", "zombie_pigman_spawn_egg");
        this.mapAlias("smooth_stone_slab", "stone_slab");
        this.mapAliasItem("green_dye", "cactus_green");
        this.mapAliasItem("yellow_dye", "dandelion_yellow");
        this.mapAliasItem("red_dye", "rose_red");
        this.mapAliasItem("turtle_scute", "scute");
        this.mapAlias("oak_sign", "sign");
        this.mapAlias("birch_sign", "sign");
        this.mapAlias("dark_oak_sign", "sign");
        this.mapAlias("jungle_sign", "sign");
        this.mapAlias("spruce_sign", "sign");
        this.mapAlias("acacia_sign", "sign");
        this.mapAlias("oak_wall_sign", "wall_sign");
        this.mapAlias("birch_wall_sign", "wall_sign");
        this.mapAlias("birch_wall_sign", "wall_sign");
        this.mapAlias("dark_oak_wall_sign", "wall_sign");
        this.mapAlias("jungle_wall_sign", "wall_sign");
        this.mapAlias("spruce_wall_sign", "wall_sign");
        this.mapAlias("acacia_wall_sign", "wall_sign");
        this.mapAlias("dirt_path", "grass_path");
        this.mapAlias("water_cauldron", "cauldron");
        this.mapAlias("short_grass", "grass");
        this.mapAlias("wool", "white_wool");
        this.mapAlias("carpet", "white_carpet");
        this.mapAlias("concrete", "white_concrete");
        this.mapAlias("concrete_powder", "white_concrete_powder");
        this.mapAlias("stained_glass", "white_stained_glass");
        this.mapAlias("stained_glass_pane", "white_stained_glass_pane");
        this.mapAlias("banner", "white_banner");
        this.mapAlias("glazed_terracotta", "white_glazed_terracotta");
        if (!this.mappingFlags.contains((Object)MappingFlags.NO_COLORED_BEDS)) {
            this.mapAlias("bed", "white_bed");
        } else {
            this.mapAlias("bed", "red_bed");
        }
    }

    protected void mapAlias(@NotNull String mappingKey, @NotNull String alias) {
        this.itemTypeMapper.mapAlias(mappingKey, alias);
        this.blockTypeMapper.mapAlias(mappingKey, alias);
    }

    protected void mapAliasItem(@NotNull String mappingKey, @NotNull String alias) {
        this.itemTypeMapper.mapAlias(mappingKey, alias);
    }

    protected void mapAliasBlock(@NotNull String mappingKey, @NotNull String alias) {
        this.blockTypeMapper.mapAlias(mappingKey, alias);
    }

    @Generated
    public ItemBlockIdsRemapper(@NotNull ItemTypeRegistry itemTypeMapper, @NotNull BlockRegistry blockTypeMapper) {
        if (itemTypeMapper == null) {
            throw new NullPointerException("itemTypeMapper is marked non-null but is null");
        }
        if (blockTypeMapper == null) {
            throw new NullPointerException("blockTypeMapper is marked non-null but is null");
        }
        this.itemTypeMapper = itemTypeMapper;
        this.blockTypeMapper = blockTypeMapper;
    }

    public static enum MappingFlags {
        NO_COLORED_BEDS;

    }
}

