/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.adventure.spectator.event;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.k.a.t.event.ClickEvent;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.adventure.spectator.AdventureFeature;
import sba.sl.impl.adventure.spectator.event.click.PayloadConverter;
import sba.sl.spectator.event.ClickEvent;
import sba.sl.spectator.event.click.Payload;
import sba.sl.u.BasicWrapper;
import sba.sl.u.Preconditions;

public class AdventureClickEvent
extends BasicWrapper<sba.k.a.t.event.ClickEvent>
implements ClickEvent {
    public AdventureClickEvent(@NotNull sba.k.a.t.event.ClickEvent wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public ClickEvent.Action action() {
        try {
            return ClickEvent.Action.valueOf(((sba.k.a.t.event.ClickEvent)this.wrappedObject).action().name());
        }
        catch (Throwable ignored) {
            return ClickEvent.Action.OPEN_URL;
        }
    }

    @Override
    @NotNull
    public ClickEvent withAction(@NotNull ClickEvent.Action action) {
        if (AdventureFeature.CLICK_EVENT_PAYLOAD.isSupported()) {
            return new AdventureClickEvent(PayloadConverter.withAction(ClickEvent.Action.valueOf(action.name()), (sba.k.a.t.event.ClickEvent)this.wrappedObject));
        }
        return new AdventureClickEvent(sba.k.a.t.event.ClickEvent.clickEvent(ClickEvent.Action.valueOf(action.name()), ((sba.k.a.t.event.ClickEvent)this.wrappedObject).value()));
    }

    @Override
    @NotNull
    public Payload payload() {
        if (AdventureFeature.CLICK_EVENT_PAYLOAD.isSupported()) {
            return PayloadConverter.convertPayload((sba.k.a.t.event.ClickEvent)this.wrappedObject);
        }
        return new Payload.Text.Default(((sba.k.a.t.event.ClickEvent)this.wrappedObject).value());
    }

    @Override
    @NotNull
    public ClickEvent withPayload(@NotNull Payload payload) {
        String value;
        if (AdventureFeature.CLICK_EVENT_PAYLOAD.isSupported()) {
            return new AdventureClickEvent(PayloadConverter.withPayload(((sba.k.a.t.event.ClickEvent)this.wrappedObject).action(), payload));
        }
        if (payload instanceof Payload.Text) {
            value = ((Payload.Text)payload).text();
        } else if (payload instanceof Payload.Int) {
            value = String.valueOf(((Payload.Int)payload).number());
        } else {
            throw new IllegalArgumentException("Invalid payload type for action " + ((sba.k.a.t.event.ClickEvent)this.wrappedObject).action().name() + ": " + String.valueOf(payload.getClass()));
        }
        return new AdventureClickEvent(sba.k.a.t.event.ClickEvent.clickEvent(((sba.k.a.t.event.ClickEvent)this.wrappedObject).action(), value));
    }

    @Override
    public @NotNull ClickEvent.Builder toBuilder() {
        return new AdventureClickEventBuilder(this.action(), this.payload());
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        try {
            return super.as(type);
        }
        catch (Throwable ignored) {
            return AdventureBackend.getAdditionalClickEventConverter().convert(this, type);
        }
    }

    public static class AdventureClickEventBuilder
    implements ClickEvent.Builder {
        @NotNull
        private ClickEvent.Action action = ClickEvent.Action.OPEN_URL;
        @Nullable
        private Payload payload;

        @Override
        @NotNull
        public ClickEvent build() {
            String value;
            Preconditions.checkNotNull(this.action, "Action is not specified!");
            Preconditions.checkNotNull(this.payload, "Payload is not specified!");
            if (AdventureFeature.CLICK_EVENT_PAYLOAD.isSupported()) {
                return new AdventureClickEvent(PayloadConverter.withPayload(ClickEvent.Action.valueOf(this.action.name()), this.payload));
            }
            if (this.payload instanceof Payload.Text) {
                value = ((Payload.Text)this.payload).text();
            } else if (this.payload instanceof Payload.Int) {
                value = String.valueOf(((Payload.Int)this.payload).number());
            } else {
                throw new IllegalArgumentException("Invalid payload type for action " + this.action.name() + ": " + String.valueOf(this.payload.getClass()));
            }
            return new AdventureClickEvent(sba.k.a.t.event.ClickEvent.clickEvent(ClickEvent.Action.valueOf(this.action.name()), value));
        }

        @Generated
        public AdventureClickEventBuilder() {
        }

        @Generated
        public AdventureClickEventBuilder(@NotNull ClickEvent.Action action, @Nullable Payload payload) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            this.payload = payload;
        }

        @Override
        @Generated
        public AdventureClickEventBuilder action(@NotNull ClickEvent.Action action) {
            if (action == null) {
                throw new NullPointerException("action is marked non-null but is null");
            }
            this.action = action;
            return this;
        }

        @Override
        @Generated
        public AdventureClickEventBuilder payload(@Nullable Payload payload) {
            this.payload = payload;
            return this;
        }
    }
}

