/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.attribute;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.function.Function;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.BasicConfigurationNode;
import sba.c.ConfigurateException;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.sl.a.Attribute;
import sba.sl.a.AttributeModifier;
import sba.sl.a.ItemAttribute;
import sba.sl.co.AttributeModifierSerializer;
import sba.sl.co.ItemAttributeSerializer;
import sba.sl.impl.attribute.AttributeTypeRegistry;
import sba.sl.impl.slot.EquipmentSlotRegistry;
import sba.sl.u.BidirectionalConverter;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.u.annotations.ServiceDependencies;

@ProvidedService
@ApiStatus.Internal
@ServiceDependencies(dependsOn={AttributeTypeRegistry.class, EquipmentSlotRegistry.class})
public abstract class Attributes {
    @Nullable
    private static Attributes attributeMapping;
    @NotNull
    private static final @NotNull Function<@NotNull ConfigurationNode, @Nullable AttributeModifier> CONFIGURATE_LOAD_MODIFIER;
    @NotNull
    private static final @NotNull Function<@NotNull ConfigurationNode, @Nullable ItemAttribute> CONFIGURATE_LOAD_ITEM;
    @NotNull
    protected final BidirectionalConverter<AttributeModifier> attributeModifierConverter = BidirectionalConverter.build().registerP2W(ConfigurationNode.class, CONFIGURATE_LOAD_MODIFIER).registerP2W(Map.class, map -> {
        try {
            return CONFIGURATE_LOAD_MODIFIER.apply(BasicConfigurationNode.root().set(map));
        }
        catch (ConfigurateException ignored) {
            return null;
        }
    }).registerP2W(AttributeModifier.class, e -> e);
    @NotNull
    protected final BidirectionalConverter<ItemAttribute> itemAttributeConverter = BidirectionalConverter.build().registerP2W(ConfigurationNode.class, CONFIGURATE_LOAD_ITEM).registerP2W(Map.class, map -> {
        try {
            return CONFIGURATE_LOAD_ITEM.apply(BasicConfigurationNode.root().set(map));
        }
        catch (ConfigurateException ignored) {
            return null;
        }
    }).registerP2W(ItemAttribute.class, e -> e);

    public Attributes() {
        if (attributeMapping != null) {
            throw new UnsupportedOperationException("AttributeMapping is already initialized.");
        }
        attributeMapping = this;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Attribute wrapAttribute(@Nullable Object attribute) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return attributeMapping.wrapAttribute0(attribute);
    }

    @Nullable
    protected abstract Attribute wrapAttribute0(@Nullable Object var1);

    @Contract(value="null -> null")
    @Nullable
    public static AttributeModifier wrapAttributeModifier(@Nullable Object attributeModifier) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return Attributes.attributeMapping.attributeModifierConverter.convertNullable(attributeModifier);
    }

    @Contract(value="null -> null")
    @Nullable
    public static ItemAttribute wrapItemAttribute(@Nullable Object attribute) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return Attributes.attributeMapping.itemAttributeConverter.convertNullable(attribute);
    }

    public static <T> T convertItemAttributeHolder(@NotNull ItemAttribute holder, @NotNull Class<T> newType) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return Attributes.attributeMapping.itemAttributeConverter.convert(holder, newType);
    }

    public static <T> T convertAttributeModifierHolder(@NotNull AttributeModifier holder, @NotNull Class<T> newType) {
        if (attributeMapping == null) {
            throw new UnsupportedOperationException("AttributeMapping is not initialized yet.");
        }
        return Attributes.attributeMapping.attributeModifierConverter.convert(holder, newType);
    }

    static {
        CONFIGURATE_LOAD_MODIFIER = node -> {
            try {
                return AttributeModifierSerializer.INSTANCE.deserialize((Type)((Object)AttributeModifier.class), (ConfigurationNode)node);
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        };
        CONFIGURATE_LOAD_ITEM = node -> {
            try {
                return ItemAttributeSerializer.INSTANCE.deserialize((Type)((Object)ItemAttribute.class), (ConfigurationNode)node);
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        };
    }
}

