/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.b.Block;
import sba.sl.impl.bukkit.block.BukkitBlockRegistry1_13;
import sba.sl.u.BasicWrapper;
import sba.sl.u.ResourceLocation;

public class BukkitBlock1_13
extends BasicWrapper<BlockData>
implements Block {
    public BukkitBlock1_13(@NotNull Material type) {
        this(type.createBlockData());
        if (!type.isBlock()) {
            throw new UnsupportedOperationException("Material must be a block!");
        }
    }

    public BukkitBlock1_13(@NotNull BlockData wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public String platformName() {
        return ((BlockData)this.wrappedObject).getMaterial().name();
    }

    @Override
    @NotNull
    public @Unmodifiable @NotNull Map<@NotNull String, String> stateData() {
        String data = ((BlockData)this.wrappedObject).getAsString();
        if (data.contains("[") && data.contains("]")) {
            String values = data.substring(data.indexOf("[") + 1, data.lastIndexOf("]"));
            if (values.isEmpty()) {
                return Map.of();
            }
            return Arrays.stream(values.split(",")).map(next -> next.split("=")).collect(Collectors.toUnmodifiableMap(next -> next[0], next1 -> next1[1]));
        }
        return Map.of();
    }

    @Override
    @NotNull
    public Block withStateData(@NotNull @NotNull Map<@NotNull String, String> stateData) {
        StringBuilder builder = new StringBuilder();
        if (!stateData.isEmpty()) {
            builder.append('[');
            builder.append(stateData.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining(",")));
            builder.append(']');
        }
        return new BukkitBlock1_13(((BlockData)this.wrappedObject).getMaterial().createBlockData(builder.toString()));
    }

    @Override
    @NotNull
    public Block with(final @NotNull String attribute, final @NotNull String value) {
        return this.withStateData((Map<String, String>)new HashMap<String, String>(this.stateData()){
            {
                super(m);
                this.put(attribute, value);
            }
        });
    }

    @Override
    @NotNull
    public Block with(final @NotNull String attribute, final int value) {
        return this.withStateData((Map<String, String>)new HashMap<String, String>(this.stateData()){
            {
                super(m);
                this.put(attribute, String.valueOf(value));
            }
        });
    }

    @Override
    @NotNull
    public Block with(final @NotNull String attribute, final boolean value) {
        return this.withStateData((Map<String, String>)new HashMap<String, String>(this.stateData()){
            {
                super(m);
                this.put(attribute, String.valueOf(value));
            }
        });
    }

    @Override
    @Nullable
    public String get(@NotNull String attribute) {
        return this.stateData().get(attribute);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String attribute) {
        String value = this.stateData().get(attribute);
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String attribute) {
        String value = this.stateData().get(attribute);
        if (value != null) {
            return Boolean.parseBoolean(value);
        }
        return null;
    }

    @Override
    public boolean isSolid() {
        return ((BlockData)this.wrappedObject).getMaterial().isSolid();
    }

    @Override
    public boolean isTransparent() {
        return ((BlockData)this.wrappedObject).getMaterial().isTransparent();
    }

    @Override
    public boolean isFlammable() {
        return ((BlockData)this.wrappedObject).getMaterial().isFlammable();
    }

    @Override
    public boolean isBurnable() {
        return ((BlockData)this.wrappedObject).getMaterial().isBurnable();
    }

    @Override
    public boolean isOccluding() {
        return ((BlockData)this.wrappedObject).getMaterial().isOccluding();
    }

    @Override
    public boolean hasGravity() {
        return ((BlockData)this.wrappedObject).getMaterial().hasGravity();
    }

    @Override
    public boolean hasTag(@NotNull Object tag) {
        ResourceLocation key = tag instanceof ResourceLocation ? (ResourceLocation)tag : ResourceLocation.of(tag.toString());
        Tag bukkitTag = Bukkit.getTag((String)"blocks", (NamespacedKey)new NamespacedKey(key.namespace(), key.path()), Material.class);
        if (bukkitTag != null) {
            return bukkitTag.isTagged((Keyed)((BlockData)this.wrappedObject).getMaterial());
        }
        if (!"minecraft".equals(key.namespace())) {
            return false;
        }
        String value = key.path();
        return BukkitBlockRegistry1_13.hasTagInBackPorts(((BlockData)this.wrappedObject).getMaterial(), value);
    }

    @Override
    public boolean isSameType(@Nullable Object object) {
        if (object instanceof Material) {
            return ((BlockData)this.wrappedObject).getMaterial() == object;
        }
        if (object instanceof BukkitBlock1_13) {
            return ((BlockData)this.wrappedObject).getMaterial() == ((BlockData)((BukkitBlock1_13)object).wrappedObject).getMaterial();
        }
        if (object instanceof BlockData) {
            return ((BlockData)this.wrappedObject).getMaterial() == ((BlockData)object).getMaterial();
        }
        Block blockType = Block.ofNullable(object);
        if (blockType == null) {
            return false;
        }
        return blockType.platformName().equals(this.platformName());
    }

    @Override
    public boolean isSameType(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::isSameType);
    }

    @Override
    public boolean is(@Nullable Object object) {
        if (object instanceof BlockData || object instanceof BukkitBlock1_13) {
            return this.equals(object);
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.startsWith("#")) {
                return this.hasTag(str.substring(1));
            }
            if (str.endsWith("[*]")) {
                return this.isSameType((Object)str.substring(0, str.length() - 3));
            }
        }
        return this.equals(Block.ofNullable(object));
    }

    @Override
    public boolean is(Object ... objects) {
        return Arrays.stream(objects).anyMatch(this::is);
    }

    @Override
    @NotNull
    public String completeState() {
        return ((BlockData)this.wrappedObject).getAsString();
    }

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type == Material.class) {
            return (T)((BlockData)this.wrappedObject).getMaterial();
        }
        return super.as(type);
    }

    @Override
    @NotNull
    public ResourceLocation location() {
        NamespacedKey key = ((BlockData)this.wrappedObject).getMaterial().getKey();
        return ResourceLocation.of(key.getNamespace(), key.getKey());
    }
}

