/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.block.snapshot;

import java.util.Arrays;
import org.bukkit.block.Sign;
import org.bukkit.block.TileState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;
import sba.sl.b.snapshot.SignBlockSnapshot;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.block.snapshot.BukkitBlockEntitySnapshot;
import sba.sl.spectator.Component;

public class BukkitSignBlockSnapshot
extends BukkitBlockEntitySnapshot
implements SignBlockSnapshot {
    protected BukkitSignBlockSnapshot(@NotNull Sign wrappedObject) {
        super((TileState)wrappedObject);
    }

    @Override
    @NotNull
    public @NotNull Component @NotNull [] frontLines() {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            return (Component[])((Sign)this.wrappedObject).lines().stream().map(AdventureBackend::wrapComponent).toArray(Component[]::new);
        }
        return (Component[])Arrays.stream(((Sign)this.wrappedObject).getLines()).map(Component::fromLegacy).toArray(Component[]::new);
    }

    @Override
    @NotNull
    public Component frontLine(@Range(from=0L, to=3L) int index) {
        return this.frontLines()[index];
    }

    @Override
    public void frontLine(@Range(from=0L, to=3L) int index, Component component) {
        if (BukkitCore.getSpectatorBackend().hasAdventure()) {
            ((Sign)this.wrappedObject).line(index, component.as(sba.k.a.t.Component.class));
        } else {
            ((Sign)this.wrappedObject).setLine(index, component.toLegacy());
        }
    }

    @Override
    public boolean waxed() {
        if (BukkitFeature.SIGN_IS_WAXED.isSupported()) {
            return ((Sign)this.wrappedObject).isWaxed();
        }
        return !((Sign)this.wrappedObject).isEditable();
    }

    @Override
    public void waxed(boolean waxed) {
        if (BukkitFeature.SIGN_IS_WAXED.isSupported()) {
            ((Sign)this.wrappedObject).setWaxed(waxed);
        } else {
            ((Sign)this.wrappedObject).setEditable(!waxed);
        }
    }

    @Override
    public boolean frontSideGlowing() {
        if (BukkitFeature.SIGN_IS_GLOWING_TEXT.isSupported()) {
            return ((Sign)this.wrappedObject).isGlowingText();
        }
        return false;
    }

    @Override
    public void frontSideGlowing(boolean glowing) {
        if (BukkitFeature.SIGN_IS_GLOWING_TEXT.isSupported()) {
            ((Sign)this.wrappedObject).setGlowingText(glowing);
        }
    }
}

