/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Collection;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.b.BlockPlacement;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.entity.EntityExplodeEvent;
import sba.sl.impl.bukkit.block.BukkitBlockPlacement;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.utils.collections.CollectionLinkedToCollection;
import sba.sl.impl.world.Locations;
import sba.sl.w.Location;

public class BukkitEntityExplodeEvent
implements EntityExplodeEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.entity.EntityExplodeEvent event;
    @Nullable
    private Entity entity;
    @Nullable
    private Location location;
    private @Nullable Collection<@NotNull BlockPlacement> blocks;

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    @NotNull
    public Location location() {
        if (this.location == null) {
            this.location = Locations.wrapLocation(this.event.getLocation());
        }
        return this.location;
    }

    @Override
    @NotNull
    public @NotNull Collection<@NotNull BlockPlacement> blocks() {
        if (this.blocks == null) {
            this.blocks = new CollectionLinkedToCollection<BlockPlacement, Block>(this.event.blockList(), o -> o.as(Block.class), BukkitBlockPlacement::new);
        }
        return this.blocks;
    }

    @Override
    public float yield() {
        return this.event.getYield();
    }

    @Override
    public void yield(float yield) {
        this.event.setYield(yield);
    }

    @Generated
    public BukkitEntityExplodeEvent(@NotNull org.bukkit.event.entity.EntityExplodeEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityExplodeEvent)) {
            return false;
        }
        BukkitEntityExplodeEvent other = (BukkitEntityExplodeEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.entity.EntityExplodeEvent this$event = this.event();
        org.bukkit.event.entity.EntityExplodeEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityExplodeEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.entity.EntityExplodeEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityExplodeEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.entity.EntityExplodeEvent event() {
        return this.event;
    }
}

