/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.entity;

import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.e.Entities;
import sba.sl.e.Entity;
import sba.sl.ev.entity.EntityShootBowEvent;
import sba.sl.i.ItemStack;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.sl.EquipmentSlot;

public class BukkitEntityShootBowEvent
implements EntityShootBowEvent,
BukkitCancellable {
    @NotNull
    private final org.bukkit.event.entity.EntityShootBowEvent event;
    @Nullable
    private Entity entity;
    @Nullable
    private ItemStack bow;
    private boolean bowCached;
    @Nullable
    private ItemStack consumable;
    private boolean consumableCached;
    @Nullable
    private EquipmentSlot hand;

    @Override
    @NotNull
    public Entity entity() {
        if (this.entity == null) {
            this.entity = Objects.requireNonNull(Entities.wrapEntity(this.event.getEntity()));
        }
        return this.entity;
    }

    @Override
    @Nullable
    public ItemStack bow() {
        if (!this.bowCached) {
            if (this.event.getBow() != null) {
                this.bow = new BukkitItem(this.event.getBow());
            }
            this.bowCached = true;
        }
        return this.bow;
    }

    @Override
    @Nullable
    public ItemStack consumable() {
        if (!this.consumableCached) {
            if (BukkitFeature.ENTITY_SHOOT_BOW_EVENT_CONSUMABLE.isSupported()) {
                if (this.event.getConsumable() != null) {
                    this.consumable = new BukkitItem(this.event.getConsumable());
                }
            } else {
                this.consumable = null;
            }
            this.consumableCached = true;
        }
        return this.consumable;
    }

    @Override
    @NotNull
    public Entity projectile() {
        return Objects.requireNonNull(Entities.wrapEntity(this.event.getProjectile()));
    }

    @Override
    @NotNull
    public EquipmentSlot hand() {
        if (this.hand == null) {
            this.hand = BukkitFeature.ENTITY_SHOOT_BOW_EVENT_HAND.isSupported() ? EquipmentSlot.of(this.event.getHand()) : EquipmentSlot.of("main_hand");
        }
        return this.hand;
    }

    @Override
    public float force() {
        return this.event.getForce();
    }

    @Override
    public boolean consumeItem() {
        if (BukkitFeature.ENTITY_SHOOT_BOW_EVENT_CONSUMABLE.isSupported()) {
            return this.event.shouldConsumeItem();
        }
        return false;
    }

    @Override
    public void consumeItem(boolean consumeItem) {
        if (BukkitFeature.ENTITY_SHOOT_BOW_EVENT_CONSUMABLE.isSupported()) {
            this.event.setConsumeItem(consumeItem);
        }
    }

    @Generated
    public BukkitEntityShootBowEvent(@NotNull org.bukkit.event.entity.EntityShootBowEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitEntityShootBowEvent)) {
            return false;
        }
        BukkitEntityShootBowEvent other = (BukkitEntityShootBowEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        org.bukkit.event.entity.EntityShootBowEvent this$event = this.event();
        org.bukkit.event.entity.EntityShootBowEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitEntityShootBowEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        org.bukkit.event.entity.EntityShootBowEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitEntityShootBowEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public org.bukkit.event.entity.EntityShootBowEvent event() {
        return this.event;
    }
}

