/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.event.player;

import java.util.Objects;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.cn.Container;
import sba.sl.cn.ContainerFactory;
import sba.sl.ev.Event;
import sba.sl.ev.player.PlayerInventoryClickEvent;
import sba.sl.i.ItemStack;
import sba.sl.impl.bukkit.entity.BukkitPlayer;
import sba.sl.impl.bukkit.event.BukkitCancellable;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.u.ClickType;
import sba.sl.u.InventoryAction;
import sba.sl.u.SlotType;

public class BukkitPlayerInventoryClickEvent
implements PlayerInventoryClickEvent,
BukkitCancellable {
    @NotNull
    private final InventoryClickEvent event;
    @Nullable
    private sba.sl.pa.Player player;
    @Nullable
    private Container clickedInventory;
    private boolean clickedInventoryCached;
    @Nullable
    private ClickType clickType;
    @Nullable
    private Container inventory;
    @Nullable
    private InventoryAction action;
    @Nullable
    private SlotType slotType;

    @Override
    @NotNull
    public sba.sl.pa.Player player() {
        if (this.player == null) {
            this.player = new BukkitPlayer((Player)this.event.getWhoClicked());
        }
        return this.player;
    }

    @Override
    @Nullable
    public ItemStack cursorItem() {
        if (this.event.getCursor() == null) {
            return null;
        }
        return new BukkitItem(this.event.getCursor());
    }

    @Override
    @Nullable
    public ItemStack currentItem() {
        if (this.event.getCurrentItem() == null) {
            return null;
        }
        return new BukkitItem(this.event.getCurrentItem());
    }

    @Override
    public void currentItem(@Nullable ItemStack currentItem) {
        this.event.setCurrentItem(currentItem == null ? null : currentItem.as(org.bukkit.inventory.ItemStack.class));
    }

    @Override
    @Nullable
    public Container clickedInventory() {
        if (!this.clickedInventoryCached) {
            if (this.event.getClickedInventory() != null) {
                this.clickedInventory = (Container)Objects.requireNonNull(ContainerFactory.wrapContainer(this.event.getClickedInventory()));
            }
            this.clickedInventoryCached = true;
        }
        return this.clickedInventory;
    }

    @Override
    @NotNull
    public ClickType clickType() {
        if (this.clickType == null) {
            this.clickType = ClickType.convert(this.event.getClick().name());
        }
        return this.clickType;
    }

    @Override
    @NotNull
    public Container inventory() {
        if (this.inventory == null) {
            this.inventory = (Container)Objects.requireNonNull(ContainerFactory.wrapContainer(this.event.getInventory()));
        }
        return this.inventory;
    }

    @Override
    @NotNull
    public InventoryAction action() {
        if (this.action == null) {
            this.action = InventoryAction.convert(this.event.getAction().name());
        }
        return this.action;
    }

    @Override
    public int hotbarButton() {
        return this.event.getHotbarButton();
    }

    @Override
    public int slot() {
        return this.event.getSlot();
    }

    @Override
    @NotNull
    public SlotType slotType() {
        if (this.slotType == null) {
            this.slotType = SlotType.convert(this.event.getSlotType().name());
        }
        return this.slotType;
    }

    @Override
    public int rawSlot() {
        return this.event.getRawSlot();
    }

    @Override
    @NotNull
    public Event.Result result() {
        return Event.Result.convert(this.event.getResult().name());
    }

    @Override
    public void result(@NotNull Event.Result result) {
        this.event.setResult(Event.Result.valueOf((String)this.event.getResult().name()));
    }

    @Generated
    public BukkitPlayerInventoryClickEvent(@NotNull InventoryClickEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        this.event = event;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitPlayerInventoryClickEvent)) {
            return false;
        }
        BukkitPlayerInventoryClickEvent other = (BukkitPlayerInventoryClickEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InventoryClickEvent this$event = this.event();
        InventoryClickEvent other$event = other.event();
        return !(this$event == null ? other$event != null : !this$event.equals(other$event));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitPlayerInventoryClickEvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InventoryClickEvent $event = this.event();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitPlayerInventoryClickEvent(event=" + String.valueOf(this.event()) + ")";
    }

    @NotNull
    @Generated
    public InventoryClickEvent event() {
        return this.event;
    }
}

