/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.item.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.KnowledgeBookMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.tags.CustomItemTagContainer;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.a.ItemAttribute;
import sba.sl.f.FireworkEffect;
import sba.sl.i.HideFlags;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.i.builder.ItemStackBuilder;
import sba.sl.i.data.ItemData;
import sba.sl.i.meta.Enchantment;
import sba.sl.i.meta.Potion;
import sba.sl.i.meta.PotionEffect;
import sba.sl.impl.adventure.spectator.AdventureBackend;
import sba.sl.impl.bukkit.BukkitCore;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.attribute.BukkitItemAttribute;
import sba.sl.impl.bukkit.compat.datafixer2.DataFixer2Compat;
import sba.sl.impl.bukkit.compat.v1_20_1.PotionDataCompat;
import sba.sl.impl.bukkit.compat.v1_8_8.PotionCompat;
import sba.sl.impl.bukkit.item.BukkitItem;
import sba.sl.impl.bukkit.item.BukkitItemType1_8;
import sba.sl.impl.bukkit.item.data.BukkitItemDataCustomTags;
import sba.sl.impl.bukkit.item.data.BukkitItemDataPersistentContainer;
import sba.sl.impl.bukkit.item.data.CraftBukkitItemData;
import sba.sl.impl.bukkit.utils.DataFixerUtils;
import sba.sl.impl.bukkit.utils.Version;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.core.MappedRegistryAccessor;
import sba.sl.impl.nms.accessors.nbt.CompoundTagAccessor;
import sba.sl.impl.nms.accessors.nbt.ListTagAccessor;
import sba.sl.impl.nms.accessors.server.MinecraftServerAccessor;
import sba.sl.impl.nms.accessors.server.VVV.DataConverterManagerAccessor;
import sba.sl.impl.nms.accessors.util.datafix.fixes.ReferencesAccessor;
import sba.sl.impl.nms.accessors.world.item.ItemAccessor;
import sba.sl.impl.nms.accessors.world.item.ItemStackAccessor;
import sba.sl.impl.vanilla.nbt.NBTVanillaSerializer;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.SNBTSerializer;
import sba.sl.spectator.Component;
import sba.sl.u.ResourceLocation;
import sba.sl.u.StringUtils;
import sba.sl.u.reflect.Reflect;

public class BukkitItemBuilder
implements ItemStackBuilder {
    private org.bukkit.inventory.ItemStack item;

    @Override
    @NotNull
    public ItemStackBuilder type(@NotNull ItemType type) {
        short durability;
        if (this.item == null) {
            this.item = new org.bukkit.inventory.ItemStack(Material.AIR);
        }
        this.item.setType(type.as(Material.class));
        if (type instanceof BukkitItemType1_8 && (durability = ((BukkitItemType1_8)type).forcedDurability()) != 0) {
            this.durability(durability);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder durability(int durability) {
        return this.durability((short)durability);
    }

    public ItemStackBuilder durability(short durability) {
        if (!BukkitFeature.FLATTENING.isSupported()) {
            this.item.setDurability(durability);
        } else {
            ItemMeta meta = this.item.getItemMeta();
            if (meta instanceof Damageable) {
                ((Damageable)meta).setDamage((int)durability);
                this.item.setItemMeta(meta);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder amount(int amount) {
        if (this.item == null) {
            return this;
        }
        this.item.setAmount(amount);
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder displayName(@Nullable Component displayName) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (BukkitCore.getSpectatorBackend().hasAdventure()) {
                meta.displayName(displayName != null ? displayName.as(sba.k.a.t.Component.class) : null);
            } else {
                meta.setDisplayName(displayName != null ? displayName.toLegacy() : null);
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder itemLore(@Nullable List<@NotNull Component> lore) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (lore == null) {
                meta.setLore(null);
            } else if (BukkitCore.getSpectatorBackend().hasAdventure()) {
                meta.lore(lore.stream().map(component -> component.as(sba.k.a.t.Component.class)).collect(Collectors.toList()));
            } else {
                meta.setLore(lore.stream().map(Component::toLegacy).collect(Collectors.toList()));
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder attributeModifiers(@Nullable List<@NotNull ItemAttribute> modifiers) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_ATTRIBUTE_MODIFIERS_API.isSupported()) {
                meta.setAttributeModifiers(null);
                if (modifiers != null) {
                    modifiers.stream().map(holder -> holder.as(BukkitItemAttribute.class)).forEach(holder -> meta.addAttributeModifier(holder.getAttribute(), holder.getAttributeModifier()));
                }
                this.item.setItemMeta(meta);
            } else if (modifiers != null) {
                this.fillStackWithModifiers(modifiers.stream().map(this::constructPre1_13AttributeModifier).map(NBTVanillaSerializer::serialize).collect(Collectors.toList()));
            } else {
                Object nbt;
                if (!ClassStorage.CB.CraftItemStack.isInstance(this.item)) {
                    this.item = ClassStorage.asCBStack(this.item);
                }
                if ((nbt = Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_GET_TAG.get())) != null && Reflect.fastInvoke(nbt, CompoundTagAccessor.METHOD_GET.get(), "AttributeModifiers") != null) {
                    Reflect.fastInvoke(nbt, CompoundTagAccessor.METHOD_REMOVE.get(), "AttributeModifiers");
                    Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_SET_TAG.get(), nbt);
                }
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder attributeModifier(@NotNull ItemAttribute modifier) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_ATTRIBUTE_MODIFIERS_API.isSupported()) {
                BukkitItemAttribute mod = modifier.as(BukkitItemAttribute.class);
                meta.addAttributeModifier(mod.getAttribute(), mod.getAttributeModifier());
                this.item.setItemMeta(meta);
            } else {
                CompoundTag tag = this.constructPre1_13AttributeModifier(modifier);
                Object serialized = NBTVanillaSerializer.serialize(tag);
                this.fillStackWithModifiers(List.of(serialized));
            }
        }
        return this;
    }

    private void fillStackWithModifiers(@NotNull @NotNull List<@NotNull Object> modifiers) {
        Object nbt;
        Object attributes;
        if (!ClassStorage.CB.CraftItemStack.isInstance(this.item)) {
            this.item = ClassStorage.asCBStack(this.item);
        }
        Object object = attributes = (nbt = Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_GET_TAG.get())) != null ? Reflect.fastInvoke(nbt, CompoundTagAccessor.METHOD_GET.get(), "AttributeModifiers") : null;
        if (nbt == null) {
            nbt = Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0]);
        }
        if (attributes == null || !ListTagAccessor.TYPE.get().isInstance(attributes)) {
            attributes = Reflect.construct(ListTagAccessor.CONSTRUCTOR_0.get(), new Object[0]);
            Reflect.fastInvoke(nbt, CompoundTagAccessor.METHOD_PUT.get(), "AttributeModifiers", attributes);
        }
        for (Object modifier : modifiers) {
            Reflect.fastInvoke(attributes, ListTagAccessor.METHOD_ADD.get(), modifier);
        }
        Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_SET_TAG.get(), nbt);
    }

    @NotNull
    private CompoundTag constructPre1_13AttributeModifier(@NotNull ItemAttribute modifier) {
        CompoundTag ct = CompoundTag.EMPTY.with("AttributeName", StringUtils.snakeToCamel(modifier.getType().location().path())).with("Name", modifier.getName()).with("Amount", modifier.getAmount()).with("Operation", modifier.getOperation().ordinal()).with("UUIDLeast", modifier.getUuid().getLeastSignificantBits()).with("UUIDMost", modifier.getUuid().getMostSignificantBits());
        if (modifier.getSlot() != null) {
            String value = null;
            switch (modifier.getSlot().platformName()) {
                case "HAND": {
                    if (BukkitFeature.OFF_HAND.isSupported()) {
                        value = "mainhand";
                        break;
                    }
                    value = "hand";
                    break;
                }
                case "OFF_HAND": {
                    value = "offhand";
                    break;
                }
                case "FEET": {
                    value = "feet";
                    break;
                }
                case "LEGS": {
                    value = "legs";
                    break;
                }
                case "CHEST": {
                    value = "chest";
                    break;
                }
                case "HEAD": {
                    value = "head";
                }
            }
            if (value != null) {
                ct = ct.with("Slot", value);
            }
        }
        return ct;
    }

    @Override
    @NotNull
    public ItemStackBuilder data(@NotNull @NotNull Consumer<@NotNull ItemData> dataBuilder) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_META_PDC.isSupported()) {
                dataBuilder.accept(new BukkitItemDataPersistentContainer(meta.getPersistentDataContainer()));
                this.item.setItemMeta(meta);
            } else if (BukkitFeature.ITEM_META_CUSTOM_TAG.isSupported()) {
                dataBuilder.accept(new BukkitItemDataCustomTags(meta.getCustomTagContainer()));
                this.item.setItemMeta(meta);
            } else {
                Object compound;
                Map unhandled = (Map)Reflect.getField((Object)meta, "unhandledTags");
                if (unhandled.containsKey("PublicBukkitValues")) {
                    compound = unhandled.get("PublicBukkitValues");
                } else {
                    compound = Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0]);
                    unhandled.put("PublicBukkitValues", compound);
                }
                HashMap<String, Object> nmap = new HashMap<String, Object>();
                if (CompoundTagAccessor.TYPE.get().isInstance(compound)) {
                    Set keys = (Set)Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_KEY_SET.get());
                    for (Object key : keys) {
                        nmap.put(key.toString(), Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_GET.get(), key));
                    }
                }
                CraftBukkitItemData cbItemData = new CraftBukkitItemData(nmap);
                dataBuilder.accept(cbItemData);
                cbItemData.getKeyNBTMap().forEach((s, o) -> Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_PUT.get(), s, o));
                this.item.setItemMeta(meta);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder data(@NotNull ItemData data) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_META_PDC.isSupported()) {
                if (data instanceof BukkitItemDataPersistentContainer && !data.isEmpty()) {
                    PersistentDataContainer origDataContainer = ((BukkitItemDataPersistentContainer)data).getDataContainer();
                    Reflect.getMethod((Object)meta.getPersistentDataContainer(), "putAll", Map.class).invoke(Reflect.fastInvoke((Object)origDataContainer, "getRaw"));
                    this.item.setItemMeta(meta);
                }
            } else if (BukkitFeature.ITEM_META_CUSTOM_TAG.isSupported()) {
                if (data instanceof BukkitItemDataCustomTags && !data.isEmpty()) {
                    CustomItemTagContainer origDataContainer = ((BukkitItemDataCustomTags)data).getDataContainer();
                    Reflect.getMethod((Object)meta.getCustomTagContainer(), "putAll", Map.class).invoke(Reflect.fastInvoke((Object)origDataContainer, "getRaw"));
                    this.item.setItemMeta(meta);
                }
            } else if (data instanceof CraftBukkitItemData && !data.isEmpty()) {
                Object compound;
                Map unhandled = (Map)Reflect.getField((Object)meta, "unhandledTags");
                if (unhandled.containsKey("PublicBukkitValues")) {
                    compound = unhandled.get("PublicBukkitValues");
                } else {
                    compound = Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0]);
                    unhandled.put("PublicBukkitValues", compound);
                }
                ((CraftBukkitItemData)data).getKeyNBTMap().forEach((s, o) -> Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_PUT.get(), s, o));
                this.item.setItemMeta(meta);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder hideFlags(@Nullable List<@NotNull HideFlags> flags) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            try {
                meta.removeItemFlags((ItemFlag[])meta.getItemFlags().toArray(ItemFlag[]::new));
                if (flags != null) {
                    meta.addItemFlags((ItemFlag[])flags.stream().map(HideFlags::getBukkitName).map(ItemFlag::valueOf).toArray(ItemFlag[]::new));
                }
                this.item.setItemMeta(meta);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder hideFlag(@NotNull HideFlags flag) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            try {
                meta.addItemFlags(new ItemFlag[]{ItemFlag.valueOf((String)flag.getBukkitName())});
                this.item.setItemMeta(meta);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder enchantments(@Nullable List<@NotNull Enchantment> enchantments) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            meta.getEnchants().keySet().forEach(arg_0 -> ((ItemMeta)meta).removeEnchant(arg_0));
            if (enchantments != null) {
                enchantments.forEach(e -> {
                    if (meta instanceof EnchantmentStorageMeta) {
                        ((EnchantmentStorageMeta)meta).addStoredEnchant(e.as(org.bukkit.enchantments.Enchantment.class), e.level(), true);
                    } else {
                        meta.addEnchant(e.as(org.bukkit.enchantments.Enchantment.class), e.level(), true);
                    }
                });
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder enchantment(@NotNull Enchantment enchantment) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (meta instanceof EnchantmentStorageMeta) {
                ((EnchantmentStorageMeta)meta).addStoredEnchant(enchantment.as(org.bukkit.enchantments.Enchantment.class), enchantment.level(), true);
            } else {
                meta.addEnchant(enchantment.as(org.bukkit.enchantments.Enchantment.class), enchantment.level(), true);
            }
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder customModelData(@Nullable Integer data) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null && BukkitFeature.ITEM_META_CUSTOM_MODEL_DATA.isSupported()) {
            meta.setCustomModelData(data);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder unbreakable(boolean unbreakable) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            if (BukkitFeature.ITEM_META_IS_UNBREAKABLE.isSupported()) {
                meta.setUnbreakable(unbreakable);
                this.item.setItemMeta(meta);
            } else {
                Object spigot = Reflect.fastInvoke((Object)meta, "spigot");
                if (spigot != null) {
                    Reflect.getMethod(spigot, "setUnbreakable", Boolean.TYPE).invoke(unbreakable);
                    this.item.setItemMeta(meta);
                }
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder repairCost(int repairCost) {
        if (this.item == null) {
            return this;
        }
        ItemMeta meta = this.item.getItemMeta();
        if (meta instanceof Repairable) {
            ((Repairable)meta).setRepairCost(repairCost);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder tag(@NotNull CompoundTag tag, int dataVersion) {
        block13: {
            block15: {
                block14: {
                    if (this.item == null) {
                        this.item = new org.bukkit.inventory.ItemStack(Material.AIR);
                    }
                    if (!ClassStorage.CB.CraftItemStack.isInstance(this.item)) {
                        this.item = ClassStorage.asCBStack(this.item);
                    }
                    if (dataVersion == 0 || !Version.isVersion(1, 9)) break block13;
                    if (!Version.isVersion(1, 13)) break block14;
                    int currentVersion = Bukkit.getUnsafe().getDataVersion();
                    if (dataVersion >= currentVersion) break block13;
                    CompoundTag compound = CompoundTag.EMPTY.with("id", this.item.getType().getKey().toString()).with(dataVersion > 3837 ? "count" : "Count", this.item.getAmount()).with(dataVersion > 3837 ? "components" : "tag", tag);
                    Object vanilla = NBTVanillaSerializer.serialize(compound);
                    vanilla = BukkitFeature.DATA_FIXER_SPLIT_SERIALIZATION.isSupported() ? DataFixerUtils.dataFixItemStack(vanilla, dataVersion, currentVersion) : DataFixer2Compat.dataFixItemStack(vanilla, dataVersion, currentVersion);
                    if (ItemStackAccessor.METHOD_PARSE.get() != null || Version.isVersion(1, 21, 6)) {
                        Object optional = Version.isVersion(1, 21, 6) ? DataFixerUtils.parseItemStack(vanilla) : Reflect.fastInvoke(ItemStackAccessor.METHOD_PARSE.get(), Reflect.fastInvoke(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.METHOD_REGISTRY_ACCESS.get()), vanilla);
                        if (optional instanceof Optional) {
                            this.item = ClassStorage.nmsAsStack(((Optional)optional).orElseThrow(() -> new IllegalArgumentException("The given tag is not applicable to the item of type " + String.valueOf(this.item.getType().getKey()) + ": " + SNBTSerializer.builder().shouldSaveLongArraysDirectly(true).build().serialize(tag))));
                        }
                    } else {
                        Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_SET_TAG.get(), Reflect.fastInvoke(vanilla, CompoundTagAccessor.METHOD_GET.get(), "tag"));
                    }
                    break block15;
                }
                Integer currentVersion = Server.getDataVersion();
                if (dataVersion >= currentVersion) break block13;
                CompoundTag compound = CompoundTag.EMPTY.with("id", Reflect.fastInvoke(ItemAccessor.CONST_REGISTRY.get(), MappedRegistryAccessor.METHOD_FUNC_177774_C.get(), Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_GET_ITEM.get())).toString()).with("Count", this.item.getAmount()).with("tag", tag);
                Object vanilla = NBTVanillaSerializer.serialize(compound);
                Object fixerUpper = Reflect.getField(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.FIELD_DATA_CONVERTER_MANAGER.get());
                vanilla = Reflect.fastInvoke(fixerUpper, DataConverterManagerAccessor.METHOD_FUNC_188251_A.get(), ReferencesAccessor.CONST_ITEM_STACK.get(), vanilla, dataVersion);
                Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_SET_TAG.get(), Reflect.fastInvoke(vanilla, CompoundTagAccessor.METHOD_GET.get(), "tag"));
            }
            return this;
        }
        if (ItemStackAccessor.METHOD_PARSE.get() != null || Version.isVersion(1, 21, 6)) {
            if (this.item.getType().isAir()) {
                throw new UnsupportedOperationException("Cannot apply tag to AIR.");
            }
            CompoundTag compound = CompoundTag.EMPTY.with("id", this.item.getType().getKey().toString()).with("count", this.item.getAmount()).with("components", tag);
            Object vanilla = NBTVanillaSerializer.serialize(compound);
            Object optional = Version.isVersion(1, 21, 6) ? DataFixerUtils.parseItemStack(vanilla) : Reflect.fastInvoke(ItemStackAccessor.METHOD_PARSE.get(), Reflect.fastInvoke(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.METHOD_REGISTRY_ACCESS.get()), vanilla);
            if (optional instanceof Optional) {
                this.item = ClassStorage.nmsAsStack(((Optional)optional).orElseThrow(() -> new IllegalArgumentException("The given tag is not applicable to the item of type " + String.valueOf(this.item.getType().getKey()) + ": " + SNBTSerializer.builder().shouldSaveLongArraysDirectly(true).build().serialize(tag))));
            }
        } else {
            Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_SET_TAG.get(), NBTVanillaSerializer.serialize(tag));
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder mergeTag(@NotNull CompoundTag tag) {
        if (this.item == null) {
            this.item = new org.bukkit.inventory.ItemStack(Material.AIR);
        }
        if (!ClassStorage.CB.CraftItemStack.isInstance(this.item)) {
            this.item = ClassStorage.asCBStack(this.item);
        }
        Object serialized = NBTVanillaSerializer.serialize(tag);
        if (ItemStackAccessor.METHOD_PARSE.get() != null || Version.isVersion(1, 21, 6)) {
            Object nmsStack = ClassStorage.stackAsNMS(this.item);
            Object compound = Version.isVersion(1, 21, 6) ? DataFixerUtils.encodeItemStack(nmsStack) : Reflect.fastInvoke(nmsStack, ItemStackAccessor.METHOD_SAVE_1.get(), Reflect.fastInvoke(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.METHOD_REGISTRY_ACCESS.get()), Reflect.construct(CompoundTagAccessor.CONSTRUCTOR_0.get(), new Object[0]));
            if (compound == null) {
                return this;
            }
            Object nbt = Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_GET.get(), "components");
            if (nbt != null) {
                Reflect.fastInvoke(nbt, CompoundTagAccessor.METHOD_MERGE.get(), serialized);
            } else {
                Reflect.fastInvoke(compound, CompoundTagAccessor.METHOD_PUT.get(), "components", serialized);
            }
            Object optional = Reflect.fastInvoke(ItemStackAccessor.METHOD_PARSE.get(), Reflect.fastInvoke(ClassStorage.getMinecraftServerObject(), MinecraftServerAccessor.METHOD_REGISTRY_ACCESS.get()), compound);
            if (optional instanceof Optional) {
                this.item = ClassStorage.nmsAsStack(((Optional)optional).orElseThrow(() -> new IllegalArgumentException("The given tag is not applicable to the item of type " + String.valueOf(this.item.getType().getKey()) + ": " + SNBTSerializer.builder().shouldSaveLongArraysDirectly(true).build().serialize(tag))));
            }
        } else {
            Object nbt = Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_GET_TAG.get());
            if (nbt != null) {
                Reflect.fastInvoke(nbt, CompoundTagAccessor.METHOD_MERGE.get(), serialized);
            } else {
                nbt = serialized;
            }
            Reflect.fastInvoke(ClassStorage.getHandleOfItemStack(this.item), ItemStackAccessor.METHOD_SET_TAG.get(), nbt);
        }
        return this;
    }

    @Override
    @Nullable
    public ItemStack build() {
        return this.item != null ? new BukkitItem(this.item.clone()) : null;
    }

    @Override
    @NotNull
    public ItemStackBuilder platformMeta(Object meta) {
        if (this.item == null) {
            return this;
        }
        if (meta instanceof ItemMeta) {
            try {
                this.item.setItemMeta((ItemMeta)meta);
            }
            catch (Throwable throwable) {}
        } else if (meta instanceof Map) {
            try {
                this.item.setItemMeta((ItemMeta)ConfigurationSerialization.deserializeObject((Map)((Map)meta)));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder lore(@NotNull Component component) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) != null) {
            ArrayList<Component> list = new ArrayList<Component>();
            if (BukkitCore.getSpectatorBackend().hasAdventure()) {
                Objects.requireNonNullElseGet(meta.lore(), List::of).forEach(o -> list.add(AdventureBackend.wrapComponent(o)));
            } else {
                Objects.requireNonNullElseGet(meta.getLore(), List::of).forEach(o -> list.add(Component.fromLegacy(o)));
            }
            list.add(component);
            this.itemLore(list);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder potion(@NotNull Object potion) {
        ItemMeta meta;
        Potion potionData = Potion.ofNullable(potion);
        if (this.item != null && potionData != null && (meta = this.item.getItemMeta()) instanceof PotionMeta) {
            if (BukkitFeature.POTION_REGISTRY.isSupported()) {
                ((PotionMeta)meta).setBasePotionType(potionData.as(PotionType.class));
                this.item.setItemMeta(meta);
            } else if (BukkitFeature.POTION_API.isSupported()) {
                PotionDataCompat.setPotionData((PotionMeta)meta, potionData);
                this.item.setItemMeta(meta);
            } else {
                PotionCompat.applyPotion(this.item, potionData);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder effect(@NotNull Object effect) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) instanceof PotionMeta) {
            if (effect instanceof List) {
                List list = (List)effect;
                list.forEach(effect1 -> {
                    PotionEffect potionEffect = PotionEffect.ofNullable(effect1);
                    if (potionEffect != null) {
                        ((PotionMeta)meta).addCustomEffect(potionEffect.as(org.bukkit.potion.PotionEffect.class), true);
                    }
                });
                this.item.setItemMeta(meta);
                return this;
            }
            PotionEffect potionEffect = PotionEffect.ofNullable(effect);
            if (potionEffect != null) {
                ((PotionMeta)meta).addCustomEffect(potionEffect.as(org.bukkit.potion.PotionEffect.class), true);
                this.item.setItemMeta(meta);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder recipe(@NotNull ResourceLocation key) {
        ItemMeta meta;
        if (BukkitFeature.KNOWLEDGE_BOOK_META.isSupported() && this.item != null && (meta = this.item.getItemMeta()) instanceof KnowledgeBookMeta) {
            ((KnowledgeBookMeta)meta).addRecipe(new NamespacedKey[]{new NamespacedKey(key.namespace(), key.path())});
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder color(@NotNull sba.sl.spectator.Color color) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) instanceof LeatherArmorMeta) {
            ((LeatherArmorMeta)meta).setColor(Color.fromRGB((int)color.red(), (int)color.green(), (int)color.blue()));
            this.item.setItemMeta(meta);
            return this;
        }
        if (BukkitFeature.POTION_META_COLOR.isSupported()) {
            if (this.item != null && (meta = this.item.getItemMeta()) instanceof PotionMeta) {
                ((PotionMeta)meta).setColor(Color.fromRGB((int)color.red(), (int)color.green(), (int)color.blue()));
                this.item.setItemMeta(meta);
            }
            return this;
        }
        return this.mergeTag(CompoundTag.EMPTY.with("CustomPotionColor", color.compoundRgb()));
    }

    @Override
    @NotNull
    public ItemStackBuilder skullOwner(@Nullable String skullOwner) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) instanceof SkullMeta) {
            ((SkullMeta)meta).setOwner(skullOwner);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder fireworkEffect(@NotNull Object effect) {
        if (this.item != null) {
            FireworkEffect fireworkEffect;
            ItemMeta meta = this.item.getItemMeta();
            if (meta instanceof FireworkMeta) {
                if (effect instanceof List) {
                    List list = (List)effect;
                    list.forEach(effect1 -> {
                        FireworkEffect fireworkEffect = FireworkEffect.ofNullable(effect1);
                        if (fireworkEffect != null) {
                            ((FireworkMeta)meta).addEffect(fireworkEffect.as(org.bukkit.FireworkEffect.class));
                        }
                    });
                    this.item.setItemMeta(meta);
                    return this;
                }
                FireworkEffect fireworkEffect2 = FireworkEffect.ofNullable(effect);
                if (fireworkEffect2 != null) {
                    ((FireworkMeta)meta).addEffect(fireworkEffect2.as(org.bukkit.FireworkEffect.class));
                    this.item.setItemMeta(meta);
                }
            } else if (meta instanceof FireworkEffectMeta && (fireworkEffect = FireworkEffect.ofNullable(effect)) != null) {
                ((FireworkEffectMeta)meta).setEffect(fireworkEffect.as(org.bukkit.FireworkEffect.class));
                this.item.setItemMeta(meta);
            }
        }
        return this;
    }

    @Override
    @NotNull
    public ItemStackBuilder power(int power) {
        ItemMeta meta;
        if (this.item != null && (meta = this.item.getItemMeta()) instanceof FireworkMeta) {
            ((FireworkMeta)meta).setPower(power);
            this.item.setItemMeta(meta);
        }
        return this;
    }

    @Generated
    public BukkitItemBuilder(org.bukkit.inventory.ItemStack item) {
        this.item = item;
    }
}

