/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.particle;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.bukkit.Particle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.particle.BukkitParticleType1_9;
import sba.sl.impl.bukkit.utils.Version;
import sba.sl.impl.particle.ParticleTypeRegistry;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.pa.ParticleType;
import sba.sl.u.ResourceLocation;
import sba.sl.u.registry.RegistryItemStream;

public class BukkitParticleTypeRegistry1_9
extends ParticleTypeRegistry {
    public BukkitParticleTypeRegistry1_9() {
        this.specialType(Particle.class, BukkitParticleType1_9::new);
    }

    @Override
    @Nullable
    protected ParticleType resolveMappingPlatform(@NotNull ResourceLocation location) {
        String enumName;
        String path;
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        switch (path = location.path()) {
            case "poof": {
                enumName = "EXPLOSION_NORMAL";
                break;
            }
            case "explosion": {
                enumName = "EXPLOSION_LARGE";
                break;
            }
            case "explosion_emitter": {
                enumName = "EXPLOSION_HUGE";
                break;
            }
            case "firework": {
                enumName = "FIREWORKS_SPARK";
                break;
            }
            case "bubble": {
                enumName = "WATER_BUBBLE";
                break;
            }
            case "splash": {
                enumName = "WATER_SPLASH";
                break;
            }
            case "fishing": {
                enumName = "WATER_WAKE";
                break;
            }
            case "underwater": {
                enumName = "SUSPENDED";
                break;
            }
            case "enchanted_hit": {
                enumName = "CRIT_MAGIC";
                break;
            }
            case "smoke": {
                enumName = "SMOKE_NORMAL";
                break;
            }
            case "large_smoke": {
                enumName = "SMOKE_LARGE";
                break;
            }
            case "effect": {
                enumName = "SPELL";
                break;
            }
            case "instant_effect": {
                enumName = "SPELL_INSTANT";
                break;
            }
            case "entity_effect": {
                enumName = "SPELL_MOB";
                break;
            }
            case "ambient_entity_effect": {
                enumName = "SPELL_MOB_AMBIENT";
                break;
            }
            case "witch": {
                enumName = "SPELL_WITCH";
                break;
            }
            case "dripping_water": {
                enumName = "DRIP_WATER";
                break;
            }
            case "dripping_lava": {
                enumName = "DRIP_LAVA";
                break;
            }
            case "angry_villager": {
                enumName = "VILLAGER_ANGRY";
                break;
            }
            case "happy_villager": {
                enumName = "VILLAGER_HAPPY";
                break;
            }
            case "mycelium": {
                enumName = "TOWN_AURA";
                break;
            }
            case "enchant": {
                enumName = "ENCHANTMENT_TABLE";
                break;
            }
            case "dust": {
                enumName = "REDSTONE";
                break;
            }
            case "item_snowball": {
                enumName = "SNOWBALL";
                break;
            }
            case "item_slime": {
                enumName = "SLIME";
                break;
            }
            case "item": {
                enumName = "ITEM_CRACK";
                break;
            }
            case "block": {
                enumName = "BLOCK_CRACK";
                break;
            }
            case "rain": {
                enumName = "WATER_DROP";
                break;
            }
            case "elder_guardian": {
                enumName = "MOB_APPEARANCE";
                break;
            }
            case "totem_of_undying": {
                enumName = "TOTEM";
                break;
            }
            case "block_marker": {
                if (Version.isVersion(1, 18)) {
                    enumName = "BLOCK_MARKER";
                    break;
                }
                enumName = "BARRIER";
                break;
            }
            default: {
                enumName = path.toUpperCase(Locale.ROOT);
            }
        }
        try {
            Particle value = Particle.valueOf((String)enumName);
            return new BukkitParticleType1_9(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull ParticleType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<Particle, ParticleType>(() -> Arrays.stream(Particle.values()).filter(particle -> !particle.name().startsWith("LEGACY_")), BukkitParticleType1_9::new, particleType -> ResourceLocation.of(BukkitParticleType1_9.convertPath(particleType)), (particleType, literal) -> BukkitParticleType1_9.convertPath(particleType).contains((CharSequence)literal), (particleType, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

