/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator.audience.adapter;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Location;
import org.bukkit.SoundCategory;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.Server;
import sba.sl.i.ItemStack;
import sba.sl.i.ItemType;
import sba.sl.i.builder.ItemStackFactory;
import sba.sl.impl.bukkit.BukkitFeature;
import sba.sl.impl.bukkit.spectator.audience.adapter.BukkitAdapter;
import sba.sl.impl.bukkit.spectator.bossbar.BukkitBossBar1_8;
import sba.sl.impl.bukkit.utils.nms.ClassStorage;
import sba.sl.impl.nms.accessors.network.FriendlyByteBufAccessor;
import sba.sl.impl.nms.accessors.network.protocol.common.ClientboundCustomPayloadPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundChatPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundOpenBookPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetSubtitleTextPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetTitleTextPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetTitlesAnimationPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetTitlesPacket$TypeAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundSetTitlesPacketAccessor;
import sba.sl.impl.nms.accessors.network.protocol.game.ClientboundTabListPacketAccessor;
import sba.sl.impl.nms.accessors.resources.ResourceLocationAccessor;
import sba.sl.impl.nms.accessors.world.InteractionHandAccessor;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.StringTag;
import sba.sl.spectator.AudienceComponentLike;
import sba.sl.spectator.Book;
import sba.sl.spectator.Component;
import sba.sl.spectator.ComponentLike;
import sba.sl.spectator.TitleableAudienceComponentLike;
import sba.sl.spectator.audience.PlayerAudience;
import sba.sl.spectator.audience.adapter.PlayerAdapter;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.spectator.sound.SoundStart;
import sba.sl.spectator.sound.SoundStop;
import sba.sl.spectator.title.TimesProvider;
import sba.sl.spectator.title.Title;
import sba.sl.u.ResourceLocation;
import sba.sl.u.reflect.Reflect;

public class BukkitPlayerAdapter
extends BukkitAdapter
implements PlayerAdapter {
    public BukkitPlayerAdapter(@NotNull PlayerAudience owner, @NotNull Player commandSender) {
        super(owner, (CommandSender)commandSender);
    }

    @Override
    @NotNull
    public PlayerAudience owner() {
        return (PlayerAudience)super.owner();
    }

    @NotNull
    public Player commandSender() {
        return (Player)super.commandSender();
    }

    @Override
    public void sendMessage(@NotNull ComponentLike message) {
        Component comp = message instanceof AudienceComponentLike ? ((AudienceComponentLike)message).asComponent(this.owner()) : message.asComponent();
        this.commandSender().spigot().sendMessage(comp.as(BaseComponent.class));
    }

    @Override
    public void sendActionBar(@NotNull ComponentLike message) {
        Component comp;
        Component component = comp = message instanceof AudienceComponentLike ? ((AudienceComponentLike)message).asComponent(this.owner()) : message.asComponent();
        if (BukkitFeature.BUNGEECORD_CHAT_SEND_MESSAGE_WITH_CHAT_MESSAGE_TYPE.isSupported() && BukkitFeature.HEX_COLORS.isSupported()) {
            this.commandSender().spigot().sendMessage(ChatMessageType.ACTION_BAR, comp.as(BaseComponent.class));
        } else if (ClientboundSetTitlesPacket$TypeAccessor.CONST_ACTIONBAR.get() != null) {
            Object titleP = Reflect.construct(ClientboundSetTitlesPacketAccessor.CONSTRUCTOR_1.get(), ClientboundSetTitlesPacket$TypeAccessor.CONST_ACTIONBAR.get(), ClassStorage.asMinecraftComponent(comp));
            ClassStorage.sendNMSConstructedPacket(this.commandSender(), titleP);
        } else {
            BaseComponent[] components = new BaseComponent[]{new TextComponent(comp.toLegacy())};
            Object packet = Reflect.construct(ClientboundChatPacketAccessor.CONSTRUCTOR_0.get(), null, (byte)2);
            Reflect.setField(packet, "components", (Object)components);
            ClassStorage.sendNMSConstructedPacket(this.commandSender(), packet);
        }
    }

    @Override
    public void sendPlayerListHeaderFooter(@NotNull ComponentLike header, @NotNull ComponentLike footer) {
        block10: {
            Component footerC;
            Component headerC = header instanceof AudienceComponentLike ? ((AudienceComponentLike)header).asComponent(this.owner()) : header.asComponent();
            Component component = footerC = footer instanceof AudienceComponentLike ? ((AudienceComponentLike)footer).asComponent(this.owner()) : footer.asComponent();
            if (BukkitFeature.PLAYER_SET_PLAYER_LIST_HEADER_FOOTER_COMPONENT.isSupported()) {
                this.commandSender().setPlayerListHeaderFooter(headerC.as(BaseComponent.class), footerC.as(BaseComponent.class));
            } else {
                try {
                    Object packet;
                    Object footerComponent;
                    Object headerComponent;
                    String clearString;
                    if (Component.empty().equals(headerC)) {
                        clearString = BukkitFeature.EMPTY_COMPONENT_1_15.isSupported() ? "{\"text\": \"\"}" : "{\"translate\": \"\"}";
                        headerComponent = ClassStorage.asMinecraftComponent(clearString);
                    } else {
                        headerComponent = ClassStorage.asMinecraftComponent(headerC);
                    }
                    if (Component.empty().equals(footerC)) {
                        clearString = BukkitFeature.EMPTY_COMPONENT_1_15.isSupported() ? "{\"text\": \"\"}" : "{\"translate\": \"\"}";
                        footerComponent = ClassStorage.asMinecraftComponent(clearString);
                    } else {
                        footerComponent = ClassStorage.asMinecraftComponent(footerC);
                    }
                    if (ClientboundTabListPacketAccessor.CONSTRUCTOR_1.get() != null) {
                        packet = Reflect.construct(ClientboundTabListPacketAccessor.CONSTRUCTOR_1.get(), headerComponent, footerComponent);
                    } else {
                        packet = Reflect.construct(ClientboundTabListPacketAccessor.CONSTRUCTOR_0.get(), new Object[0]);
                        Reflect.setField(packet, ClientboundTabListPacketAccessor.FIELD_HEADER.get(), headerComponent);
                        Reflect.setField(packet, ClientboundTabListPacketAccessor.FIELD_FOOTER.get(), footerComponent);
                    }
                    ClassStorage.sendNMSConstructedPacket(this.commandSender(), packet);
                }
                catch (Throwable ignored) {
                    if (!BukkitFeature.PLAYER_SET_PLAYER_LIST_HEADER_FOOTER_TEXT.isSupported()) break block10;
                    this.commandSender().setPlayerListHeaderFooter(headerC.toLegacy(), footerC.toLegacy());
                }
            }
        }
    }

    @Override
    public void showTitle(@NotNull Title title) {
        if (BukkitFeature.DESTROYSTOKYO_TITLE.isSupported()) {
            this.commandSender().sendTitle(com.destroystokyo.paper.Title.builder().title(title.title().as(BaseComponent.class)).subtitle(title.subtitle().as(BaseComponent.class)).fadeIn((int)(title.fadeIn().toMillis() / 50L)).stay((int)(title.stay().toMillis() / 50L)).fadeOut((int)(title.fadeOut().toMillis() / 50L)).build());
            return;
        }
        try {
            Object t = ClassStorage.asMinecraftComponent(title.title());
            Object s = ClassStorage.asMinecraftComponent(title.subtitle());
            if (ClientboundSetTitlesAnimationPacketAccessor.TYPE.get() != null) {
                Object times = Reflect.construct(ClientboundSetTitlesAnimationPacketAccessor.CONSTRUCTOR_0.get(), (int)title.fadeIn().toMillis() / 50, (int)title.stay().toMillis() / 50, (int)title.fadeOut().toMillis() / 50);
                ClassStorage.sendNMSConstructedPacket(this.commandSender(), times);
                Object titleP = Reflect.construct(ClientboundSetTitleTextPacketAccessor.CONSTRUCTOR_0.get(), t);
                ClassStorage.sendNMSConstructedPacket(this.commandSender(), titleP);
                Object subtitleP = Reflect.construct(ClientboundSetSubtitleTextPacketAccessor.CONSTRUCTOR_0.get(), s);
                ClassStorage.sendNMSConstructedPacket(this.commandSender(), subtitleP);
                return;
            }
            if (ClientboundSetTitlesPacketAccessor.TYPE.get() != null) {
                Object times = Reflect.construct(ClientboundSetTitlesPacketAccessor.CONSTRUCTOR_0.get(), (int)title.fadeIn().toMillis() / 50, (int)title.stay().toMillis() / 50, (int)title.fadeOut().toMillis() / 50);
                ClassStorage.sendNMSConstructedPacket(this.commandSender(), times);
                Object titleP = Reflect.construct(ClientboundSetTitlesPacketAccessor.CONSTRUCTOR_1.get(), ClientboundSetTitlesPacket$TypeAccessor.CONST_TITLE.get(), t);
                ClassStorage.sendNMSConstructedPacket(this.commandSender(), titleP);
                Object subtitleP = Reflect.construct(ClientboundSetTitlesPacketAccessor.CONSTRUCTOR_1.get(), ClientboundSetTitlesPacket$TypeAccessor.CONST_SUBTITLE.get(), s);
                ClassStorage.sendNMSConstructedPacket(this.commandSender(), subtitleP);
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (BukkitFeature.VERBOSE_TITLE_METHOD.isSupported()) {
            this.commandSender().sendTitle(title.title().toLegacy(), title.subtitle().toLegacy(), (int)(title.fadeIn().toMillis() / 50L), (int)(title.stay().toMillis() / 50L), (int)(title.fadeOut().toMillis() / 50L));
            return;
        }
        this.commandSender().sendTitle(title.title().toLegacy(), title.subtitle().toLegacy());
    }

    @Override
    public void showTitle(@NotNull TitleableAudienceComponentLike title, @Nullable TimesProvider times) {
        this.showTitle(title.asTitle(this.owner(), times));
    }

    @Override
    public void clearTitle() {
        this.commandSender().resetTitle();
    }

    @Override
    public void showBossBar(@NotNull sba.sl.spectator.bossbar.BossBar bossBar) {
        if (bossBar instanceof BukkitBossBar1_8) {
            ((BukkitBossBar1_8)bossBar).addViewer(this.commandSender());
        } else {
            BossBar bukkitBoss = bossBar.as(BossBar.class);
            bukkitBoss.addPlayer(this.commandSender());
            if (!bukkitBoss.isVisible()) {
                bukkitBoss.setVisible(true);
            }
        }
    }

    @Override
    public void hideBossBar(@NotNull sba.sl.spectator.bossbar.BossBar bossBar) {
        if (bossBar instanceof BukkitBossBar1_8) {
            ((BukkitBossBar1_8)bossBar).removeViewer(this.commandSender());
        } else {
            bossBar.as(BossBar.class).removePlayer(this.commandSender());
        }
    }

    @Override
    public void playSound(@NotNull SoundStart sound) {
        String s = sound.soundKey().asString();
        if (!BukkitFeature.FLATTENING.isSupported() && s.startsWith("minecraft:")) {
            s = s.substring(10);
        }
        if (BukkitFeature.SOUND_CATEGORY.isSupported()) {
            this.commandSender().playSound(this.commandSender().getLocation(), s, sound.source().as(SoundCategory.class), sound.volume(), sound.pitch());
        } else {
            this.commandSender().playSound(this.commandSender().getLocation(), s, sound.volume(), sound.pitch());
        }
    }

    @Override
    public void playSound(@NotNull SoundStart sound, double x, double y, double z) {
        String s = sound.soundKey().asString();
        if (!BukkitFeature.FLATTENING.isSupported() && s.startsWith("minecraft:")) {
            s = s.substring(10);
        }
        Location location = new Location(this.commandSender().getWorld(), x, y, z);
        if (BukkitFeature.SOUND_CATEGORY.isSupported()) {
            this.commandSender().playSound(location, s, sound.source().as(SoundCategory.class), sound.volume(), sound.pitch());
        } else {
            this.commandSender().playSound(location, s, sound.volume(), sound.pitch());
        }
    }

    @Override
    public void stopSound(@NotNull SoundStop sound) {
        if (BukkitFeature.STOP_SOUND.isSupported()) {
            ResourceLocation key = sound.soundKey();
            SoundSource source = sound.source();
            if (key != null && source != null) {
                String s = key.asString();
                if (!BukkitFeature.FLATTENING.isSupported() && s.startsWith("minecraft:")) {
                    s = s.substring(10);
                }
                if (BukkitFeature.SOUND_CATEGORY.isSupported()) {
                    this.commandSender().stopSound(s, sound.source().as(SoundCategory.class));
                } else {
                    this.commandSender().stopSound(s);
                }
            } else if (key != null) {
                String s = key.asString();
                if (!BukkitFeature.FLATTENING.isSupported() && s.startsWith("minecraft:")) {
                    s = s.substring(10);
                }
                this.commandSender().stopSound(s);
            } else if (source == null && BukkitFeature.STOP_ALL_SOUNDS.isSupported()) {
                this.commandSender().stopAllSounds();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void openBook(@NotNull Book book) {
        Player player = this.commandSender();
        ArrayList<StringTag> pages = new ArrayList<StringTag>();
        for (Component page : book.pages()) {
            pages.add(new StringTag(page.toJavaJson()));
        }
        CompoundTag nbt = CompoundTag.EMPTY.with("title", book.title().toJavaJson()).with("author", book.author().toJavaJson()).with("pages", pages).with("resolved", true);
        ItemStack item = Server.isVersion(1, 20, 5) ? ItemStackFactory.builder().type(ItemType.of("minecraft:written_book")).tag(CompoundTag.EMPTY.with("minecraft:written_book_content", nbt)).build() : ItemStackFactory.builder().type(ItemType.of("minecraft:written_book")).tag(nbt).build();
        if (item == null) {
            return;
        }
        org.bukkit.inventory.ItemStack itemInHand = player.getItemInHand();
        player.setItemInHand(item.as(org.bukkit.inventory.ItemStack.class));
        try {
            if (BukkitFeature.MODERN_OPEN_BOOK_PACKET.isSupported()) {
                Object packet = Reflect.construct(ClientboundOpenBookPacketAccessor.CONSTRUCTOR_0.get(), InteractionHandAccessor.CONST_MAIN_HAND.get());
                ClassStorage.sendNMSConstructedPacket(player, packet);
            } else if (BukkitFeature.MODERN_OPEN_BOOK_PLUGIN_MESSAGE.isSupported()) {
                Object bytebuf = Reflect.construct(FriendlyByteBufAccessor.CONSTRUCTOR_0.get(), Unpooled.buffer((int)256).setByte(0, 0).writerIndex(1));
                Object location = Reflect.construct(ResourceLocationAccessor.CONSTRUCTOR_0.get(), "minecraft:book_open");
                Object packet = Reflect.construct(ClientboundCustomPayloadPacketAccessor.CONSTRUCTOR_1.get(), location, bytebuf);
                ClassStorage.sendNMSConstructedPacket(player, packet);
            } else {
                Object bytebuf = Reflect.construct(FriendlyByteBufAccessor.CONSTRUCTOR_0.get(), Unpooled.buffer((int)256).setByte(0, 0).writerIndex(1));
                Object packet = Reflect.construct(ClientboundCustomPayloadPacketAccessor.CONSTRUCTOR_0.get(), "MC|BOpen", bytebuf);
                ClassStorage.sendNMSConstructedPacket(player, packet);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            player.setItemInHand(itemInHand);
        }
    }
}

