/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator.bossbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import sba.sl.spectator.Component;
import sba.sl.spectator.bossbar.BossBar;
import sba.sl.spectator.bossbar.BossBarColor;
import sba.sl.spectator.bossbar.BossBarDivision;
import sba.sl.spectator.bossbar.BossBarFlag;
import sba.sl.spectator.bossbar.BossBarListener;
import sba.sl.spectator.bossbar.RegisteredListener;
import sba.sl.u.BasicWrapper;

public class BukkitBossBar1_9
extends BasicWrapper<BossBar>
implements sba.sl.spectator.bossbar.BossBar {
    @NotNull
    private final @NotNull List<@NotNull RegisteredListener> internalListeners = new ArrayList<RegisteredListener>();

    public BukkitBossBar1_9(@NotNull BossBar wrappedObject) {
        super(wrappedObject);
    }

    @Override
    @NotNull
    public Component title() {
        return Component.fromLegacy(((BossBar)this.wrappedObject).getTitle());
    }

    @Override
    public @NotNull sba.sl.spectator.bossbar.BossBar title(@NotNull Component title) {
        Component old = this.title();
        ((BossBar)this.wrappedObject).setTitle(title.toLegacy());
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onTitleChanged(this, old, title));
        return this;
    }

    @Override
    public float progress() {
        return (float)((BossBar)this.wrappedObject).getProgress();
    }

    @Override
    public @NotNull sba.sl.spectator.bossbar.BossBar progress(float progress) {
        ((BossBar)this.wrappedObject).setProgress((double)progress);
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onProgressChanged(this, (float)((BossBar)this.wrappedObject).getProgress(), progress));
        return this;
    }

    @Override
    @NotNull
    public @NotNull @Unmodifiable List<@NotNull BossBarFlag> flags() {
        return Arrays.stream(BossBarFlag.values()).filter(bossBarFlag -> {
            try {
                return ((BossBar)this.wrappedObject).hasFlag(BarFlag.valueOf((String)bossBarFlag.name().replace("CREATE_WORLD_FOG", "CREATE_FOG")));
            }
            catch (IllegalArgumentException ignored) {
                return false;
            }
        }).collect(Collectors.toUnmodifiableList());
    }

    @Override
    public @NotNull sba.sl.spectator.bossbar.BossBar flags(@NotNull @NotNull List<@NotNull BossBarFlag> flags) {
        ArrayList<BossBarFlag> added = new ArrayList<BossBarFlag>();
        ArrayList<BossBarFlag> removed = new ArrayList<BossBarFlag>();
        for (BarFlag value : BarFlag.values()) {
            try {
                String v = value.name().replace("CREATE_FOG", "CREATE_WORLD_FOG");
                Optional<BossBarFlag> b = flags.stream().filter(bossBarFlag -> bossBarFlag.name().equals(v)).findFirst();
                if (((BossBar)this.wrappedObject).hasFlag(value)) {
                    if (!b.isEmpty()) continue;
                    ((BossBar)this.wrappedObject).removeFlag(value);
                    try {
                        removed.add(BossBarFlag.valueOf(value.name().replace("CREATE_FOG", "CREATE_WORLD_FOG")));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                if (!b.isPresent()) continue;
                ((BossBar)this.wrappedObject).addFlag(value);
                added.add(b.get());
            }
            catch (Throwable ignored) {
                if (!((BossBar)this.wrappedObject).hasFlag(value)) continue;
                ((BossBar)this.wrappedObject).removeFlag(value);
                try {
                    removed.add(BossBarFlag.valueOf(value.name().replace("CREATE_FOG", "CREATE_WORLD_FOG")));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        this.internalListeners.forEach(registeredListener -> registeredListener.listener().onFlagsChanged(this, added, removed));
        return this;
    }

    @Override
    @NotNull
    public BossBarColor color() {
        try {
            return BossBarColor.valueOf(((BossBar)this.wrappedObject).getColor().name());
        }
        catch (IllegalArgumentException ignored) {
            return BossBarColor.PURPLE;
        }
    }

    @Override
    public @NotNull sba.sl.spectator.bossbar.BossBar color(@NotNull BossBarColor color) {
        try {
            BossBarColor old = this.color();
            ((BossBar)this.wrappedObject).setColor(BarColor.valueOf((String)color.name()));
            this.internalListeners.forEach(registeredListener -> registeredListener.listener().onColorChanged(this, old, color));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    @Override
    @NotNull
    public BossBarDivision division() {
        try {
            String style = ((BossBar)this.wrappedObject).getStyle().name().replace("SEGMENTED", "NOTCHED").replace("SOLID", "NO_DIVISION");
            return BossBarDivision.valueOf(style);
        }
        catch (IllegalArgumentException ignored) {
            return BossBarDivision.NO_DIVISION;
        }
    }

    @Override
    public @NotNull sba.sl.spectator.bossbar.BossBar division(@NotNull BossBarDivision division) {
        try {
            String style = ((BossBar)this.wrappedObject).getStyle().name().replace("NOTCHED", "SEGMENTED").replace("NO_DIVISION", "SOLID");
            BossBarDivision old = this.division();
            ((BossBar)this.wrappedObject).setStyle(BarStyle.valueOf((String)style));
            this.internalListeners.forEach(registeredListener -> registeredListener.listener().onDivisionChanged(this, old, division));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this;
    }

    @Override
    @NotNull
    public RegisteredListener addListener(@NotNull BossBarListener listener) {
        RegisteredListener registered = () -> listener;
        this.internalListeners.add(registered);
        return registered;
    }

    @Override
    public void removeListener(@NotNull RegisteredListener listener) {
        this.internalListeners.remove(listener);
    }

    public static class BukkitBossBarBuilder
    implements BossBar.Builder {
        @NotNull
        private Component title = Component.empty();
        private float progress;
        @NotNull
        private BossBarColor color = BossBarColor.PINK;
        @NotNull
        private BossBarDivision division = BossBarDivision.NO_DIVISION;
        private @Nullable Collection<@NotNull BossBarFlag> flags;
        @NotNull
        private final @NotNull List<@NotNull BossBarListener> listeners = new ArrayList<BossBarListener>();

        @Override
        @NotNull
        public BossBar.Builder flags(@NotNull @NotNull Collection<@NotNull BossBarFlag> flags) {
            this.flags = flags;
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder flags(BossBarFlag ... flags) {
            this.flags = Arrays.asList(flags);
            return this;
        }

        @Override
        @NotNull
        public BossBar.Builder listener(@NotNull BossBarListener listener) {
            this.listeners.add(listener);
            return this;
        }

        @Override
        public @NotNull sba.sl.spectator.bossbar.BossBar build() {
            BukkitBossBar1_9 boss = new BukkitBossBar1_9(Bukkit.createBossBar((String)this.title.toLegacy(), (BarColor)BarColor.PURPLE, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[0]));
            boss.color(this.color);
            boss.division(this.division);
            boss.progress(this.progress);
            if (this.flags != null && !this.flags.isEmpty()) {
                boss.flags(List.copyOf(this.flags));
            }
            this.listeners.forEach(boss::addListener);
            return boss;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder title(@NotNull Component title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder progress(float progress) {
            this.progress = progress;
            return this;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder color(@NotNull BossBarColor color) {
            if (color == null) {
                throw new NullPointerException("color is marked non-null but is null");
            }
            this.color = color;
            return this;
        }

        @Override
        @Generated
        public BukkitBossBarBuilder division(@NotNull BossBarDivision division) {
            if (division == null) {
                throw new NullPointerException("division is marked non-null but is null");
            }
            this.division = division;
            return this;
        }
    }
}

