/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.spectator.sound;

import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.BukkitServer;
import sba.sl.spectator.sound.SoundSource;
import sba.sl.spectator.sound.SoundStart;
import sba.sl.u.Preconditions;
import sba.sl.u.ResourceLocation;

public class BukkitSoundStart
implements SoundStart {
    @NotNull
    private final ResourceLocation soundKey;
    @NotNull
    private final SoundSource source;
    private final float volume;
    private final float pitch;
    @Nullable
    private final Long seed;

    @Override
    @NotNull
    public <T> T as(@NotNull Class<T> type) {
        if (type.isInstance(this)) {
            return (T)this;
        }
        throw new UnsupportedOperationException("Bukkit doesn't have any class for custom sounds, just methods");
    }

    @Override
    @NotNull
    public Object raw() {
        throw new UnsupportedOperationException("Bukkit doesn't have any class for custom sounds, just methods");
    }

    @Override
    @NotNull
    public SoundStart withSoundKey(@NotNull ResourceLocation soundKey) {
        return new BukkitSoundStart(soundKey, this.source, this.volume, this.pitch, this.seed);
    }

    @Override
    @NotNull
    public SoundStart withSource(@NotNull SoundSource source) {
        return new BukkitSoundStart(this.soundKey, source, this.volume, this.pitch, this.seed);
    }

    @Override
    @NotNull
    public SoundStart withVolume(float volume) {
        return new BukkitSoundStart(this.soundKey, this.source, volume, this.pitch, this.seed);
    }

    @Override
    @NotNull
    public SoundStart withPitch(float pitch) {
        return new BukkitSoundStart(this.soundKey, this.source, this.volume, pitch, this.seed);
    }

    @Override
    @Nullable
    public Long seed() {
        return this.seed;
    }

    @Override
    @NotNull
    public SoundStart withSeed(@Nullable Long seed) {
        return new BukkitSoundStart(this.soundKey, this.source, this.volume, this.pitch, seed);
    }

    @Override
    public @NotNull SoundStart.Builder toBuilder() {
        return new BukkitSoundStartBuilder(this.soundKey, this.source, this.volume, this.pitch, this.seed);
    }

    @Generated
    public BukkitSoundStart(@NotNull ResourceLocation soundKey, @NotNull SoundSource source, float volume, float pitch, @Nullable Long seed) {
        if (soundKey == null) {
            throw new NullPointerException("soundKey is marked non-null but is null");
        }
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        this.soundKey = soundKey;
        this.source = source;
        this.volume = volume;
        this.pitch = pitch;
        this.seed = seed;
    }

    @Override
    @NotNull
    @Generated
    public ResourceLocation soundKey() {
        return this.soundKey;
    }

    @Override
    @NotNull
    @Generated
    public SoundSource source() {
        return this.source;
    }

    @Override
    @Generated
    public float volume() {
        return this.volume;
    }

    @Override
    @Generated
    public float pitch() {
        return this.pitch;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BukkitSoundStart)) {
            return false;
        }
        BukkitSoundStart other = (BukkitSoundStart)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Float.compare(this.volume(), other.volume()) != 0) {
            return false;
        }
        if (Float.compare(this.pitch(), other.pitch()) != 0) {
            return false;
        }
        Long this$seed = this.seed();
        Long other$seed = other.seed();
        if (this$seed == null ? other$seed != null : !((Object)this$seed).equals(other$seed)) {
            return false;
        }
        ResourceLocation this$soundKey = this.soundKey();
        ResourceLocation other$soundKey = other.soundKey();
        if (this$soundKey == null ? other$soundKey != null : !((Object)this$soundKey).equals(other$soundKey)) {
            return false;
        }
        SoundSource this$source = this.source();
        SoundSource other$source = other.source();
        return !(this$source == null ? other$source != null : !this$source.equals(other$source));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BukkitSoundStart;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Float.floatToIntBits(this.volume());
        result = result * 59 + Float.floatToIntBits(this.pitch());
        Long $seed = this.seed();
        result = result * 59 + ($seed == null ? 43 : ((Object)$seed).hashCode());
        ResourceLocation $soundKey = this.soundKey();
        result = result * 59 + ($soundKey == null ? 43 : ((Object)$soundKey).hashCode());
        SoundSource $source = this.source();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BukkitSoundStart(soundKey=" + String.valueOf(this.soundKey()) + ", source=" + String.valueOf(this.source()) + ", volume=" + this.volume() + ", pitch=" + this.pitch() + ", seed=" + this.seed() + ")";
    }

    public static class BukkitSoundStartBuilder
    implements SoundStart.Builder {
        @Nullable
        private ResourceLocation soundKey;
        @NotNull
        private SoundSource source = SoundSource.soundSource("master");
        private float volume = 1.0f;
        private float pitch = 1.0f;
        @Nullable
        private Long seed;

        @Override
        @NotNull
        public SoundStart.Builder soundKey(@NotNull ResourceLocation key) {
            this.soundKey = "minecraft".equals(key.namespace()) ? ResourceLocation.of("minecraft", BukkitServer.UNSAFE_normalizeSoundKey0(key.path())) : key;
            return this;
        }

        @Override
        @NotNull
        public SoundStart.Builder soundKey(@NotNull String key) {
            return this.soundKey(ResourceLocation.of(key));
        }

        @Override
        @NotNull
        public SoundStart build() {
            Preconditions.checkNotNull(this.soundKey, "Sound key cannot be null");
            return new BukkitSoundStart(this.soundKey, this.source, this.volume, this.pitch, this.seed);
        }

        @Generated
        public BukkitSoundStartBuilder() {
        }

        @Generated
        public BukkitSoundStartBuilder(@Nullable ResourceLocation soundKey, @NotNull SoundSource source, float volume, float pitch, @Nullable Long seed) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.soundKey = soundKey;
            this.source = source;
            this.volume = volume;
            this.pitch = pitch;
            this.seed = seed;
        }

        @Override
        @Generated
        public BukkitSoundStartBuilder source(@NotNull SoundSource source) {
            if (source == null) {
                throw new NullPointerException("source is marked non-null but is null");
            }
            this.source = source;
            return this;
        }

        @Override
        @Generated
        public BukkitSoundStartBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        @Override
        @Generated
        public BukkitSoundStartBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        @Override
        @Generated
        public BukkitSoundStartBuilder seed(@Nullable Long seed) {
            this.seed = seed;
            return this;
        }
    }
}

