/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.world;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.world.BukkitWorld;
import sba.sl.u.annotations.Service;
import sba.sl.w.World;
import sba.sl.w.Worlds;

@Service
public class BukkitWorlds
extends Worlds {
    @Override
    @Nullable
    protected World getWorld0(@NotNull UUID uuid) {
        org.bukkit.World world = Bukkit.getWorld((UUID)uuid);
        if (world == null) {
            return null;
        }
        return new BukkitWorld(world);
    }

    @Override
    @Nullable
    protected World getWorld0(@NotNull String name) {
        try {
            return this.getWorld0(UUID.fromString(name));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            org.bukkit.World world = Bukkit.getWorld((String)name);
            if (world == null) {
                return null;
            }
            return new BukkitWorld(world);
        }
    }

    @Override
    @NotNull
    protected @NotNull List<@NotNull World> getWorlds0() {
        return Bukkit.getWorlds().stream().map(BukkitWorld::new).collect(Collectors.toList());
    }

    @Override
    @Nullable
    protected World fromPlatform(@NotNull Object world) {
        if (world instanceof org.bukkit.World) {
            return new BukkitWorld((org.bukkit.World)world);
        }
        return null;
    }
}

