/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.bukkit.world.weather;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.impl.bukkit.world.weather.BukkitWeatherType;
import sba.sl.impl.utils.registry.SimpleRegistryItemStream;
import sba.sl.impl.world.weather.WeatherRegistry;
import sba.sl.u.ResourceLocation;
import sba.sl.u.annotations.Service;
import sba.sl.u.registry.RegistryItemStream;
import sba.sl.w.weather.WeatherType;

@Service
public class BukkitWeatherRegistry
extends WeatherRegistry {
    public BukkitWeatherRegistry() {
        this.specialType(org.bukkit.WeatherType.class, BukkitWeatherType::new);
    }

    @Override
    @Nullable
    protected WeatherType resolveMappingPlatform(@NotNull ResourceLocation location) {
        if (!"minecraft".equals(location.namespace())) {
            return null;
        }
        try {
            org.bukkit.WeatherType value = org.bukkit.WeatherType.valueOf((String)location.path().toUpperCase(Locale.ROOT));
            return new BukkitWeatherType(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    @NotNull
    protected @NotNull RegistryItemStream<@NotNull WeatherType> getRegistryItemStream0() {
        return new SimpleRegistryItemStream<org.bukkit.WeatherType, WeatherType>(() -> Arrays.stream(org.bukkit.WeatherType.values()), BukkitWeatherType::new, weatherType -> ResourceLocation.of(weatherType.name()), (weatherType, literal) -> weatherType.name().toLowerCase(Locale.ROOT).contains((CharSequence)literal), (weatherType, namespace) -> "minecraft".equals(namespace), List.of());
    }
}

