/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.entity.type;

import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.api.types.server.EntityTypeHolder;
import sba.sl.e.type.EntityType;
import sba.sl.impl.utils.registry.SimpleRegistry;
import sba.sl.u.Preconditions;
import sba.sl.u.annotations.ProvidedService;
import sba.sl.u.annotations.methods.OnPostConstruct;

@ProvidedService
@ApiStatus.Internal
public abstract class EntityTypeRegistry
extends SimpleRegistry<EntityType> {
    @Nullable
    private static EntityTypeRegistry registry;

    public EntityTypeRegistry() {
        super(EntityType.class);
        Preconditions.checkArgument(registry == null, "EntityTypeMapping is already initialized!");
        registry = this;
    }

    @NotNull
    public static EntityTypeRegistry getInstance() {
        return Preconditions.checkNotNull(registry, "EntityTypeRegistry is not initialized yet!");
    }

    @OnPostConstruct
    public void aliasMapping() {
        this.mapAlias("ZOMBIFIED_PIGLIN", "ZOMBIE_PIGMAN");
        this.mapAlias("oak_boat", "boat");
        this.mapAlias("oak_chest_boat", "chest_boat");
    }

    static {
        EntityTypeHolder.Provider.registerProvider(o -> Objects.requireNonNull((EntityType)EntityTypeRegistry.getInstance().resolveMapping(o), "Could not wrap " + String.valueOf(o) + " to EntityType"));
    }
}

