/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.impl.item.meta;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.BasicConfigurationNode;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.sl.co.PotionEffectSerializer;
import sba.sl.i.meta.Enchantment;
import sba.sl.i.meta.PotionEffect;
import sba.sl.i.meta.PotionEffectType;
import sba.sl.u.Preconditions;
import sba.sl.u.ResourceLocation;
import sba.sl.u.RomanToDecimal;
import sba.sl.u.annotations.ProvidedService;

@ProvidedService
@ApiStatus.Internal
public abstract class PotionEffectRegistry {
    @NotNull
    private static final Pattern RESOLUTION_PATTERN = Pattern.compile("^(?<namespaced>[A-Za-z][A-Za-z0-9_.\\-/:]*)(\\s+(?<level>(\\d+|(?=[MDCLXVI])M*(C[MD]|D?C*)(X[CL]|L?X*)(I[XV]|V?I*)))?)?$");
    @Nullable
    private static PotionEffectRegistry registry;
    @NotNull
    private final @NotNull Map<@NotNull Class<?>, Function<@NotNull Object, @Nullable PotionEffect>> specialMapping = new HashMap();

    protected PotionEffectRegistry() {
        Preconditions.checkArgument(registry == null, "PotionEffectRegistry is already initialized!");
        registry = this;
    }

    @Nullable
    public static PotionEffect resolve(@Nullable Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof PotionEffect) {
            return (PotionEffect)object;
        }
        Preconditions.checkNotNull(registry, "PotionEffectRegistry is not initialized yet!");
        if (!PotionEffectRegistry.registry.specialMapping.isEmpty()) {
            for (Map.Entry<Class<?>, Function<Object, PotionEffect>> sm : PotionEffectRegistry.registry.specialMapping.entrySet()) {
                if (!sm.getKey().isInstance(object)) continue;
                return sm.getValue().apply(object);
            }
        }
        if (object instanceof ConfigurationNode) {
            try {
                return PotionEffectSerializer.INSTANCE.deserialize((Type)((Object)Enchantment.class), (ConfigurationNode)object);
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (object instanceof Map) {
            try {
                return PotionEffectSerializer.INSTANCE.deserialize((Type)((Object)PotionEffect.class), BasicConfigurationNode.root().set(object));
            }
            catch (SerializationException e) {
                e.printStackTrace();
                return null;
            }
        }
        @Nullable ResourceLocation location = null;
        @Nullable String levelStr = null;
        if (object instanceof ResourceLocation) {
            location = (ResourceLocation)object;
        } else {
            String enchantment = object.toString().trim();
            Matcher matcher = RESOLUTION_PATTERN.matcher(enchantment);
            if (matcher.matches() && matcher.group("namespaced") != null) {
                location = ResourceLocation.of(matcher.group("namespaced"));
                levelStr = matcher.group("level");
            }
        }
        if (location == null) {
            return null;
        }
        PotionEffectType type = PotionEffectType.ofNullable(location);
        if (type != null) {
            if (levelStr != null && !levelStr.isEmpty()) {
                int level;
                try {
                    level = Integer.parseInt(levelStr);
                }
                catch (Throwable t) {
                    level = RomanToDecimal.romanToDecimal(levelStr);
                }
                return type.asEffect(level);
            }
            return type.asEffect();
        }
        return null;
    }

    @ApiStatus.Internal
    protected <E> void specialType(@NotNull Class<E> eClass, @NotNull @NotNull Function<@NotNull E, @Nullable PotionEffect> function) {
        this.specialMapping.put(eClass, function);
    }
}

