/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.CollectionTag;
import sba.sl.nbt.Tag;

public final class ByteArrayTag
implements CollectionTag,
Iterable<Byte> {
    private final byte @NotNull [] value;

    @NotNull
    public String toString() {
        return "ByteArrayTag(value=" + Arrays.toString(this.value) + ")";
    }

    public byte get(int index) {
        return this.value[index];
    }

    @Override
    @NotNull
    public Tag getAsTag(int index) {
        return new ByteTag(this.value[index]);
    }

    @Override
    public int size() {
        return this.value.length;
    }

    @Override
    public boolean isEmpty() {
        return this.value.length == 0;
    }

    @Override
    @NotNull
    public @NotNull Iterator<@NotNull Byte> iterator() {
        return new Iterator<Byte>(){
            private int cursor;

            @Override
            public boolean hasNext() {
                return this.cursor != ByteArrayTag.this.value.length;
            }

            @Override
            @NotNull
            public Byte next() {
                return ByteArrayTag.this.value[this.cursor++];
            }
        };
    }

    @NotNull
    public @NotNull Stream<@NotNull Byte> stream() {
        ArrayList<Byte> byteList = new ArrayList<Byte>(this.value.length);
        for (byte val : this.value) {
            byteList.add(val);
        }
        return byteList.stream();
    }

    @Generated
    public ByteArrayTag(byte @NotNull [] value) {
        this.value = value;
    }

    @Generated
    public byte @NotNull [] value() {
        return this.value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByteArrayTag)) {
            return false;
        }
        ByteArrayTag other = (ByteArrayTag)o;
        return Arrays.equals(this.value(), other.value());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.value());
        return result;
    }
}

