/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.sl.nbt.ByteArrayTag;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.DoubleTag;
import sba.sl.nbt.FloatTag;
import sba.sl.nbt.IntArrayTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.ListTag;
import sba.sl.nbt.LongArrayTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.NumericTag;
import sba.sl.nbt.ShortTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;

public class SNBTSerializer {
    private final boolean shouldSaveLongArraysDirectly;
    private final boolean serializeHeterogeneousListNonWrapped;

    @NotNull
    public String serialize(@NotNull Tag tag) {
        if (tag instanceof ByteArrayTag) {
            StringBuilder builder = new StringBuilder();
            builder.append("[B;");
            boolean first = true;
            for (byte number : ((ByteArrayTag)tag).value()) {
                if (!first) {
                    builder.append(",");
                } else {
                    first = false;
                }
                builder.append(number).append("b");
            }
            builder.append("]");
            return builder.toString();
        }
        if (tag instanceof ByteTag) {
            return ((ByteTag)tag).value() + "b";
        }
        if (tag instanceof CompoundTag) {
            StringBuilder builder = new StringBuilder();
            builder.append("{");
            AtomicBoolean first = new AtomicBoolean(true);
            ((CompoundTag)tag).forEach((s, tag1) -> {
                if (!first.get()) {
                    builder.append(",");
                } else {
                    first.set(false);
                }
                if (s.matches("[a-zA-Z][a-zA-Z\\d]*")) {
                    builder.append((String)s).append(":");
                } else {
                    builder.append("\"").append(s.replace("\"", "\\\"")).append("\":");
                }
                builder.append(this.serialize((Tag)tag1));
            });
            builder.append("}");
            return builder.toString();
        }
        if (tag instanceof DoubleTag) {
            return ((DoubleTag)tag).value() + "d";
        }
        if (tag instanceof FloatTag) {
            return ((FloatTag)tag).value() + "f";
        }
        if (tag instanceof IntArrayTag) {
            StringBuilder builder = new StringBuilder();
            builder.append("[I;");
            boolean first = true;
            for (int number : ((IntArrayTag)tag).value()) {
                if (!first) {
                    builder.append(",");
                } else {
                    first = false;
                }
                builder.append(number);
            }
            builder.append("]");
            return builder.toString();
        }
        if (tag instanceof IntTag) {
            return String.valueOf(((IntTag)tag).value());
        }
        if (tag instanceof ListTag) {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            boolean first = true;
            for (Tag t : ((ListTag)tag).value()) {
                if (!first) {
                    builder.append(",");
                } else {
                    first = false;
                }
                if (this.serializeHeterogeneousListNonWrapped && t instanceof CompoundTag && ((CompoundTag)t).isTagWrapper()) {
                    builder.append(this.serialize(Objects.requireNonNull(((CompoundTag)t).wrappedTag())));
                    continue;
                }
                builder.append(this.serialize(t));
            }
            builder.append("]");
            return builder.toString();
        }
        if (tag instanceof LongArrayTag) {
            StringBuilder builder = new StringBuilder();
            if (this.shouldSaveLongArraysDirectly) {
                builder.append("[L;");
            } else {
                builder.append("[");
            }
            boolean first = true;
            for (long number : ((LongArrayTag)tag).value()) {
                if (!first) {
                    builder.append(",");
                } else {
                    first = false;
                }
                builder.append(number).append("L");
            }
            builder.append("]");
            return builder.toString();
        }
        if (tag instanceof LongTag) {
            return ((LongTag)tag).value() + "L";
        }
        if (tag instanceof ShortTag) {
            return ((ShortTag)tag).value() + "s";
        }
        if (tag instanceof StringTag) {
            return "\"" + ((StringTag)tag).value().replace("\"", "\\\"") + "\"";
        }
        throw new IllegalArgumentException("Unknown tag " + String.valueOf(tag));
    }

    @NotNull
    public Tag deserialize(@NotNull String input) {
        char[] chars = input.toCharArray();
        AtomicInteger i = new AtomicInteger(0);
        return this.deserialize(chars, i);
    }

    @NotNull
    private Tag deserialize(char @NotNull [] chars, @NotNull AtomicInteger i) {
        this.skipWhitespaces(chars, i);
        char c = chars[i.get()];
        if (c == '{') {
            i.incrementAndGet();
            HashMap<String, Tag> map = new HashMap<String, Tag>();
            this.skipWhitespaces(chars, i);
            while (i.get() < chars.length) {
                String key;
                if (chars[i.get()] == ',') {
                    i.incrementAndGet();
                    continue;
                }
                if (chars[i.get()] == '}') {
                    i.incrementAndGet();
                    break;
                }
                this.skipWhitespaces(chars, i);
                if (chars[i.get()] == '\"' || chars[i.get()] == '\'') {
                    char usedQuote = chars[i.get()];
                    i.incrementAndGet();
                    key = this.readStringUntil(chars, i, usedQuote);
                } else {
                    key = this.readUntilControlSymbol(chars, i);
                }
                this.skipWhitespaces(chars, i);
                if (i.get() >= chars.length || chars[i.get()] != ':') {
                    throw new IllegalArgumentException("Invalid compound tag: there is no value for key " + key + " (position " + i.get() + ")");
                }
                i.incrementAndGet();
                this.skipWhitespaces(chars, i);
                if (i.get() >= chars.length) {
                    throw new IllegalArgumentException("Invalid compound tag: there is no value for key " + key + " (position " + i.get() + ")");
                }
                map.put(key, this.deserialize(chars, i));
                this.skipWhitespaces(chars, i);
            }
            return new CompoundTag(map);
        }
        if (c == '[') {
            i.incrementAndGet();
            if (chars.length > i.get() + 1 && chars[i.get() + 1] == ';') {
                char firstChar = chars[i.get()];
                i.getAndAdd(2);
                this.skipWhitespaces(chars, i);
                if (firstChar == 'B') {
                    String byteArrayString = this.readStringUntil(chars, i, ']');
                    ArrayList<Byte> bytes = new ArrayList<Byte>();
                    ByteTag testByte = new ByteTag(0);
                    for (String byteValue : byteArrayString.split(",")) {
                        NumericTag byteV = this.parseNumber(byteValue = byteValue.trim(), false);
                        if (byteV == null || !testByte.canHoldDataOfTag(byteV)) {
                            throw new IllegalArgumentException("Invalid byte tag: " + byteValue + " (position " + i.get() + ")");
                        }
                        bytes.add(byteV.byteValue());
                    }
                    byte[] result = new byte[bytes.size()];
                    for (int j = 0; j < bytes.size(); ++j) {
                        result[j] = (Byte)bytes.get(j);
                    }
                    i.incrementAndGet();
                    return new ByteArrayTag(result);
                }
                if (firstChar == 'I') {
                    String intArrayString = this.readStringUntil(chars, i, ']');
                    IntStream.Builder stream = IntStream.builder();
                    IntTag testInt = new IntTag(0);
                    for (String intValue : intArrayString.split(",")) {
                        NumericTag intV = this.parseNumber(intValue = intValue.trim(), false);
                        if (intV == null || !testInt.canHoldDataOfTag(intV)) {
                            throw new IllegalArgumentException("Invalid integer tag: " + intValue + " (position " + i.get() + ")");
                        }
                        stream.add(intV.intValue());
                    }
                    i.incrementAndGet();
                    return new IntArrayTag(stream.build().toArray());
                }
                if (firstChar == 'L') {
                    String longArrayString = this.readStringUntil(chars, i, ']');
                    LongStream.Builder stream = LongStream.builder();
                    LongTag testLong = new LongTag(0L);
                    for (String longValue : longArrayString.split(",")) {
                        NumericTag longV = this.parseNumber(longValue = longValue.trim(), true);
                        if (longV == null || !testLong.canHoldDataOfTag(longV)) {
                            throw new IllegalArgumentException("Invalid long tag: " + longValue + " (position " + i.get() + ")");
                        }
                        stream.add(longV.longValue());
                    }
                    i.incrementAndGet();
                    return new LongArrayTag(stream.build().toArray());
                }
                throw new IllegalArgumentException("Unknown array of type " + firstChar + " (position " + i.get() + ")");
            }
            ArrayList<Tag> list = new ArrayList<Tag>();
            while (i.get() < chars.length) {
                if (chars[i.get()] == ']') {
                    i.incrementAndGet();
                    break;
                }
                if (chars[i.get()] == ',') {
                    i.incrementAndGet();
                    continue;
                }
                this.skipWhitespaces(chars, i);
                if (i.get() >= chars.length) break;
                list.add(this.deserialize(chars, i));
                this.skipWhitespaces(chars, i);
            }
            return new ListTag(list);
        }
        if (c == '\'' || c == '\"') {
            i.incrementAndGet();
            return this.readUntil(chars, i, c);
        }
        String value = this.readUntilControlSymbol(chars, i);
        if (value.startsWith("uuid(") && value.endsWith(")")) {
            UUID uuid;
            String inner = value.substring(5, value.length() - 1);
            Tag deserialized = this.deserialize(inner);
            if (!(deserialized instanceof StringTag)) {
                throw new IllegalArgumentException("Expected StringTag inside uuid() function, but got " + deserialized.getClass().getName());
            }
            try {
                uuid = UUID.fromString(((StringTag)deserialized).value());
            }
            catch (IllegalArgumentException exception) {
                throw new IllegalArgumentException("Expected valid UUID inside uuid() function, but got " + ((StringTag)deserialized).value(), exception);
            }
            long mostSignificantBits = uuid.getMostSignificantBits();
            long leastSignificantBits = uuid.getLeastSignificantBits();
            return new IntArrayTag(new int[]{(int)(mostSignificantBits >> 32), (int)mostSignificantBits, (int)(leastSignificantBits >> 32), (int)leastSignificantBits});
        }
        NumericTag number = this.parseNumber(value, false);
        if (number != null) {
            return number;
        }
        return new StringTag(value);
    }

    @NotNull
    private StringTag readUntil(char @NotNull [] chars, @NotNull AtomicInteger i, char c) {
        return new StringTag(this.readStringUntil(chars, i, c));
    }

    @NotNull
    private String readStringUntil(char @NotNull [] chars, @NotNull AtomicInteger i, char c) {
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        while (i.get() < chars.length) {
            char cc = chars[i.get()];
            if (escaped) {
                escaped = false;
                switch (cc) {
                    case 'x': {
                        if (chars.length - 1 - i.get() < 2) {
                            throw new IllegalArgumentException("Unfinished \\x escape sequence (pos " + i.get() + ")");
                        }
                        String esc2 = "" + chars[i.incrementAndGet()] + chars[i.incrementAndGet()];
                        try {
                            int num = Integer.parseUnsignedInt(esc2, 16);
                            if (!Character.isValidCodePoint(num)) {
                                throw new IllegalArgumentException("Invalid character '" + esc2 + "' (pos " + i.get() + ")");
                            }
                            builder.append(Character.toString(num));
                            break;
                        }
                        catch (NumberFormatException exception) {
                            throw new IllegalArgumentException("Illegal escape sequence \\x" + esc2 + " (pos " + i.get() + ")", exception);
                        }
                    }
                    case 'u': {
                        if (chars.length - 1 - i.get() < 4) {
                            throw new IllegalArgumentException("Unfinished \\u escape sequence (pos " + i.get() + ")");
                        }
                        String esc4 = "" + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()];
                        try {
                            int num = Integer.parseUnsignedInt(esc4, 16);
                            if (!Character.isValidCodePoint(num)) {
                                throw new IllegalArgumentException("Invalid character '" + esc4 + "' (pos " + i.get() + ")");
                            }
                            builder.append(Character.toString(num));
                            break;
                        }
                        catch (NumberFormatException exception) {
                            throw new IllegalArgumentException("Illegal escape sequence \\u" + esc4 + " (pos " + i.get() + ")", exception);
                        }
                    }
                    case 'U': {
                        if (chars.length - 1 - i.get() < 8) {
                            throw new IllegalArgumentException("Unfinished \\U escape sequence (pos " + i.get() + ")");
                        }
                        String esc8 = "" + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()] + chars[i.incrementAndGet()];
                        try {
                            int num = Integer.parseUnsignedInt(esc8, 16);
                            if (!Character.isValidCodePoint(num)) {
                                throw new IllegalArgumentException("Invalid character '" + esc8 + "' (pos " + i.get() + ")");
                            }
                            builder.append(Character.toString(num));
                            break;
                        }
                        catch (NumberFormatException exception) {
                            throw new IllegalArgumentException("Illegal escape sequence \\U" + esc8 + " (pos " + i.get() + ")", exception);
                        }
                    }
                    case 'N': {
                        if (i.get() == chars.length - 1) {
                            throw new IllegalArgumentException("Unfinished \\N escape sequence (pos " + i.get() + ")");
                        }
                        if (chars[i.incrementAndGet()] != '{') {
                            throw new IllegalArgumentException("Illegal escape sequence \\N (pos " + i.get() + "): expected {, got" + chars[i.get()]);
                        }
                        StringBuilder argument = new StringBuilder();
                        boolean correctlyEnded = false;
                        while (i.get() + 1 < chars.length) {
                            char argCc = chars[i.incrementAndGet()];
                            if (argCc == '}') {
                                correctlyEnded = true;
                                break;
                            }
                            argument.append(argCc);
                        }
                        if (!correctlyEnded) {
                            throw new IllegalArgumentException("Unfinished \\N escape sequence (pos " + i.get() + "), missing ending }");
                        }
                        String arg = argument.toString();
                        try {
                            int r = Character.codePointOf(arg);
                            builder.append(Character.toString(r));
                            break;
                        }
                        catch (IllegalArgumentException exception) {
                            throw new IllegalArgumentException("Invalid character '" + arg + "' (pos " + i.get() + ")", exception);
                        }
                    }
                    case 'b': {
                        builder.append('\b');
                        break;
                    }
                    case 's': {
                        builder.append(' ');
                        break;
                    }
                    case 't': {
                        builder.append('\t');
                        break;
                    }
                    case 'n': {
                        builder.append('\n');
                        break;
                    }
                    case 'f': {
                        builder.append('\f');
                        break;
                    }
                    case 'r': {
                        builder.append('\r');
                        break;
                    }
                    default: {
                        builder.append(cc);
                        break;
                    }
                }
            } else {
                if (cc == c) {
                    i.incrementAndGet();
                    return builder.toString();
                }
                if (cc == '\\') {
                    escaped = true;
                } else {
                    builder.append(cc);
                }
            }
            i.incrementAndGet();
        }
        throw new IllegalArgumentException("String not properly ended!");
    }

    @NotNull
    private String readUntilControlSymbol(char @NotNull [] chars, @NotNull AtomicInteger i) {
        StringBuilder builder = new StringBuilder();
        boolean escaped = false;
        while (i.get() < chars.length) {
            char cc = chars[i.get()];
            if (escaped) {
                escaped = false;
                if (cc == ',' || cc == ']' || cc == '}' || cc == ':') {
                    builder.append('\\');
                    break;
                }
            } else {
                if (Character.isWhitespace(cc) || cc == ',' || cc == ']' || cc == '}' || cc == ':') break;
                if (cc == '\\') {
                    escaped = true;
                } else {
                    builder.append(cc);
                }
            }
            i.incrementAndGet();
        }
        return builder.toString();
    }

    private void skipWhitespaces(char @NotNull [] chars, @NotNull AtomicInteger i) {
        while (i.get() < chars.length && Character.isWhitespace(chars[i.get()])) {
            i.incrementAndGet();
        }
    }

    @Nullable
    private NumericTag parseNumber(String value, boolean nonsuffixedIsLong) {
        block33: {
            if (value.startsWith("bool(") && value.endsWith(")")) {
                String inner = value.substring(5, value.length() - 1);
                Tag deserialized = this.deserialize(inner);
                if (!(deserialized instanceof NumericTag)) {
                    throw new IllegalArgumentException("Expected numeric tag inside bool() function, but got " + deserialized.getClass().getName());
                }
                return ((NumericTag)deserialized).booleanValue() ? ByteTag.TRUE : ByteTag.FALSE;
            }
            if ("true".equalsIgnoreCase(value)) {
                return ByteTag.TRUE;
            }
            if ("false".equalsIgnoreCase(value)) {
                return ByteTag.FALSE;
            }
            try {
                char lastChar = value.charAt(value.length() - 1);
                Object substring = value.substring(0, value.length() - 1).replace("_", "");
                int radix = 10;
                if (((String)substring).startsWith("0x")) {
                    radix = 16;
                    substring = ((String)substring).substring(2);
                } else if (((String)substring).startsWith("0b")) {
                    radix = 2;
                    substring = ((String)substring).substring(2);
                }
                if (lastChar == 'b' || lastChar == 'B') {
                    if (((String)substring).endsWith("u")) {
                        int intV = Integer.parseInt(((String)substring).substring(0, ((String)substring).length() - 1), radix);
                        if (intV >> 8 == 0) {
                            return new ByteTag((byte)intV);
                        }
                        throw new NumberFormatException("Unsigned boolean out of range: " + intV);
                    }
                    if (((String)substring).endsWith("s")) {
                        substring = ((String)substring).substring(0, ((String)substring).length() - 1);
                    }
                    return new ByteTag(Byte.parseByte((String)substring, radix));
                }
                if (lastChar == 's' || lastChar == 'S') {
                    if (((String)substring).endsWith("u")) {
                        int intV = Integer.parseInt(((String)substring).substring(0, ((String)substring).length() - 1), radix);
                        if (intV >> 16 == 0) {
                            return new ShortTag((short)intV);
                        }
                        throw new NumberFormatException("Unsigned boolean out of range: " + intV);
                    }
                    if (((String)substring).endsWith("s")) {
                        substring = ((String)substring).substring(0, ((String)substring).length() - 1);
                    }
                    return new ShortTag(Short.parseShort((String)substring, radix));
                }
                if (lastChar == 'i' || lastChar == 'I') {
                    if (((String)substring).endsWith("u")) {
                        return new IntTag(Integer.parseUnsignedInt((String)substring, radix));
                    }
                    if (((String)substring).endsWith("s")) {
                        substring = ((String)substring).substring(0, ((String)substring).length() - 1);
                    }
                    return new IntTag(Integer.parseInt((String)substring, radix));
                }
                if (lastChar == 'l' || lastChar == 'L') {
                    if (((String)substring).endsWith("u")) {
                        return new LongTag(Long.parseUnsignedLong((String)substring, radix));
                    }
                    if (((String)substring).endsWith("s")) {
                        substring = ((String)substring).substring(0, ((String)substring).length() - 1);
                    }
                    return new LongTag(Long.parseLong((String)substring, radix));
                }
                if (radix == 10 && (lastChar == 'f' || lastChar == 'F')) {
                    float number = Float.parseFloat((String)substring);
                    if (Float.isFinite(number)) {
                        return new FloatTag(number);
                    }
                    break block33;
                }
                if (radix == 10 && (lastChar == 'd' || lastChar == 'D')) {
                    double number = Double.parseDouble((String)substring);
                    if (Double.isFinite(number)) {
                        return new DoubleTag(number);
                    }
                    break block33;
                }
                if (radix == 10 && (value.contains(".") || value.contains("e"))) {
                    double number = Double.parseDouble((String)substring + lastChar);
                    if (Double.isFinite(number)) {
                        return new DoubleTag(number);
                    }
                    break block33;
                }
                if (((String)(substring = (String)substring + lastChar)).endsWith("u")) {
                    if (nonsuffixedIsLong) {
                        return new LongTag(Long.parseUnsignedLong((String)substring, radix));
                    }
                    return new IntTag(Integer.parseUnsignedInt((String)substring, radix));
                }
                if (((String)substring).endsWith("s")) {
                    substring = ((String)substring).substring(0, ((String)substring).length() - 1);
                }
                if (nonsuffixedIsLong) {
                    return new LongTag(Long.parseLong((String)substring, radix));
                }
                return new IntTag(Integer.parseInt((String)substring, radix));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Generated
    private static boolean $default$shouldSaveLongArraysDirectly() {
        return false;
    }

    @Generated
    private static boolean $default$serializeHeterogeneousListNonWrapped() {
        return false;
    }

    @Generated
    SNBTSerializer(boolean shouldSaveLongArraysDirectly, boolean serializeHeterogeneousListNonWrapped) {
        this.shouldSaveLongArraysDirectly = shouldSaveLongArraysDirectly;
        this.serializeHeterogeneousListNonWrapped = serializeHeterogeneousListNonWrapped;
    }

    @Generated
    public static SNBTSerializerBuilder builder() {
        return new SNBTSerializerBuilder();
    }

    @Generated
    public static class SNBTSerializerBuilder {
        @Generated
        private boolean shouldSaveLongArraysDirectly$set;
        @Generated
        private boolean shouldSaveLongArraysDirectly$value;
        @Generated
        private boolean serializeHeterogeneousListNonWrapped$set;
        @Generated
        private boolean serializeHeterogeneousListNonWrapped$value;

        @Generated
        SNBTSerializerBuilder() {
        }

        @Generated
        public SNBTSerializerBuilder shouldSaveLongArraysDirectly(boolean shouldSaveLongArraysDirectly) {
            this.shouldSaveLongArraysDirectly$value = shouldSaveLongArraysDirectly;
            this.shouldSaveLongArraysDirectly$set = true;
            return this;
        }

        @Generated
        public SNBTSerializerBuilder serializeHeterogeneousListNonWrapped(boolean serializeHeterogeneousListNonWrapped) {
            this.serializeHeterogeneousListNonWrapped$value = serializeHeterogeneousListNonWrapped;
            this.serializeHeterogeneousListNonWrapped$set = true;
            return this;
        }

        @Generated
        public SNBTSerializer build() {
            boolean shouldSaveLongArraysDirectly$value = this.shouldSaveLongArraysDirectly$value;
            if (!this.shouldSaveLongArraysDirectly$set) {
                shouldSaveLongArraysDirectly$value = SNBTSerializer.$default$shouldSaveLongArraysDirectly();
            }
            boolean serializeHeterogeneousListNonWrapped$value = this.serializeHeterogeneousListNonWrapped$value;
            if (!this.serializeHeterogeneousListNonWrapped$set) {
                serializeHeterogeneousListNonWrapped$value = SNBTSerializer.$default$serializeHeterogeneousListNonWrapped();
            }
            return new SNBTSerializer(shouldSaveLongArraysDirectly$value, serializeHeterogeneousListNonWrapped$value);
        }

        @Generated
        public String toString() {
            return "SNBTSerializer.SNBTSerializerBuilder(shouldSaveLongArraysDirectly$value=" + this.shouldSaveLongArraysDirectly$value + ", serializeHeterogeneousListNonWrapped$value=" + this.serializeHeterogeneousListNonWrapped$value + ")";
        }
    }
}

