/*
 * Decompiled with CFR 0.152.
 */
package sba.sl.nbt.configurate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sba.c.ConfigurationNode;
import sba.c.serialize.SerializationException;
import sba.c.serialize.TypeSerializer;
import sba.sl.nbt.ByteArrayTag;
import sba.sl.nbt.ByteTag;
import sba.sl.nbt.CompoundTag;
import sba.sl.nbt.DoubleTag;
import sba.sl.nbt.FloatTag;
import sba.sl.nbt.IntArrayTag;
import sba.sl.nbt.IntTag;
import sba.sl.nbt.ListTag;
import sba.sl.nbt.LongArrayTag;
import sba.sl.nbt.LongTag;
import sba.sl.nbt.ShortTag;
import sba.sl.nbt.StringTag;
import sba.sl.nbt.Tag;

public class TagSerializer
implements TypeSerializer<Tag> {
    @NotNull
    public static final TagSerializer INSTANCE = new TagSerializer();
    @NotNull
    private static final String SPECIAL_TYPE_KEY = "_==";
    @NotNull
    private static final String SPECIAL_TYPE_VALUES_KEY = "values";
    @NotNull
    private static final String BYTE_ARRAY_VALUE = "NBTByteArray";
    @NotNull
    private static final String INT_ARRAY_VALUE = "NBTIntArray";
    @NotNull
    private static final String LONG_ARRAY_VALUE = "NBTLongArray";

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Tag deserialize(@NotNull Type type, @NotNull ConfigurationNode node) throws SerializationException {
        try {
            if (node.isMap()) {
                if (!node.node(SPECIAL_TYPE_KEY).virtual()) {
                    String specialType = node.node(SPECIAL_TYPE_KEY).getString();
                    if (BYTE_ARRAY_VALUE.equalsIgnoreCase(specialType)) {
                        void var7_33;
                        ConfigurationNode values = node.node(SPECIAL_TYPE_VALUES_KEY);
                        ArrayList<Byte> arrayList = new ArrayList<Byte>();
                        for (ConfigurationNode configurationNode : values.childrenList()) {
                            try {
                                arrayList.add(configurationNode.get(Integer.class, Integer.valueOf(0)).byteValue());
                            }
                            catch (SerializationException exception) {
                                String str = configurationNode.getString("");
                                if ("true".equalsIgnoreCase(str)) {
                                    arrayList.add((byte)1);
                                    continue;
                                }
                                if ("false".equalsIgnoreCase(str)) {
                                    arrayList.add((byte)0);
                                    continue;
                                }
                                arrayList.add(Byte.parseByte(str.replaceAll("[bB]", "")));
                            }
                        }
                        byte[] result = new byte[arrayList.size()];
                        boolean bl = false;
                        while (var7_33 < arrayList.size()) {
                            result[var7_33] = (Byte)arrayList.get((int)var7_33);
                            ++var7_33;
                        }
                        return new ByteArrayTag(result);
                    }
                    if (INT_ARRAY_VALUE.equalsIgnoreCase(specialType)) {
                        ConfigurationNode values = node.node(SPECIAL_TYPE_VALUES_KEY);
                        IntStream.Builder builder = IntStream.builder();
                        for (ConfigurationNode configurationNode : values.childrenList()) {
                            try {
                                builder.add(configurationNode.get(Integer.class, Integer.valueOf(0)));
                            }
                            catch (SerializationException exception) {
                                String str = configurationNode.getString("");
                                if ("true".equalsIgnoreCase(str)) {
                                    builder.add(1);
                                    continue;
                                }
                                if ("false".equalsIgnoreCase(str)) {
                                    builder.add(0);
                                    continue;
                                }
                                builder.add(Integer.parseInt(str.replaceAll("[iIsSbB]", "")));
                            }
                        }
                        return new IntArrayTag(builder.build().toArray());
                    }
                    if (LONG_ARRAY_VALUE.equalsIgnoreCase(specialType)) {
                        ConfigurationNode values = node.node(SPECIAL_TYPE_VALUES_KEY);
                        LongStream.Builder builder = LongStream.builder();
                        for (ConfigurationNode configurationNode : values.childrenList()) {
                            try {
                                builder.add(configurationNode.get(Long.class, Long.valueOf(0L)));
                            }
                            catch (SerializationException exception) {
                                String str = configurationNode.getString("");
                                if ("true".equalsIgnoreCase(str)) {
                                    builder.add(1L);
                                    continue;
                                }
                                if ("false".equalsIgnoreCase(str)) {
                                    builder.add(0L);
                                    continue;
                                }
                                builder.add(Long.parseLong(configurationNode.getString("").replaceAll("[lLiIsSbB]", "")));
                            }
                        }
                        return new LongArrayTag(builder.build().toArray());
                    }
                }
                HashMap<String, Tag> map = new HashMap<String, Tag>();
                for (Map.Entry<Object, ? extends ConfigurationNode> entry : node.childrenMap().entrySet()) {
                    Tag tag = entry.getValue().get(Tag.class);
                    if (tag == null) {
                        throw new IllegalArgumentException("Entry of NBT compound tag can't be null");
                    }
                    map.put(entry.getKey().toString(), tag);
                }
                return new CompoundTag(map);
            }
            if (node.isList()) {
                ArrayList<Tag> list = new ArrayList<Tag>();
                for (ConfigurationNode configurationNode : node.childrenList()) {
                    Tag tag = configurationNode.get(Tag.class);
                    if (tag == null) {
                        throw new IllegalArgumentException("Entry of NBT list can't be null");
                    }
                    list.add(tag);
                }
                return new ListTag(list);
            }
            Double number = null;
            try {
                number = node.get(Double.class);
            }
            catch (SerializationException values) {
                // empty catch block
            }
            if (number != null) {
                if (number.isInfinite() || number.isNaN()) {
                    throw new SerializationException("NBT numbers can't be NaN or Infinite");
                }
                if (number == (double)number.intValue()) {
                    return new IntTag(number.intValue());
                }
                if (number == (double)number.longValue()) {
                    return new LongTag(number.longValue());
                }
                String string = node.getString("");
                if (string.endsWith("f") || string.endsWith("F")) {
                    return new FloatTag(number.floatValue());
                }
                return new DoubleTag(number);
            }
            String string = node.getString("");
            if ("true".equalsIgnoreCase(string)) {
                return ByteTag.TRUE;
            }
            if ("false".equalsIgnoreCase(string)) {
                return ByteTag.FALSE;
            }
            if (string.endsWith("b") || string.endsWith("B")) {
                try {
                    return new ByteTag(Byte.parseByte(string.substring(0, string.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (string.endsWith("s") || string.endsWith("S")) {
                try {
                    return new ShortTag(Short.parseShort(string.substring(0, string.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (string.endsWith("i") || string.endsWith("I")) {
                try {
                    return new IntTag(Integer.parseInt(string.substring(0, string.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (string.endsWith("l") || string.endsWith("L")) {
                try {
                    return new LongTag(Long.parseLong(string.substring(0, string.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (string.endsWith("f") || string.endsWith("F")) {
                try {
                    return new FloatTag(Float.parseFloat(string.substring(0, string.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                }
            } else if (string.endsWith("d") || string.endsWith("D")) {
                try {
                    return new DoubleTag(Double.parseDouble(string.substring(0, string.length() - 1)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return new StringTag(string);
        }
        catch (Throwable throwable) {
            throw new SerializationException(throwable);
        }
    }

    @Override
    public void serialize(@NotNull Type type, @Nullable Tag obj, @NotNull ConfigurationNode node) throws SerializationException {
        node.set(null);
        if (obj instanceof ByteArrayTag) {
            node.node(SPECIAL_TYPE_KEY).set(BYTE_ARRAY_VALUE);
            ConfigurationNode baseNode = node.node(SPECIAL_TYPE_VALUES_KEY);
            for (Byte byteVal : (ByteArrayTag)obj) {
                baseNode.appendListNode().set(byteVal);
            }
        } else if (obj instanceof ByteTag) {
            node.set(((ByteTag)obj).value() + "b");
        } else if (obj instanceof CompoundTag) {
            node.set(Map.of());
            for (Map.Entry<String, Tag> childEntry : ((CompoundTag)obj).value().entrySet()) {
                node.node(childEntry.getKey()).set(Tag.class, childEntry.getValue());
            }
        } else if (obj instanceof DoubleTag) {
            node.set(((DoubleTag)obj).value() + "d");
        } else if (obj instanceof FloatTag) {
            node.set(((FloatTag)obj).value() + "f");
        } else if (obj instanceof IntArrayTag) {
            node.node(SPECIAL_TYPE_KEY).set(INT_ARRAY_VALUE);
            ConfigurationNode baseNode = node.node(SPECIAL_TYPE_VALUES_KEY);
            for (Integer intVal : (IntArrayTag)obj) {
                baseNode.appendListNode().set(intVal);
            }
        } else if (obj instanceof IntTag) {
            node.set(((IntTag)obj).value());
        } else if (obj instanceof ListTag) {
            node.setList(Tag.class, List.of());
            for (Tag child : ((ListTag)obj).value()) {
                if (child instanceof CompoundTag && ((CompoundTag)child).isTagWrapper()) {
                    node.appendListNode().set(Tag.class, ((CompoundTag)child).wrappedTag());
                    continue;
                }
                node.appendListNode().set(Tag.class, child);
            }
        } else if (obj instanceof LongArrayTag) {
            node.node(SPECIAL_TYPE_KEY).set(LONG_ARRAY_VALUE);
            ConfigurationNode baseNode = node.node(SPECIAL_TYPE_VALUES_KEY);
            for (Long longVal : (LongArrayTag)obj) {
                baseNode.appendListNode().set(longVal);
            }
        } else if (obj instanceof LongTag) {
            node.set(((LongTag)obj).value() + "L");
        } else if (obj instanceof ShortTag) {
            node.set(((ShortTag)obj).value() + "s");
        } else if (obj instanceof StringTag) {
            node.set(((StringTag)obj).value());
        } else {
            throw new SerializationException("Unknown tag " + String.valueOf(obj));
        }
    }
}

